/*
 * Decompiled with CFR 0.152.
 */
package jsat.regression.evaluation;

import jsat.math.OnLineStatistics;
import jsat.regression.evaluation.RegressionScore;

public class MeanSquaredError
implements RegressionScore {
    private static final long serialVersionUID = 3655567184376550126L;
    private OnLineStatistics meanError;
    private boolean rmse;

    public MeanSquaredError() {
        this(false);
    }

    public MeanSquaredError(boolean rmse) {
        this.setRMSE(rmse);
    }

    public void setRMSE(boolean rmse) {
        this.rmse = rmse;
    }

    public boolean isRMSE() {
        return this.rmse;
    }

    public MeanSquaredError(MeanSquaredError toCopy) {
        if (toCopy.meanError != null) {
            this.meanError = toCopy.meanError.clone();
        }
        this.rmse = toCopy.rmse;
    }

    @Override
    public void prepare() {
        this.meanError = new OnLineStatistics();
    }

    @Override
    public void addResult(double prediction, double trueValue, double weight) {
        if (this.meanError == null) {
            throw new RuntimeException("regression score has not been initialized");
        }
        this.meanError.add(Math.pow(prediction - trueValue, 2.0), weight);
    }

    @Override
    public void addResults(RegressionScore other) {
        MeanSquaredError otherObj = (MeanSquaredError)other;
        if (otherObj.meanError != null) {
            this.meanError.add(otherObj.meanError);
        }
    }

    @Override
    public double getScore() {
        if (this.rmse) {
            return Math.sqrt(this.meanError.getMean());
        }
        return this.meanError.getMean();
    }

    @Override
    public boolean lowerIsBetter() {
        return true;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this.getClass().isAssignableFrom(obj.getClass()) && obj.getClass().isAssignableFrom(this.getClass())) {
            return this.rmse == ((MeanSquaredError)obj).rmse;
        }
        return false;
    }

    @Override
    public MeanSquaredError clone() {
        return new MeanSquaredError(this);
    }

    @Override
    public String getName() {
        String prefix = this.rmse ? "Root " : "";
        return prefix + "Mean Squared Error";
    }
}

