/*
 * Decompiled with CFR 0.152.
 */
package jsat.regression.evaluation;

import jsat.regression.evaluation.TotalHistoryRegressionScore;

public class CoefficientOfDetermination
extends TotalHistoryRegressionScore {
    private static final long serialVersionUID = 1215708502913888821L;

    public CoefficientOfDetermination() {
    }

    public CoefficientOfDetermination(CoefficientOfDetermination toCopy) {
        super(toCopy);
    }

    @Override
    public double getScore() {
        double trueMean = this.truths.getVecView().mean();
        double numer = 0.0;
        double denom = 0.0;
        for (int i = 0; i < this.truths.size(); ++i) {
            numer += Math.pow(this.predictions.getD(i) - this.truths.getD(i), 2.0);
            denom += Math.pow(trueMean - this.truths.getD(i), 2.0);
        }
        return 1.0 - numer / denom;
    }

    @Override
    public boolean lowerIsBetter() {
        return true;
    }

    @Override
    public CoefficientOfDetermination clone() {
        return new CoefficientOfDetermination(this);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.getClass().isAssignableFrom(obj.getClass()) && obj.getClass().isAssignableFrom(this.getClass());
    }

    @Override
    public String getName() {
        return "Coefficient of Determination";
    }
}

