/*
 * Decompiled with CFR 0.152.
 */
package jsat.regression;

import java.util.List;
import jsat.classifiers.DataPoint;
import jsat.regression.RegressionDataSet;
import jsat.regression.Regressor;

public class AveragedRegressor
implements Regressor {
    private static final long serialVersionUID = 8870461208829349608L;
    protected Regressor[] voters;

    public AveragedRegressor(Regressor ... voters) {
        if (voters == null || voters.length == 0) {
            throw new RuntimeException("No voters given for construction");
        }
        this.voters = voters;
    }

    public AveragedRegressor(List<Regressor> voters) {
        if (voters == null || voters.isEmpty()) {
            throw new RuntimeException("No voters given for construction");
        }
        this.voters = voters.toArray(new Regressor[0]);
    }

    @Override
    public double regress(DataPoint data) {
        double r = 0.0;
        for (Regressor vote : this.voters) {
            r += vote.regress(data);
        }
        return r / (double)this.voters.length;
    }

    @Override
    public void train(RegressionDataSet dataSet, boolean parallel) {
        for (Regressor voter : this.voters) {
            voter.train(dataSet, parallel);
        }
    }

    @Override
    public void train(RegressionDataSet dataSet) {
        for (Regressor voter : this.voters) {
            voter.train(dataSet);
        }
    }

    @Override
    public boolean supportsWeightedData() {
        return false;
    }

    @Override
    public AveragedRegressor clone() {
        Regressor[] clone = new Regressor[this.voters.length];
        for (int i = 0; i < clone.length; ++i) {
            clone[i] = this.voters[i].clone();
        }
        return new AveragedRegressor(clone);
    }
}

