/*
 * Decompiled with CFR 0.152.
 */
package jsat.outlier;

import java.util.ArrayList;
import java.util.List;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.DefaultVectorCollection;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.math.SpecialMath;
import jsat.outlier.Outlier;
import jsat.utils.DoubleList;
import jsat.utils.IntList;
import jsat.utils.concurrent.ParallelUtils;

public class LoOP
implements Outlier {
    int minPnts;
    private double lambda = 3.0;
    private DistanceMetric distanceMetric;
    VectorCollection<Vec> vc = new DefaultVectorCollection<Vec>();
    private double[] standard_distance;
    private double nPLOF;

    public LoOP() {
        this(20);
    }

    public LoOP(int minPnts) {
        this(minPnts, new EuclideanDistance());
    }

    public LoOP(int minPnts, DistanceMetric dm) {
        this.setMinPnts(minPnts);
        this.setDistanceMetric(dm);
    }

    public void setMinPnts(int minPnts) {
        this.minPnts = minPnts;
    }

    public int getMinPnts() {
        return this.minPnts;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setDistanceMetric(DistanceMetric distanceMetric) {
        this.distanceMetric = distanceMetric;
    }

    public DistanceMetric getDistanceMetric() {
        return this.distanceMetric;
    }

    @Override
    public void fit(DataSet d, boolean parallel) {
        List<Vec> X = d.getDataVectors();
        this.vc.build(parallel, X, this.distanceMetric);
        int N = X.size();
        this.standard_distance = new double[N];
        ArrayList<List<Integer>> all_knn = new ArrayList<List<Integer>>();
        ArrayList<List<Double>> all_knn_dists = new ArrayList<List<Double>>();
        this.vc.search(X, this.minPnts + 1, all_knn, all_knn_dists, parallel);
        ParallelUtils.run(parallel, N, (start, end) -> {
            for (int i = start; i < end; ++i) {
                this.standard_distance[i] = Math.sqrt(((List)all_knn_dists.get(i)).stream().mapToDouble(z -> z * z).sum() / (double)this.minPnts + 1.0E-6);
            }
        });
        double[] plof_internal = new double[N];
        this.nPLOF = ParallelUtils.run(parallel, N, (start, end) -> {
            double sqrdPLOF = 0.0;
            for (int i = start; i < end; ++i) {
                double neighborSD = 0.0;
                for (int j_indx = 1; j_indx < this.minPnts + 1; ++j_indx) {
                    int neighbor = (Integer)((List)all_knn.get(i)).get(j_indx);
                    neighborSD += this.standard_distance[neighbor];
                }
                plof_internal[i] = this.standard_distance[i] / (neighborSD / (double)this.minPnts) - 1.0;
                sqrdPLOF += plof_internal[i] * plof_internal[i];
            }
            return sqrdPLOF;
        }, (a, b) -> a + b);
        this.nPLOF = Math.sqrt(this.nPLOF / (double)N);
    }

    @Override
    public double score(DataPoint x) {
        IntList knn = new IntList(this.minPnts);
        DoubleList dists = new DoubleList(this.minPnts);
        this.vc.search(x.getNumericalValues(), this.minPnts, (List<Integer>)knn, (List<Double>)dists);
        double e_pdist = 0.0;
        double stndDist_q = 0.0;
        for (int i_indx = 0; i_indx < this.minPnts; ++i_indx) {
            int neighbor = knn.get(i_indx);
            double dist = dists.get(i_indx);
            e_pdist += this.standard_distance[neighbor];
            stndDist_q += dist * dist;
        }
        stndDist_q = Math.sqrt(stndDist_q / (double)this.minPnts + 1.0E-6);
        double plof_os = stndDist_q / (e_pdist /= (double)this.minPnts) - 1.0;
        double loop = Math.max(0.0, SpecialMath.erf(plof_os / (this.lambda * this.nPLOF * Math.sqrt(2.0))));
        return -(loop - 0.5);
    }
}

