/*
 * Decompiled with CFR 0.152.
 */
package jsat.outlier;

import java.util.ArrayList;
import java.util.List;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.DefaultVectorCollection;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.outlier.Outlier;
import jsat.utils.DoubleList;
import jsat.utils.IntList;
import jsat.utils.concurrent.ParallelUtils;

public class LOF
implements Outlier {
    int minPnts;
    private DistanceMetric distanceMetric;
    VectorCollection<Vec> vc = new DefaultVectorCollection<Vec>();
    private List<Vec> X;
    private double[] k_distance;
    private double[] lrd_internal;

    public LOF() {
        this(15);
    }

    public LOF(int minPnts) {
        this(minPnts, new EuclideanDistance());
    }

    public LOF(int minPnts, DistanceMetric dm) {
        this.setMinPnts(minPnts);
        this.setDistanceMetric(dm);
    }

    public void setMinPnts(int minPnts) {
        this.minPnts = minPnts;
    }

    public int getMinPnts() {
        return this.minPnts;
    }

    public void setDistanceMetric(DistanceMetric distanceMetric) {
        this.distanceMetric = distanceMetric;
    }

    public DistanceMetric getDistanceMetric() {
        return this.distanceMetric;
    }

    @Override
    public void fit(DataSet d, boolean parallel) {
        this.X = d.getDataVectors();
        this.vc.build(parallel, this.X, this.distanceMetric);
        int N = this.X.size();
        this.k_distance = new double[N];
        ArrayList<List<Integer>> all_knn = new ArrayList<List<Integer>>();
        ArrayList<List<Double>> all_knn_dists = new ArrayList<List<Double>>();
        this.vc.search(this.X, this.minPnts + 1, all_knn, all_knn_dists, parallel);
        ParallelUtils.run(parallel, N, (start, end) -> {
            for (int i = start; i < end; ++i) {
                this.k_distance[i] = (Double)((List)all_knn_dists.get(i)).get(this.minPnts);
            }
        });
        this.lrd_internal = new double[N];
        ParallelUtils.run(parallel, N, (start, end) -> {
            for (int i = start; i < end; ++i) {
                double reachSum = 0.0;
                for (int j_indx = 1; j_indx < this.minPnts + 1; ++j_indx) {
                    int neighbor = (Integer)((List)all_knn.get(i)).get(j_indx);
                    double dist = (Double)((List)all_knn_dists.get(i)).get(j_indx);
                    reachSum += Math.max(this.k_distance[neighbor], dist);
                }
                this.lrd_internal[i] = (double)this.minPnts / reachSum;
            }
        });
    }

    double lrd(Vec a, List<Double> qi) {
        return 0.0;
    }

    @Override
    public double score(DataPoint x) {
        IntList knn = new IntList(this.minPnts);
        DoubleList dists = new DoubleList(this.minPnts);
        this.vc.search(x.getNumericalValues(), this.minPnts, (List<Integer>)knn, (List<Double>)dists);
        double lof = 0.0;
        double lrd_x = 0.0;
        for (int i_indx = 0; i_indx < this.minPnts; ++i_indx) {
            int neighbor = knn.get(i_indx);
            double dist = dists.get(i_indx);
            double reach_dist = Math.max(this.k_distance[neighbor], dist);
            lof += this.lrd_internal[neighbor];
            lrd_x += reach_dist;
        }
        lrd_x = (double)this.minPnts / lrd_x;
        return -((lof /= (double)this.minPnts * lrd_x) - 1.25);
    }
}

