/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.rootfinding;

import jsat.math.Function1D;
import jsat.math.rootfinding.RootFinder;

public class Secant
implements RootFinder {
    private static final long serialVersionUID = -5175113107084930582L;

    public static double root(double a, double b, Function1D f) {
        return Secant.root(1.0E-15, a, b, f);
    }

    public static double root(double eps, double a, double b, Function1D f) {
        return Secant.root(eps, 1000, a, b, f);
    }

    public static double root(double eps, int maxIterations, double a, double b, Function1D f) {
        double x0 = a;
        double x1 = b;
        double fx0 = f.f(x0);
        while (Math.abs(x1 - x0) > 2.0 * eps && maxIterations-- > 0) {
            double fx1 = f.f(x1);
            double nextX = x1 - fx1 * (x1 - x0) / (fx1 - fx0);
            x0 = x1;
            fx0 = fx1;
            x1 = nextX;
        }
        return x1;
    }

    @Override
    public double root(double eps, int maxIterations, double[] initialGuesses, Function1D f) {
        return Secant.root(eps, maxIterations, initialGuesses[0], initialGuesses[1], f);
    }

    @Override
    public int guessesNeeded() {
        return 2;
    }
}

