/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.List;
import java.util.Random;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.vectorcollection.VPTree;
import jsat.math.OnLineStatistics;
import jsat.utils.Pair;

public class VPTreeMV<V extends Vec>
extends VPTree<V> {
    private static final long serialVersionUID = 6668184445206226077L;

    public VPTreeMV(List<V> list, DistanceMetric dm, VPTree.VPSelection vpSelection, Random rand, int sampleSize, int searchIterations, boolean parallel) {
        super(list, dm, vpSelection, rand, sampleSize, searchIterations, parallel);
    }

    public VPTreeMV(List<V> list, DistanceMetric dm, VPTree.VPSelection vpSelection, Random rand, int sampleSize, int searchIterations) {
        super(list, dm, vpSelection, rand, sampleSize, searchIterations);
    }

    public VPTreeMV(List<V> list, DistanceMetric dm, VPTree.VPSelection vpSelection) {
        super(list, dm, vpSelection);
    }

    public VPTreeMV(List<V> list, DistanceMetric dm) {
        super(list, dm);
    }

    public VPTreeMV(List<V> list, DistanceMetric dm, boolean parallel) {
        super(list, dm, parallel);
    }

    public VPTreeMV(DistanceMetric dm) {
        super(dm);
    }

    public VPTreeMV(DistanceMetric dm, VPTree.VPSelection sampling) {
        super(dm, sampling);
    }

    public VPTreeMV() {
    }

    public VPTreeMV(VPTreeMV toClone) {
        super(toClone);
    }

    @Override
    protected int splitListIndex(List<Pair<Double, Integer>> S) {
        int splitIndex = S.size() / 2;
        int maxLeafSize = this.getMaxLeafSize();
        if (S.size() >= maxLeafSize * 4) {
            int i;
            int minSplitSize = Math.max(maxLeafSize, S.size() / 20);
            OnLineStatistics rightV = new OnLineStatistics();
            OnLineStatistics leftV = new OnLineStatistics();
            for (i = 0; i < minSplitSize; ++i) {
                leftV.add(S.get(i).getFirstItem());
            }
            for (i = minSplitSize; i < S.size(); ++i) {
                rightV.add(S.get(i).getFirstItem());
            }
            splitIndex = minSplitSize;
            double bestVar = leftV.getVarance() * (double)minSplitSize + rightV.getVarance() * (double)(S.size() - minSplitSize);
            for (int i2 = minSplitSize + 1; i2 < S.size() - minSplitSize; ++i2) {
                double tmp = S.get(i2).getFirstItem();
                leftV.add(tmp);
                rightV.remove(tmp, 1.0);
                double testVar = leftV.getVarance() * (double)i2 + rightV.getVarance() * (double)(S.size() - i2);
                if (!(testVar < bestVar)) continue;
                splitIndex = i2;
                bestVar = testVar;
            }
        }
        return splitIndex;
    }

    @Override
    public VPTreeMV<V> clone() {
        return new VPTreeMV<V>(this);
    }
}

