/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import jsat.linear.DenseVector;
import jsat.linear.Matrix;
import jsat.linear.SubMatrix;

public class HessenbergForm
implements Serializable {
    private static final long serialVersionUID = 1411467026933172901L;

    public static void hess(Matrix A) {
        HessenbergForm.hess(A, null);
    }

    public static void hess(Matrix A, ExecutorService threadpool) {
        if (!A.isSquare()) {
            throw new ArithmeticException("Only square matrices can be converted to Upper Hessenberg form");
        }
        int m = A.rows();
        DenseVector columnUpdateTmp = new DenseVector(m);
        double[] vk = new double[m];
        double[] subMatrixUpdateTmp = new double[m];
        for (int i = 0; i < m - 2; ++i) {
            double sigh;
            double s = 0.0;
            vk[i + 1] = sigh = A.get(i + 1, i);
            s += sigh * sigh;
            sigh = sigh > 0.0 ? 1.0 : -1.0;
            for (int j = i + 2; j < m; ++j) {
                double tmp;
                vk[j] = tmp = A.get(j, i);
                s += tmp * tmp;
            }
            double s1 = -sigh * Math.sqrt(s);
            s -= vk[i + 1] * vk[i + 1];
            int n = i + 1;
            vk[n] = vk[n] - s1;
            double s1Inv = 1.0 / Math.sqrt(s += vk[i + 1] * vk[i + 1]);
            int j = i + 1;
            while (j < m) {
                int n2 = j++;
                vk[n2] = vk[n2] * s1Inv;
            }
            SubMatrix subA = new SubMatrix(A, i + 1, i, m, m);
            DenseVector vVec = new DenseVector(vk, i + 1, m);
            DenseVector tmpV = new DenseVector(subMatrixUpdateTmp, i, m);
            tmpV.zeroOut();
            vVec.multiply(subA, tmpV);
            if (threadpool == null) {
                Matrix.OuterProductUpdate(subA, vVec, tmpV, -2.0);
            } else {
                Matrix.OuterProductUpdate(subA, vVec, tmpV, -2.0, threadpool);
            }
            A.set(i + 1, i, s1);
            for (int j2 = i + 2; j2 < m; ++j2) {
                A.set(j2, i, 0.0);
            }
            subA = new SubMatrix(A, 0, i + 1, m, m);
            columnUpdateTmp.zeroOut();
            ((Matrix)subA).multiply(vVec, 1.0, columnUpdateTmp);
            if (threadpool == null) {
                Matrix.OuterProductUpdate(subA, columnUpdateTmp, vVec, -2.0);
                continue;
            }
            Matrix.OuterProductUpdate(subA, columnUpdateTmp, vVec, -2.0, threadpool);
        }
    }
}

