/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.kernels;

import java.util.List;
import jsat.distributions.kernels.KernelTrick;
import jsat.linear.Vec;
import jsat.utils.DoubleList;

public abstract class BaseL2Kernel
implements KernelTrick {
    private static final long serialVersionUID = 2917497058710848085L;

    @Override
    public abstract double eval(Vec var1, Vec var2);

    @Override
    public abstract KernelTrick clone();

    @Override
    public boolean supportsAcceleration() {
        return true;
    }

    protected double getSqrdNorm(int i, int j, List<? extends Vec> vecs, List<Double> cache) {
        if (cache == null) {
            return Math.pow(vecs.get(i).pNormDist(2.0, vecs.get(j)), 2.0);
        }
        return cache.get(i) + cache.get(j) - 2.0 * vecs.get(i).dot(vecs.get(j));
    }

    protected double getSqrdNorm(int i, List<? extends Vec> vecs, List<Double> cache) {
        return cache.get(i);
    }

    protected double getSqrdNorm(int i, Vec y, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
        if (cache == null) {
            return Math.pow(vecs.get(i).pNormDist(2.0, y), 2.0);
        }
        return cache.get(i) + qi.get(0) - 2.0 * vecs.get(i).dot(y);
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> trainingSet) {
        DoubleList cache = new DoubleList(trainingSet.size());
        for (int i = 0; i < trainingSet.size(); ++i) {
            cache.add(trainingSet.get(i).dot(trainingSet.get(i)));
        }
        return cache;
    }

    @Override
    public List<Double> getQueryInfo(Vec q) {
        DoubleList dl = new DoubleList(1);
        dl.add(q.dot(q));
        return dl;
    }

    @Override
    public void addToCache(Vec newVec, List<Double> cache) {
        cache.add(newVec.dot(newVec));
    }

    @Override
    public abstract double eval(int var1, Vec var2, List<Double> var3, List<? extends Vec> var4, List<Double> var5);

    @Override
    public abstract double eval(int var1, int var2, List<? extends Vec> var3, List<Double> var4);

    @Override
    public double evalSum(List<? extends Vec> finalSet, List<Double> cache, double[] alpha, Vec y, int start, int end) {
        return this.evalSum(finalSet, cache, alpha, y, this.getQueryInfo(y), start, end);
    }

    @Override
    public double evalSum(List<? extends Vec> finalSet, List<Double> cache, double[] alpha, Vec y, List<Double> qi, int start, int end) {
        double sum = 0.0;
        for (int i = start; i < end; ++i) {
            if (alpha[i] == 0.0) continue;
            sum += alpha[i] * this.eval(i, y, qi, finalSet, cache);
        }
        return sum;
    }
}

