/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.kernels;

import java.util.List;
import jsat.distributions.kernels.KernelTrick;
import jsat.linear.Vec;

public abstract class BaseKernelTrick
implements KernelTrick {
    private static final long serialVersionUID = 7230585838672226751L;

    @Override
    public boolean supportsAcceleration() {
        return false;
    }

    @Override
    public List<Double> getAccelerationCache(List<? extends Vec> trainingSet) {
        return null;
    }

    @Override
    public List<Double> getQueryInfo(Vec q) {
        return null;
    }

    @Override
    public void addToCache(Vec newVec, List<Double> cache) {
    }

    @Override
    public double eval(int a, int b, List<? extends Vec> trainingSet, List<Double> cache) {
        return this.eval(trainingSet.get(a), trainingSet.get(b));
    }

    @Override
    public double eval(int a, Vec b, List<Double> qi, List<? extends Vec> vecs, List<Double> cache) {
        return this.eval(vecs.get(a), b);
    }

    @Override
    public double evalSum(List<? extends Vec> finalSet, List<Double> cache, double[] alpha, Vec y, int start, int end) {
        return this.evalSum(finalSet, cache, alpha, y, this.getQueryInfo(y), start, end);
    }

    @Override
    public double evalSum(List<? extends Vec> finalSet, List<Double> cache, double[] alpha, Vec y, List<Double> qi, int start, int end) {
        double sum = 0.0;
        for (int i = start; i < end; ++i) {
            sum += alpha[i] * this.eval(i, y, qi, finalSet, cache);
        }
        return sum;
    }

    @Override
    public abstract KernelTrick clone();

    @Override
    public boolean normalized() {
        return false;
    }
}

