/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.empirical.kernelfunc;

import jsat.distributions.Normal;
import jsat.distributions.empirical.kernelfunc.KernelFunction;

public class GaussKF
implements KernelFunction {
    private static final long serialVersionUID = -6765390012694573184L;

    private GaussKF() {
    }

    public static GaussKF getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public double k(double u) {
        return Normal.pdf(u, 0.0, 1.0);
    }

    @Override
    public double intK(double u) {
        return Normal.cdf(u, 0.0, 1.0);
    }

    @Override
    public double k2() {
        return 1.0;
    }

    @Override
    public double cutOff() {
        return 13.0;
    }

    @Override
    public double kPrime(double u) {
        return -Math.exp(-Math.pow(u, 2.0) / 2.0) * u / Math.sqrt(Math.PI * 2);
    }

    @Override
    public String toString() {
        return "Gaussian Kernel";
    }

    private static class SingletonHolder {
        public static final GaussKF INSTANCE = new GaussKF();

        private SingletonHolder() {
        }
    }
}

