/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.empirical.kernelfunc;

import jsat.distributions.empirical.kernelfunc.KernelFunction;

public class EpanechnikovKF
implements KernelFunction {
    private static final long serialVersionUID = 8688942176576932932L;

    private EpanechnikovKF() {
    }

    public static EpanechnikovKF getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public double k(double u) {
        if (Math.abs(u) > 1.0) {
            return 0.0;
        }
        return (1.0 - u * u) * 0.75;
    }

    @Override
    public double intK(double u) {
        if (u < -1.0) {
            return 0.0;
        }
        if (u > 1.0) {
            return 1.0;
        }
        return (-u * u * u + 3.0 * u + 2.0) / 4.0;
    }

    @Override
    public double k2() {
        return 0.2;
    }

    @Override
    public double cutOff() {
        return Math.ulp(1.0f) + 1.0f;
    }

    @Override
    public double kPrime(double u) {
        if (Math.abs(u) > 1.0) {
            return 0.0;
        }
        return -u * 1.5;
    }

    @Override
    public String toString() {
        return "Epanechnikov Kernel";
    }

    private static class SingletonHolder {
        public static final EpanechnikovKF INSTANCE = new EpanechnikovKF();

        private SingletonHolder() {
        }
    }
}

