/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions.empirical.kernelfunc;

import jsat.distributions.empirical.kernelfunc.KernelFunction;

public class BiweightKF
implements KernelFunction {
    private static final long serialVersionUID = -7199542934997154186L;

    private BiweightKF() {
    }

    public static BiweightKF getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public double k(double u) {
        if (Math.abs(u) > 1.0) {
            return 0.0;
        }
        return Math.pow(1.0 - u * u, 2.0) * 0.9375;
    }

    @Override
    public double intK(double u) {
        if (u < -1.0) {
            return 0.0;
        }
        if (u > 1.0) {
            return 1.0;
        }
        return Math.pow(u + 1.0, 3.0) / 16.0 * (3.0 * u * u - 9.0 * u + 8.0);
    }

    @Override
    public double k2() {
        return 0.14285714285714285;
    }

    @Override
    public double cutOff() {
        return Math.ulp(1.0f) + 1.0f;
    }

    @Override
    public double kPrime(double u) {
        if (Math.abs(u) > 1.0) {
            return 0.0;
        }
        return 3.75 * u * (u * u - 1.0);
    }

    @Override
    public String toString() {
        return "Biweight Kernel";
    }

    private static class SingletonHolder {
        public static final BiweightKF INSTANCE = new BiweightKF();

        private SingletonHolder() {
        }
    }
}

