/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;

public class TruncatedDistribution
extends ContinuousDistribution {
    private ContinuousDistribution base;
    private double min;
    private double max;
    private double probInOrigRange;
    private double old_min_p;
    private double old_max_p;

    public TruncatedDistribution(ContinuousDistribution base, double min, double max) {
        this.base = base;
        this.min = min;
        this.max = max;
        this.computeNeeded();
    }

    @Override
    public double pdf(double x) {
        if (x <= this.min || x > this.max) {
            return 0.0;
        }
        return this.base.pdf(x) / this.probInOrigRange;
    }

    @Override
    public double cdf(double x) {
        if (x <= this.min) {
            return 0.0;
        }
        if (x >= this.max) {
            return 1.0;
        }
        return (this.base.cdf(x) - this.old_min_p) / this.probInOrigRange;
    }

    @Override
    public double invCdf(double p) {
        double old_min_p = this.base.cdf(this.min);
        double old_max_p = this.base.cdf(this.max);
        double newP = (old_max_p - old_min_p) * p + old_min_p;
        return this.base.invCdf(newP);
    }

    private void computeNeeded() {
        this.old_min_p = this.base.cdf(this.min);
        this.old_max_p = this.base.cdf(this.max);
        this.probInOrigRange = this.old_max_p - this.old_min_p;
    }

    @Override
    public String getDistributionName() {
        return "(" + this.min + ", " + this.max + "] Truncated " + this.base.getDescriptiveName();
    }

    @Override
    public String[] getVariables() {
        return this.base.getVariables();
    }

    @Override
    public double[] getCurrentVariableValues() {
        return this.base.getCurrentVariableValues();
    }

    @Override
    public void setVariable(String var, double value) {
        this.base.setVariable(var, value);
        this.computeNeeded();
    }

    @Override
    public TruncatedDistribution clone() {
        return new TruncatedDistribution(this.base.clone(), this.min, this.max);
    }

    @Override
    public void setUsingData(Vec data) {
        this.base.setUsingData(data);
        this.computeNeeded();
    }

    @Override
    public double mode() {
        double baseMode = this.base.mode();
        if (baseMode <= this.max && baseMode > this.min) {
            return baseMode;
        }
        return super.mode();
    }

    @Override
    public double min() {
        return Math.max(Math.nextUp(this.min), this.base.min());
    }

    @Override
    public double max() {
        return Math.min(this.max, this.base.max());
    }
}

