/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;

public final class Rayleigh
extends ContinuousDistribution {
    private static final long serialVersionUID = 1451949391703281531L;
    private double sig;

    public Rayleigh(double sig) {
        this.setScale(sig);
    }

    public void setScale(double sig) {
        if (sig <= 0.0 || Double.isInfinite(sig) || Double.isNaN(sig)) {
            throw new ArithmeticException("The \u03c3 parameter must be > 0, not " + sig);
        }
        this.sig = sig;
    }

    public double getScale() {
        return this.sig;
    }

    @Override
    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        double sigSqr = this.sig * this.sig;
        return x / sigSqr * Math.exp(-x * x / (2.0 * sigSqr));
    }

    @Override
    public double cdf(double x) {
        double sigSqr = this.sig * this.sig;
        return 1.0 - Math.exp(-x * x / (2.0 * sigSqr));
    }

    @Override
    public double invCdf(double p) {
        return Math.sqrt(this.sig * this.sig * Math.log(1.0 / (1.0 - p))) * Math.sqrt(2.0);
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Rayleigh";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"\u03c3"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.sig};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("\u03c3")) {
            this.setScale(value);
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new Rayleigh(this.sig);
    }

    @Override
    public void setUsingData(Vec data) {
        double tmp = 0.0;
        for (int i = 0; i < data.length(); ++i) {
            tmp += Math.pow(data.get(i), 2.0);
        }
        tmp /= (double)(2 * data.length());
        tmp = Math.sqrt(tmp);
        this.setScale(tmp);
    }

    @Override
    public double mean() {
        return this.sig * Math.sqrt(1.5707963267948966);
    }

    @Override
    public double median() {
        return this.sig * Math.sqrt(Math.log(4.0));
    }

    @Override
    public double mode() {
        return this.sig;
    }

    @Override
    public double variance() {
        return 0.42920367320510344 * this.sig * this.sig;
    }

    @Override
    public double skewness() {
        return 2.0 * Math.sqrt(Math.PI) * 0.14159265358979312 / Math.pow(0.8584073464102069, 1.5);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.sig);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rayleigh other = (Rayleigh)obj;
        return Double.doubleToLongBits(this.sig) == Double.doubleToLongBits(other.sig);
    }
}

