/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import java.util.Random;
import jsat.distributions.ContinuousDistribution;
import jsat.distributions.Gamma;
import jsat.linear.Vec;
import jsat.math.SpecialMath;

public class ChiSquared
extends ContinuousDistribution {
    private static final long serialVersionUID = 2446232102260721666L;
    double df;

    public ChiSquared(double df) {
        this.df = df;
    }

    @Override
    public double pdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return Math.exp((this.df / 2.0 - 1.0) * Math.log(x) - x / 2.0 - (this.df / 2.0 * Math.log(2.0) + SpecialMath.lnGamma(this.df / 2.0)));
    }

    @Override
    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (this.df == 2.0) {
            return 1.0 - Math.exp(-x / 2.0);
        }
        return SpecialMath.gammaP(this.df / 2.0, x / 2.0);
    }

    @Override
    public double invCdf(double p) {
        if (this.df == 2.0) {
            return 2.0 * Math.abs(Math.log(1.0 - p));
        }
        return 2.0 * SpecialMath.invGammaP(p, this.df / 2.0);
    }

    @Override
    public double min() {
        return 0.0;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Chi^2";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"df"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.df};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("df")) {
            this.df = value;
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new ChiSquared(this.df);
    }

    @Override
    public void setUsingData(Vec data) {
        this.df = Math.ceil(data.variance() / 2.0);
    }

    @Override
    public double mean() {
        return this.df;
    }

    @Override
    public double median() {
        return SpecialMath.invGammaP(0.5, this.df / 2.0) * 2.0;
    }

    @Override
    public double mode() {
        return Math.max(this.df - 2.0, 0.0);
    }

    @Override
    public double variance() {
        return 2.0 * this.df;
    }

    @Override
    public double skewness() {
        return Math.sqrt(8.0 / this.df);
    }

    @Override
    public double[] sample(int numSamples, Random rand) {
        if (this.df == 2.0) {
            return super.sample(numSamples, rand);
        }
        double[] sample = new Gamma(this.df / 2.0, 2.0).sample(numSamples, rand);
        return sample;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.df);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChiSquared other = (ChiSquared)obj;
        return Double.doubleToLongBits(this.df) == Double.doubleToLongBits(other.df);
    }
}

