/*
 * Decompiled with CFR 0.152.
 */
package jsat.distributions;

import jsat.distributions.ContinuousDistribution;
import jsat.linear.Vec;

public final class Cauchy
extends ContinuousDistribution {
    private static final long serialVersionUID = -5083645002030551206L;
    private double location;
    private double scale;

    public Cauchy(double x0, double y) {
        this.setScale(y);
        this.setLocation(x0);
    }

    public Cauchy() {
        this(0.0, 1.0);
    }

    public void setLocation(double x0) {
        this.location = x0;
    }

    public void setScale(double y) {
        if (y <= 0.0) {
            throw new ArithmeticException("The scale parameter must be > 0, not " + y);
        }
        this.scale = y;
    }

    public double getScale() {
        return this.scale;
    }

    public double getLocation() {
        return this.location;
    }

    @Override
    public double pdf(double x) {
        return 1.0 / (Math.PI * this.scale * (1.0 + Math.pow((x - this.location) / this.scale, 2.0)));
    }

    @Override
    public double cdf(double x) {
        return Math.atan((x - this.location) / this.scale) / Math.PI + 0.5;
    }

    @Override
    public double invCdf(double p) {
        return this.location + this.scale * Math.tan(Math.PI * (p - 0.5));
    }

    @Override
    public double min() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double max() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public String getDistributionName() {
        return "Cauchy";
    }

    @Override
    public String[] getVariables() {
        return new String[]{"x0", "y"};
    }

    @Override
    public double[] getCurrentVariableValues() {
        return new double[]{this.location, this.scale};
    }

    @Override
    public void setVariable(String var, double value) {
        if (var.equals("y")) {
            this.setScale(value);
        } else if (var.equals("x0")) {
            this.setLocation(value);
        }
    }

    @Override
    public ContinuousDistribution clone() {
        return new Cauchy(this.location, this.scale);
    }

    @Override
    public void setUsingData(Vec data) {
        data = data.sortedCopy();
        int n = data.length();
        this.setScale(Math.abs(data.get(n / 4) - data.get(3 * n / 4)));
        this.setLocation(data.get(n / 2));
    }

    @Override
    public double mean() {
        return Double.NaN;
    }

    @Override
    public double median() {
        return this.location;
    }

    @Override
    public double mode() {
        return this.location;
    }

    @Override
    public double variance() {
        return Double.NaN;
    }

    @Override
    public double standardDeviation() {
        return Double.NaN;
    }

    @Override
    public double skewness() {
        return Double.NaN;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.location);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.scale);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cauchy other = (Cauchy)obj;
        if (Double.doubleToLongBits(this.location) != Double.doubleToLongBits(other.location)) {
            return false;
        }
        return Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(other.scale);
    }
}

