/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.hierarchical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import jsat.DataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.KClustererBase;
import jsat.clustering.dissimilarity.AbstractClusterDissimilarity;
import jsat.clustering.dissimilarity.UpdatableClusterDissimilarity;
import jsat.math.OnLineStatistics;
import jsat.utils.IntPriorityQueue;

public class PriorityHAC
extends KClustererBase {
    private static final long serialVersionUID = -702489462117567542L;
    private UpdatableClusterDissimilarity distMeasure;
    private int[] merges;
    private DataSet curDataSet;

    public PriorityHAC(UpdatableClusterDissimilarity dissMeasure) {
        this.distMeasure = dissMeasure;
    }

    public PriorityHAC(PriorityHAC toCopy) {
        this.distMeasure = toCopy.distMeasure.clone();
        if (toCopy.merges != null) {
            this.merges = Arrays.copyOf(toCopy.merges, toCopy.merges.length);
        }
        this.curDataSet = toCopy.curDataSet.shallowClone();
    }

    @Override
    public int[] cluster(DataSet dataSet, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.getSampleSize()), designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, boolean parallel, int[] designations) {
        return this.cluster(dataSet, 2, (int)Math.sqrt(dataSet.getSampleSize()), parallel, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, boolean parallel, int[] designations) {
        return this.cluster(dataSet, clusters, clusters, parallel, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int clusters, int[] designations) {
        return this.cluster(dataSet, clusters, clusters, designations);
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, boolean parallel, int[] designations) {
        return this.cluster(dataSet, lowK, highK, designations);
    }

    private void updateDistanceTableAndQueues(List<IntPriorityQueue> P, int[] I, int k1, int k2, double[][] distanceMatrix) {
        IntPriorityQueue Pk1 = P.get(k1);
        for (int i = 0; i < P.size(); ++i) {
            if (I[i] == 0 || i == k2 || i == k1) continue;
            IntPriorityQueue curTargetQ = P.get(i);
            curTargetQ.remove(k1);
            curTargetQ.remove(k2);
            double dis = this.distMeasure.dissimilarity(k1, I[k1], k2, I[k2], i, I[i], distanceMatrix);
            AbstractClusterDissimilarity.setDistance(distanceMatrix, i, k1, dis);
            curTargetQ.add(k1);
            Pk1.add(i);
        }
    }

    private List<IntPriorityQueue> setUpProrityQueue(int[] I, final double[][] distanceMatrix) {
        ArrayList<IntPriorityQueue> P = new ArrayList<IntPriorityQueue>(I.length);
        for (int i = 0; i < I.length; ++i) {
            final int supremeIndex = i;
            IntPriorityQueue pq = new IntPriorityQueue(I.length, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    double d1 = AbstractClusterDissimilarity.getDistance(distanceMatrix, supremeIndex, o1);
                    double d2 = AbstractClusterDissimilarity.getDistance(distanceMatrix, supremeIndex, o2);
                    return Double.compare(d1, d2);
                }
            }, IntPriorityQueue.Mode.BOUNDED);
            for (int j = 0; j < I.length; ++j) {
                if (i == j) continue;
                pq.add(j);
            }
            P.add(pq);
        }
        return P;
    }

    @Override
    public int[] cluster(DataSet dataSet, int lowK, int highK, int[] designations) {
        this.curDataSet = dataSet;
        this.merges = new int[dataSet.getSampleSize() * 2 - 2];
        int[] I = new int[dataSet.getSampleSize()];
        Arrays.fill(I, 1);
        this.curDataSet = dataSet;
        OnLineStatistics distChange = new OnLineStatistics();
        double[][] distanceMatrix = AbstractClusterDissimilarity.createDistanceMatrix(dataSet, this.distMeasure);
        List<IntPriorityQueue> P = this.setUpProrityQueue(I, distanceMatrix);
        int clusterSize = lowK;
        double maxStndDevs = Double.MIN_VALUE;
        for (int k = 0; k < I.length - 1; ++k) {
            double stndDevs;
            int k1 = -1;
            int k2 = -1;
            double dk1 = Double.MAX_VALUE;
            for (int i = 0; i < P.size(); ++i) {
                double d;
                if (I[i] <= 0) continue;
                double tmp = AbstractClusterDissimilarity.getDistance(distanceMatrix, i, (Integer)P.get(i).element());
                if (!(d < dk1)) continue;
                dk1 = tmp;
                k1 = i;
                k2 = (Integer)P.get(i).element();
            }
            distChange.add(dk1);
            if (I.length - k >= lowK && I.length - k <= highK && (stndDevs = (dk1 - distChange.getMean()) / distChange.getStandardDeviation()) > maxStndDevs) {
                maxStndDevs = stndDevs;
                clusterSize = I.length - k;
            }
            P.get(k1).clear();
            P.get(k2).clear();
            this.updateDistanceTableAndQueues(P, I, k1, k2, distanceMatrix);
            this.merges[k * 2] = k2;
            this.merges[k * 2 + 1] = k1;
            int n = k1;
            I[n] = I[n] + I[k2];
            I[k2] = 0;
        }
        this.reverseMergeArray();
        if (designations == null) {
            designations = new int[dataSet.getSampleSize()];
        }
        designations = this.assignClusterDesignations(designations, clusterSize);
        return designations;
    }

    private void reverseMergeArray() {
        for (int i = 0; i < this.merges.length / 2; ++i) {
            int tmp = this.merges[i];
            this.merges[i] = this.merges[this.merges.length - i - 1];
            this.merges[this.merges.length - i - 1] = tmp;
        }
    }

    public boolean hasStoredClustering() {
        return this.curDataSet != null;
    }

    public int[] getClusterDesignations(int[] designations, int clusters) {
        if (!this.hasStoredClustering()) {
            return null;
        }
        return this.assignClusterDesignations(designations, clusters);
    }

    public List<List<DataPoint>> getClusterDesignations(int clusters) {
        if (!this.hasStoredClustering()) {
            return null;
        }
        int[] assignments = new int[this.curDataSet.getSampleSize()];
        return PriorityHAC.createClusterListFromAssignmentArray(assignments, this.curDataSet);
    }

    private int[] assignClusterDesignations(int[] designations, int clusters) {
        return PriorityHAC.assignClusterDesignations(designations, clusters, this.merges);
    }

    protected static int[] assignClusterDesignations(int[] designations, int clusters, int[] merges) {
        int curCluster = 0;
        Arrays.fill(designations, -1);
        for (int i = 0; i < merges.length; ++i) {
            if (designations[merges[i]] != -1) continue;
            designations[merges[i]] = curCluster < clusters ? curCluster++ : designations[merges[i - 1]];
        }
        return designations;
    }

    @Override
    public PriorityHAC clone() {
        return new PriorityHAC(this);
    }
}

