/*
 * Decompiled with CFR 0.152.
 */
package jsat.clustering.evaluation;

import java.util.ArrayList;
import java.util.List;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.classifiers.DataPoint;
import jsat.clustering.ClustererBase;
import jsat.clustering.evaluation.ClusterEvaluation;
import jsat.linear.MatrixStatistics;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;

public class DaviesBouldinIndex
implements ClusterEvaluation {
    private DistanceMetric dm;

    public DaviesBouldinIndex() {
        this(new EuclideanDistance());
    }

    public DaviesBouldinIndex(DaviesBouldinIndex toCopy) {
        this(toCopy.dm.clone());
    }

    public DaviesBouldinIndex(DistanceMetric dm) {
        this.dm = dm;
    }

    @Override
    public double evaluate(int[] designations, DataSet dataSet) {
        return this.evaluate(ClustererBase.createClusterListFromAssignmentArray(designations, dataSet));
    }

    @Override
    public double evaluate(List<List<DataPoint>> dataSets) {
        ArrayList<Vec> centroids = new ArrayList<Vec>(dataSets.size());
        double[] avrgCentriodDist = new double[dataSets.size()];
        for (int i = 0; i < dataSets.size(); ++i) {
            Vec mean = MatrixStatistics.meanVector(new SimpleDataSet(dataSets.get(i)));
            centroids.add(mean);
            for (DataPoint dp : dataSets.get(i)) {
                int n = i;
                avrgCentriodDist[n] = avrgCentriodDist[n] + this.dm.dist(dp.getNumericalValues(), mean);
            }
            int n = i;
            avrgCentriodDist[n] = avrgCentriodDist[n] / (double)dataSets.get(i).size();
        }
        double dbIndex = 0.0;
        for (int i = 0; i < dataSets.size(); ++i) {
            double maxPenalty = Double.NEGATIVE_INFINITY;
            for (int j = 0; j < dataSets.size(); ++j) {
                if (j == i) continue;
                double penalty = (avrgCentriodDist[i] + avrgCentriodDist[j]) / this.dm.dist((Vec)centroids.get(i), (Vec)centroids.get(j));
                maxPenalty = Math.max(maxPenalty, penalty);
            }
            dbIndex += maxPenalty;
        }
        return dbIndex / (double)dataSets.size();
    }

    @Override
    public DaviesBouldinIndex clone() {
        return new DaviesBouldinIndex(this);
    }
}

