/*
 * Decompiled with CFR 0.152.
 */
package jsat.classifiers.trees;

import jsat.DataSet;
import jsat.classifiers.trees.TreeFeatureImportanceInference;
import jsat.classifiers.trees.TreeLearner;
import jsat.classifiers.trees.TreeNodeVisitor;

public class ImportanceByUses
implements TreeFeatureImportanceInference {
    private boolean weightByDepth;

    public ImportanceByUses(boolean weightByDepth) {
        this.weightByDepth = weightByDepth;
    }

    public ImportanceByUses() {
        this(true);
    }

    @Override
    public <Type extends DataSet> double[] getImportanceStats(TreeLearner model, DataSet<Type> data) {
        double[] features = new double[data.getNumFeatures()];
        this.visit(model.getTreeNodeVisitor(), 0, features);
        return features;
    }

    private void visit(TreeNodeVisitor node, int curDepth, double[] features) {
        if (node == null) {
            return;
        }
        for (int feature : node.featuresUsed()) {
            if (this.weightByDepth) {
                int n = feature;
                features[n] = features[n] + Math.pow(2.0, -curDepth);
                continue;
            }
            int n = feature;
            features[n] = features[n] + 1.0;
        }
        if (!node.isLeaf()) {
            for (int i = 0; i < node.childrenCount(); ++i) {
                this.visit(node.getChild(i), curDepth + 1, features);
            }
        }
    }
}

