/*
 * Decompiled with CFR 0.152.
 */
package probrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellRenderer;
import probrowser.AboutDialog;
import probrowser.MainPanel;
import probrowser.MemoryMonitor;
import probrowser.MyTableModelInfo;
import probrowser.editor.SimpleEditor;
import promc.io.ProMC;
import promc.io.ProMCHeaderFile;
import promc.io.ProMCStatFile;
import proto.FileMC;

public class MainGui {
    private JFrame frame;
    private JMenuBar menuBar;
    private JSplitPane jSplit;
    private JScrollPane jPan1;
    private MainPanel jPan2;
    private JPanel jPanelStatus;
    private MemoryMonitor memMon;
    private JList<Object> listevents;
    private JPopupMenu popupMenu;
    private JMenuItem jpop1;
    private JMenuItem jpop2;
    private ArrayList<String> events;
    private FileMC file;
    private ProMCHeaderFile.ProMCHeader header;
    private ProMCStatFile.ProMCStat stat;
    private JTable table;
    private Map<Integer, Double> mass_map = new HashMap<Integer, Double>();
    private Map<Integer, String> name_map = new HashMap<Integer, String>();
    private Map<Integer, Integer> charge_map = new HashMap<Integer, Integer>();
    private MyTableModelInfo model = new MyTableModelInfo();
    private int unit;
    private int lunit;
    private JLabel statusBar;
    private long version = -1L;
    private String current_event = "";
    private String mess = "";
    private long ev_current = -1L;

    public MainGui(String f) {
        this.table = new JTable(this.model){
            public static final long serialVersionUID = 125L;

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                Color colcell = new Color(245, 255, 255);
                if (rowIndex % 2 == 0 && !this.isCellSelected(rowIndex, vColIndex)) {
                    c.setBackground(colcell);
                } else {
                    c.setBackground(this.getBackground());
                }
                c.setForeground(Color.black);
                if (this.isCellSelected(rowIndex, vColIndex)) {
                    c.setBackground(Color.blue);
                    c.setForeground(Color.white);
                }
                return c;
            }
        };
        this.table.setFillsViewportHeight(true);
        this.table.setShowHorizontalLines(true);
        this.table.setShowVerticalLines(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.listevents = new JList();
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                String key;
                Object o;
                int index;
                JList theList = (JList)mouseEvent.getSource();
                if (SwingUtilities.isRightMouseButton(mouseEvent) && !theList.isSelectionEmpty() && theList.locationToIndex(mouseEvent.getPoint()) == theList.getSelectedIndex()) {
                    index = theList.locationToIndex(mouseEvent.getPoint());
                    o = theList.getModel().getElementAt(index);
                    key = o.toString();
                    MainGui.this.ev_current = Long.parseLong(key) - 1L;
                    MainGui.this.popupMenu.show(theList, mouseEvent.getX(), mouseEvent.getY());
                }
                if (mouseEvent.getClickCount() == 2 && (index = theList.locationToIndex(mouseEvent.getPoint())) >= 0) {
                    o = theList.getModel().getElementAt(index);
                    key = o.toString();
                    MainGui.this.ev_current = Long.parseLong(key) - 1L;
                    ProMC.ProMCEvent s = MainGui.this.file.read(MainGui.this.ev_current);
                    MainGui.this.current_event = "  Event=" + key;
                    MainGui.this.showEventParticles(s);
                }
            }
        };
        this.listevents.addMouseListener(mouseListener);
        this.jpop1 = new JMenuItem("EventInfo");
        this.jpop2 = new JMenuItem("Particles");
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.jpop1);
        this.popupMenu.add(this.jpop2);
        this.jpop1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainGui.this.statusBar.setText("Show EventInfo");
                MainGui.this.current_event = " Event=" + Long.toString(MainGui.this.ev_current + 1L);
                ProMC.ProMCEvent s = MainGui.this.file.read(MainGui.this.ev_current);
                MainGui.this.showEventInfo(s);
            }
        });
        this.jpop2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                MainGui.this.statusBar.setText("Show Particles");
                MainGui.this.current_event = " Event=" + Long.toString(MainGui.this.ev_current + 1L);
                ProMC.ProMCEvent s = MainGui.this.file.read(MainGui.this.ev_current);
                MainGui.this.showEventParticles(s);
            }
        });
        this.statusBar = new JLabel("No file");
        if (f != null) {
            this.openFile(f);
        }
        this.frame = new JFrame("ProMC Browser");
        if (f != null) {
            this.frame.setTitle("File: " + f);
        }
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min(400, res.width), Math.min(400, res.height));
        this.frame.setSize(size);
        this.frame.setDefaultCloseOperation(3);
        this.menuBar = new JMenuBar();
        this.frame.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu("File");
        JMenu aboutMenu = new JMenu("Help");
        JMenu metaMenu = new JMenu("MetaData");
        JMenu protoMenu = new JMenu("Data layout");
        this.menuBar.add(fileMenu);
        this.menuBar.add(metaMenu);
        this.menuBar.add(protoMenu);
        this.menuBar.add(aboutMenu);
        JMenuItem item00 = new JMenuItem(new OpenAction());
        fileMenu.add(item00);
        JMenuItem item01 = new JMenuItem(new ExitAction());
        fileMenu.add(item01);
        JMenuItem item11 = new JMenuItem(new ShowAboutAction());
        aboutMenu.add(item11);
        JMenuItem item21 = new JMenuItem(new ShowHeaderAction());
        metaMenu.add(item21);
        JMenuItem item22 = new JMenuItem(new ShowParticleDataAction());
        metaMenu.add(item22);
        JMenuItem item23 = new JMenuItem(new ShowStatisticsAction());
        metaMenu.add(item23);
        JMenuItem item24 = new JMenuItem(new ShowLogFileAction());
        metaMenu.add(item24);
        JMenuItem item31 = new JMenuItem(new ShowDescriptionProtoAction());
        protoMenu.add(item31);
        JMenuItem item32 = new JMenuItem(new ShowHeaderProtoAction());
        protoMenu.add(item32);
        JMenuItem item33 = new JMenuItem(new ShowEventProtoAction());
        protoMenu.add(item33);
        JMenuItem item34 = new JMenuItem(new ShowStatProtoAction());
        protoMenu.add(item34);
        this.jSplit = new JSplitPane();
        this.jSplit.setDividerLocation(0.3);
        this.jPan1 = new JScrollPane(this.listevents);
        this.jPan1.setPreferredSize(new Dimension(60, 400));
        this.jPan1.setMinimumSize(new Dimension(60, 400));
        this.jPan2 = new MainPanel(this.table);
        this.jSplit.setLeftComponent(this.jPan1);
        this.jSplit.setRightComponent(this.jPan2);
        this.memMon = new MemoryMonitor();
        this.memMon.setPreferredSize(new Dimension(65, 18));
        this.memMon.setMinimumSize(new Dimension(23, 10));
        this.jPanelStatus = new JPanel();
        this.jPanelStatus.setPreferredSize(new Dimension(700, 20));
        this.jPanelStatus.setLayout(new BorderLayout());
        this.jPanelStatus.setBorder(new EtchedBorder());
        this.jPanelStatus.add((Component)this.statusBar, "West");
        this.jPanelStatus.add((Component)this.memMon, "East");
        this.frame.getContentPane().add((Component)this.jSplit, "Center");
        this.frame.getContentPane().add((Component)this.jPanelStatus, "South");
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void openFile(String f) {
        this.file = new FileMC(f);
        this.version = this.file.getVersion();
        this.mess = "ProMC v" + Long.toString(this.version) + " Total events=" + Long.toString(this.file.getEvents());
        this.header = this.file.getHeader();
        this.unit = this.header.getMomentumUnit();
        this.lunit = this.header.getLengthUnit();
        for (int j = 0; j < this.header.getParticleDataCount(); ++j) {
            ProMCHeaderFile.ProMCHeader.ParticleData d = this.header.getParticleData(j);
            int pid = d.getId();
            double mass = d.getMass();
            String name = d.getName();
            int charge = d.getCharge();
            this.mass_map.put(new Integer(pid), mass);
            this.name_map.put(new Integer(pid), name);
            this.charge_map.put(new Integer(pid), charge);
        }
        this.stat = this.file.getStat();
        ProMC.ProMCEvent ss = this.file.read(1L);
        ProMC.ProMCEvent.Particles pa = ss.getParticles();
        String mess_nlo = "Is this a NLO/NNLO events?  \n If yes, please run it as \"java -cp browser_promc.jar probrowser.NLO file.promc\"";
        try {
            int aa = pa.getMother1Count();
            int bb = pa.getXCount();
            if (aa == 0 && bb == 0) {
                JOptionPane.showMessageDialog(this.frame, mess_nlo, "Failure", 0);
                System.exit(0);
            }
        }
        catch (IndexOutOfBoundsException | NoSuchMethodError e) {
            JOptionPane.showMessageDialog(this.frame, mess_nlo, "Failure", 0);
            System.exit(0);
        }
        this.model = new MyTableModelInfo();
        this.model.addColumn("Description");
        this.model.addColumn("Value");
        this.model.addRow(new Object[]{new String("ProMC Version"), this.getLong(this.version)});
        this.model.addRow(new Object[]{new String("Description"), this.getString(this.file.getDescription())});
        this.model.addRow(new Object[]{new String("Last modified"), this.getString(this.file.getLastModified())});
        this.model.addRow(new Object[]{new String("Attached logfile"), this.getString(this.file.getLogfileTxt())});
        this.model.addRow(new Object[]{new String("Requested events"), new Long(this.file.getRequestedEvents())});
        this.model.addRow(new Object[]{new String("Recorded events"), new Long(this.file.getEvents())});
        if (this.header != null) {
            this.model.addRow(new Object[]{new String("eCM"), this.getDouble(this.header.getECM())});
            this.model.addRow(new Object[]{new String("S"), this.getDouble(this.header.getS())});
            this.model.addRow(new Object[]{new String("Process"), this.getString(this.header.getName())});
            this.model.addRow(new Object[]{new String("Code"), this.getInt(this.header.getCode())});
            this.model.addRow(new Object[]{new String("Momentum unit (GeV*unit)"), this.getInt(this.unit)});
            this.model.addRow(new Object[]{new String("Length   unit (mm*unit)"), this.getInt(this.lunit)});
            this.model.addRow(new Object[]{new String("id1"), this.getInt(this.header.getId1())});
            this.model.addRow(new Object[]{new String("id2"), this.getInt(this.header.getId2())});
            this.model.addRow(new Object[]{new String("pdf_id1"), this.getInt(this.header.getPdfId1())});
            this.model.addRow(new Object[]{new String("pdf_id2"), this.getInt(this.header.getPdfId2())});
            this.model.addRow(new Object[]{new String("x1"), this.getDouble(this.header.getX1())});
            this.model.addRow(new Object[]{new String("x2"), this.getDouble(this.header.getX2())});
            this.model.addRow(new Object[]{new String("ScalePDF"), this.getDouble(this.header.getScalepdf())});
            this.model.addRow(new Object[]{new String("pdf1"), this.getInt(this.header.getPdf1())});
            this.model.addRow(new Object[]{new String("pdf2"), this.getInt(this.header.getPdf2())});
        }
        if (this.stat != null) {
            this.model.addRow(new Object[]{new String("Cross section       (pb)"), this.getDouble(this.stat.getCrossSectionAccumulated())});
            this.model.addRow(new Object[]{new String("Cross section error (pb)"), this.getDouble(this.stat.getCrossSectionErrorAccumulated())});
            this.model.addRow(new Object[]{new String("Luminosity          (pb)"), this.getDouble(this.stat.getLuminosityAccumulated())});
        }
        this.table.setModel(this.model);
        this.events = new ArrayList();
        for (long i = 0L; i < this.file.size(); ++i) {
            this.events.add(new String(Long.toString(i + 1L)));
        }
        this.statusBar.setText(this.mess);
        this.listevents.setListData((Object[])this.events.toArray());
    }

    private Double getDouble(double d) {
        if (d != 0.0) {
            return new Double(d);
        }
        return -1.0;
    }

    private Integer getInt(int d) {
        if (d != 0) {
            return new Integer(d);
        }
        return -1;
    }

    private Long getLong(long d) {
        if (d != 0L) {
            return new Long(d);
        }
        return -1L;
    }

    private String getString(String d) {
        if (d != null) {
            return new String(d);
        }
        return " ";
    }

    private void showEventInfo(ProMC.ProMCEvent s) {
        String stext;
        int i;
        this.statusBar.setText(this.mess + " " + this.current_event);
        ProMC.ProMCEvent.Event ev = s.getEvent();
        this.model = new MyTableModelInfo();
        this.model.addColumn("Description");
        this.model.addColumn("Value");
        this.model.addRow(new Object[]{new String("Process_ID"), this.getInt(ev.getProcessID())});
        this.model.addRow(new Object[]{new String("ID1"), this.getInt(ev.getID1())});
        this.model.addRow(new Object[]{new String("ID2"), this.getInt(ev.getID2())});
        this.model.addRow(new Object[]{new String("PDF1"), this.getDouble(ev.getPDF1())});
        this.model.addRow(new Object[]{new String("PDF2"), this.getDouble(ev.getPDF2())});
        this.model.addRow(new Object[]{new String("X1"), this.getDouble(ev.getX1())});
        this.model.addRow(new Object[]{new String("X2"), this.getDouble(ev.getX2())});
        this.model.addRow(new Object[]{new String("ScalePDF"), this.getDouble(ev.getScalePDF())});
        this.model.addRow(new Object[]{new String("AlphaQED"), this.getDouble(ev.getAlphaQED())});
        this.model.addRow(new Object[]{new String("Scale"), this.getDouble(ev.getScale())});
        this.model.addRow(new Object[]{new String("MPI"), this.getInt(ev.getMPI())});
        this.model.addRow(new Object[]{new String("Weight"), this.getDouble(ev.getWeight())});
        List<Double> fdata = ev.getFdataList();
        List<Long> idata = ev.getIdataList();
        if (idata != null && ev.getIdataCount() > 0) {
            for (i = 0; i < idata.size(); ++i) {
                stext = "int " + Integer.toString(i);
                this.model.addRow(new Object[]{new String(stext), this.getInt(idata.get(i).intValue())});
            }
        }
        if (fdata != null && ev.getFdataCount() > 0) {
            for (i = 0; i < fdata.size(); ++i) {
                stext = "double " + Integer.toString(i);
                this.model.addRow(new Object[]{new String(stext), this.getDouble(fdata.get(i))});
            }
        }
        this.table.setModel(this.model);
    }

    private void showEventParticles(ProMC.ProMCEvent s) {
        this.statusBar.setText(this.mess + " " + this.current_event);
        ProMC.ProMCEvent.Particles pa = s.getParticles();
        this.model = new MyTableModelInfo();
        this.model.addColumn("No");
        this.model.addColumn("Name");
        this.model.addColumn("PID");
        this.model.addColumn("Status");
        this.model.addColumn("M1");
        this.model.addColumn("M2");
        this.model.addColumn("D1");
        this.model.addColumn("D2");
        this.model.addColumn("Px (GeV)");
        this.model.addColumn("Py (GeV)");
        this.model.addColumn("Pz (GeV)");
        this.model.addColumn("E (GeV)");
        this.model.addColumn("M (GeV)");
        this.model.addColumn("X (mm)");
        this.model.addColumn("Y (mm)");
        this.model.addColumn("Z (mm)");
        this.model.addColumn("T (mm/c)");
        this.model.addColumn("BarCode");
        this.model.setRowCount(0);
        this.table.setModel(this.model);
        boolean energyM = false;
        boolean statusM = false;
        boolean m1M = false;
        boolean m2M = false;
        boolean d1M = false;
        boolean d2M = false;
        boolean mM = false;
        boolean xM = false;
        boolean yM = false;
        boolean zM = false;
        boolean tM = false;
        boolean bM = false;
        boolean idM = true;
        boolean pidM = false;
        boolean pxM = false;
        boolean pzM = false;
        boolean pyM = false;
        if (pa.getEnergyCount() > 1) {
            energyM = true;
        }
        if (pa.getMassCount() > 1) {
            mM = true;
        }
        if (pa.getStatusCount() > 1) {
            statusM = true;
        }
        if (pa.getMother1Count() > 1) {
            m1M = true;
        }
        if (pa.getMother2Count() > 1) {
            m2M = true;
        }
        if (pa.getDaughter1Count() > 1) {
            d1M = true;
        }
        if (pa.getDaughter2Count() > 1) {
            d2M = true;
        }
        if (pa.getXCount() > 1) {
            xM = true;
        }
        if (pa.getYCount() > 1) {
            yM = true;
        }
        if (pa.getZCount() > 1) {
            zM = true;
        }
        if (pa.getTCount() > 1) {
            tM = true;
        }
        if (pa.getBarcodeCount() > 1) {
            bM = true;
        }
        if (pa.getPdgIdCount() > 1) {
            pidM = true;
        }
        if (pa.getPxCount() > 1) {
            pxM = true;
        }
        if (pa.getPyCount() > 1) {
            pyM = true;
        }
        if (pa.getPzCount() > 1) {
            pzM = true;
        }
        idM = pa.getIdCount() > 1;
        boolean start_zero = false;
        if (pa.getId(0) == 0) {
            start_zero = true;
        }
        if (pa.getPdgId(0) == 90) {
            start_zero = false;
        }
        if (pa != null) {
            for (int j = 0; j < pa.getPxCount(); ++j) {
                int pid = 0;
                if (pidM) {
                    pid = pa.getPdgId(j);
                }
                String name = "none";
                if (this.name_map.containsKey(pid)) {
                    name = this.name_map.get(pid);
                }
                int status = 0;
                if (statusM) {
                    status = pa.getStatus(j);
                }
                double m = 0.0;
                if (mM) {
                    m = (double)pa.getMass(j) / (double)this.unit;
                } else if (this.mass_map.containsKey(pid)) {
                    m = this.mass_map.get(pid);
                }
                double px = 0.0;
                if (pxM) {
                    px = (double)pa.getPx(j) / (double)this.unit;
                }
                double py = 0.0;
                if (pyM) {
                    py = (double)pa.getPy(j) / (double)this.unit;
                }
                double pz = 0.0;
                if (pzM) {
                    pz = (double)pa.getPz(j) / (double)this.unit;
                }
                double ee = 0.0;
                ee = energyM ? (double)pa.getEnergy(j) / (double)this.unit : Math.sqrt(px * px + py * py + pz * pz + m * m);
                int m1 = 0;
                if (m1M) {
                    m1 = pa.getMother1(j);
                }
                int m2 = 0;
                if (m2M) {
                    m2 = pa.getMother2(j);
                }
                int d1 = 0;
                if (d1M) {
                    d1 = pa.getDaughter1(j);
                }
                int d2 = 0;
                if (d2M) {
                    d2 = pa.getDaughter2(j);
                }
                int barcode = 0;
                if (bM) {
                    barcode = pa.getBarcode(j);
                }
                int id = 0;
                if (idM) {
                    id = pa.getId(j);
                }
                if (start_zero) {
                    ++id;
                }
                double x = 0.0;
                if (xM) {
                    x = (double)pa.getX(j) / (double)this.lunit;
                }
                double y = 0.0;
                if (yM) {
                    y = (double)pa.getY(j) / (double)this.lunit;
                }
                double z = 0.0;
                if (zM) {
                    z = (double)pa.getZ(j) / (double)this.lunit;
                }
                double t = 0.0;
                if (tM) {
                    t = (double)pa.getT(j) / (double)this.lunit;
                }
                this.model.addRow(new Object[]{new Integer(id), new String(name), new Integer(pid), new Integer(status), new Integer(m1), new Integer(m2), new Integer(d1), new Integer(d2), new Double(px), new Double(py), new Double(pz), new Double(ee), new Double(m), new Double(x), new Double(y), new Double(z), new Double(t), new Integer(barcode)});
            }
        }
    }

    private class ShowLogFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowLogFileAction() {
            super("Log File");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainGui.this.file == null) {
                return;
            }
            String txt = MainGui.this.file.readLogfile();
            if (txt != null & txt.length() > 0) {
                new SimpleEditor(txt, true);
            } else {
                JOptionPane.showMessageDialog(MainGui.this.frame, "Log file \"logfile.txt\" not attached", "Error", 0);
            }
        }
    }

    private class ShowStatProtoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowStatProtoAction() {
            super("Statistics Layout");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String tmp = MainGui.this.file.getProMCStatTxt();
            if (tmp != null & tmp.length() > 0) {
                new SimpleEditor(tmp, false);
            } else {
                JOptionPane.showMessageDialog(MainGui.this.frame, "ProMCStat.proto not attached", "Error", 0);
            }
        }
    }

    private class ShowEventProtoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowEventProtoAction() {
            super("Event Layout");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String tmp = MainGui.this.file.getProMCTxt();
            if (tmp != null & tmp.length() > 0) {
                new SimpleEditor(tmp, false);
            } else {
                JOptionPane.showMessageDialog(MainGui.this.frame, "ProMC.proto not attached", "Error", 0);
            }
        }
    }

    private class ShowHeaderProtoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowHeaderProtoAction() {
            super("Header Layout");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String tmp = MainGui.this.file.getProMCHeaderTxt();
            if (tmp != null & tmp.length() > 0) {
                new SimpleEditor(tmp, false);
            } else {
                JOptionPane.showMessageDialog(MainGui.this.frame, "ProMCHeader.proto not attached", "Error", 0);
            }
        }
    }

    private class ShowDescriptionProtoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowDescriptionProtoAction() {
            super("Description Layout");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String tmp = MainGui.this.file.getProMCDescriptionTxt();
            if (tmp != null & tmp.length() > 0) {
                new SimpleEditor(tmp, false);
            } else {
                JOptionPane.showMessageDialog(MainGui.this.frame, "ProMCDescription.proto not attached", "Error", 0);
            }
        }
    }

    private class ShowStatisticsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowStatisticsAction() {
            super("Statistics");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainGui.this.model = new MyTableModelInfo();
            MainGui.this.model.addColumn("Description");
            MainGui.this.model.addColumn("Value");
            if (MainGui.this.stat != null) {
                MainGui.this.model.addRow(new Object[]{new String("Events tried"), new Integer(MainGui.this.stat.getNTried())});
                MainGui.this.model.addRow(new Object[]{new String("Events selected"), new Integer(MainGui.this.stat.getNSelected())});
                MainGui.this.model.addRow(new Object[]{new String("Events accepted"), new Integer(MainGui.this.stat.getNAccepted())});
                MainGui.this.model.addRow(new Object[]{new String("Cross section       (pb)"), new Double(MainGui.this.stat.getCrossSectionAccumulated())});
                MainGui.this.model.addRow(new Object[]{new String("Cross section error (pb)"), new Double(MainGui.this.stat.getCrossSectionErrorAccumulated())});
                MainGui.this.model.addRow(new Object[]{new String("Luminosity          (pb)"), new Double(MainGui.this.stat.getLuminosityAccumulated())});
            }
            MainGui.this.table.setModel(MainGui.this.model);
        }
    }

    private class ShowParticleDataAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowParticleDataAction() {
            super("Particle Data");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainGui.this.model = new MyTableModelInfo();
            MainGui.this.model.addColumn("Nr");
            MainGui.this.model.addColumn("PID");
            MainGui.this.model.addColumn("Name");
            MainGui.this.model.addColumn("Mass (GeV)");
            MainGui.this.model.addColumn("Charge");
            MainGui.this.model.addColumn("Lifetime");
            if (MainGui.this.header != null) {
                for (int j = 0; j < MainGui.this.header.getParticleDataCount(); ++j) {
                    ProMCHeaderFile.ProMCHeader.ParticleData d = MainGui.this.header.getParticleData(j);
                    String name = d.getName();
                    int charge = d.getCharge();
                    MainGui.this.model.addRow(new Object[]{new Integer(j + 1), new Integer(d.getId()), new String(name), new Double(d.getMass()), new Integer(charge), new Double(d.getLifetime())});
                }
                MainGui.this.table.setModel(MainGui.this.model);
            }
        }
    }

    private class ShowHeaderAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowHeaderAction() {
            super("Header Record");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainGui.this.model = new MyTableModelInfo();
            MainGui.this.model.addColumn("Description");
            MainGui.this.model.addColumn("Value");
            MainGui.this.model.addRow(new Object[]{new String("ProMC Version"), MainGui.this.getLong(MainGui.this.version)});
            MainGui.this.model.addRow(new Object[]{new String("Description"), new String(MainGui.this.file.getDescription())});
            MainGui.this.model.addRow(new Object[]{new String("Requested events"), MainGui.this.getLong(MainGui.this.file.getRequestedEvents())});
            MainGui.this.model.addRow(new Object[]{new String("Recorded events"), MainGui.this.getLong(MainGui.this.file.getEvents())});
            if (MainGui.this.header != null) {
                MainGui.this.model.addRow(new Object[]{new String("eCM"), MainGui.this.getDouble(MainGui.this.header.getECM())});
                MainGui.this.model.addRow(new Object[]{new String("S"), MainGui.this.getDouble(MainGui.this.header.getS())});
                MainGui.this.model.addRow(new Object[]{new String("Process"), MainGui.this.getString(MainGui.this.header.getName())});
                MainGui.this.model.addRow(new Object[]{new String("Code"), MainGui.this.getInt(MainGui.this.header.getCode())});
                MainGui.this.model.addRow(new Object[]{new String("Momentum unit"), MainGui.this.getInt(MainGui.this.unit)});
                MainGui.this.model.addRow(new Object[]{new String("Length   unit"), MainGui.this.getInt(MainGui.this.lunit)});
                MainGui.this.model.addRow(new Object[]{new String("id1"), MainGui.this.getInt(MainGui.this.header.getId1())});
                MainGui.this.model.addRow(new Object[]{new String("id2"), MainGui.this.getInt(MainGui.this.header.getId2())});
                MainGui.this.model.addRow(new Object[]{new String("pdf_id1"), MainGui.this.getInt(MainGui.this.header.getPdfId1())});
                MainGui.this.model.addRow(new Object[]{new String("pdf_id2"), MainGui.this.getInt(MainGui.this.header.getPdfId2())});
                MainGui.this.model.addRow(new Object[]{new String("x1"), MainGui.this.getDouble(MainGui.this.header.getX1())});
                MainGui.this.model.addRow(new Object[]{new String("x2"), MainGui.this.getDouble(MainGui.this.header.getX2())});
                MainGui.this.model.addRow(new Object[]{new String("ScalePDF"), MainGui.this.getDouble(MainGui.this.header.getScalepdf())});
                MainGui.this.model.addRow(new Object[]{new String("pdf1"), MainGui.this.getInt(MainGui.this.header.getPdf1())});
                MainGui.this.model.addRow(new Object[]{new String("pdf2"), MainGui.this.getInt(MainGui.this.header.getPdf2())});
                MainGui.this.model.addRow(new Object[]{new String("Cross section       (pb)"), MainGui.this.getDouble(MainGui.this.header.getCrossSection())});
                MainGui.this.model.addRow(new Object[]{new String("Cross section error (pb)"), MainGui.this.getDouble(MainGui.this.header.getCrossSectionError())});
            }
            MainGui.this.table.setModel(MainGui.this.model);
        }
    }

    private class OpenAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        OpenAction() {
            super("Open file");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File("."));
            FileNameExtensionFilter filterm3u = new FileNameExtensionFilter("ProMC file (.promc)", "promc");
            chooser.addChoosableFileFilter(filterm3u);
            try {
                String fullPath;
                int returnVal = chooser.showOpenDialog(MainGui.this.frame);
                if (returnVal == 0 && (fullPath = chooser.getSelectedFile().getAbsolutePath()) != null) {
                    MainGui.this.openFile(fullPath);
                }
            }
            catch (Exception f) {
                f.printStackTrace();
                System.out.println("Error saving file.");
            }
        }
    }

    private class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ExitAction() {
            super("Exit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainGui.this.frame.setVisible(false);
            MainGui.this.frame.dispose();
        }
    }

    private class ShowAboutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ShowAboutAction() {
            super("About");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new AboutDialog((Component)MainGui.this.frame);
        }
    }
}

