/*
 * Decompiled with CFR 0.152.
 */
package probrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import probrowser.Util;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JTabbedPane tabbedPane;
    private JButton closeButton;
    private JPanel panel1;
    private JPanel panel2;
    private Component win;

    public AboutDialog(Component win) {
        this.win = win;
        this.setDefaultCloseOperation(2);
        this.setTitle("About");
        this.setModal(true);
        this.setResizable(true);
        Dimension res = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension(Math.min(400, res.width), Math.min(500, res.height));
        this.setSize(size);
        JPanel topPanel = new JPanel();
        JPanel lowerPanel = new JPanel();
        lowerPanel.setPreferredSize(new Dimension(400, 35));
        this.closeButton = new JButton();
        this.closeButton.setText("Exit");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.setVisible(false);
                AboutDialog.this.dispose();
            }
        });
        lowerPanel.add((Component)this.closeButton, null);
        topPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)topPanel, "Center");
        this.getContentPane().add((Component)lowerPanel, "South");
        this.tabbedPane = new JTabbedPane();
        this.createPage1();
        this.createPage2();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("About", this.panel1);
        this.tabbedPane.addTab("License", this.panel2);
        topPanel.add((Component)this.tabbedPane, "Center");
        Util.centreWithin(win, this);
        this.setVisible(true);
    }

    public void createPage1() {
        this.panel1 = new JPanel();
        this.panel1.setLayout(new BorderLayout());
        JEditorPane epane = new JEditorPane();
        epane.setOpaque(false);
        epane.setContentType("text/html;charset=ISO-8859-1");
        epane.setAutoscrolls(true);
        epane.setEditable(false);
        String k1 = "<h2> ProMC Browser. </h2>";
        String k2 = "<b>Author: S.Chekanov (ANL/ASC. HEP division)</b><br>";
        String k3 = "<b>Version: 1.1 </b><br>";
        String all = k1 + k2 + k3;
        epane.setText(all);
        JScrollPane jsp = new JScrollPane(epane);
        this.panel1.add(jsp);
    }

    public void createPage2() {
        this.panel2 = new JPanel();
        this.panel2.setLayout(new BorderLayout());
        JEditorPane epane = new JEditorPane();
        epane.setOpaque(false);
        epane.setContentType("text/html;charset=ISO-8859-1");
        epane.setAutoscrolls(true);
        epane.setEditable(false);
        try {
            epane.setPage(this.getHTMLUrl("license.html"));
        }
        catch (Exception e) {
            System.err.println("Couldn't create URL");
            epane.setContentType("text/plain");
        }
        JScrollPane jsp = new JScrollPane(epane);
        this.panel2.add(jsp);
    }

    public URL getHTMLUrl(String name) {
        URL url = null;
        try {
            url = this.getClass().getResource("/probrowser/" + name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return url;
    }
}

