/*
 * Decompiled with CFR 0.152.
 */
package hepsim;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import promc.io.ProMC;
import promc.io.ProMCDescriptionFile;
import promc.io.ProMCHeaderFile;
import promc.io.ProMCStatFile;
import proto.FileMC;

public class MixPileup {
    private static FileOutputStream fout;
    private static ZipOutputStream zout;
    private static FileMC datafile;
    private static FileMC biasfile;

    public static void main(String[] args) {
        if (args.length != 3 && args.length != 4) {
            System.err.println("Error: Incorrect number of arguments. Exit.");
            System.out.println("Argument 1: Number of events from bias data file to combine with signal event.  Prefix with 'p' character for Poisson distribution.\nArgument 2: Filename of data file.\nArgument 3: Filename of bias data file.\nArgument 4 (optional): Filename of output file.");
            System.exit(1);
        }
        boolean poisson = false;
        if (args[0].charAt(0) == 'p') {
            poisson = true;
        }
        int num_events = 0;
        try {
            num_events = poisson ? Integer.parseInt(args[0].substring(1)) : Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            System.err.println("Error: Cannot parse event number. It is not integer number! Exit!");
            System.exit(1);
        }
        String outFilename = args.length == 4 ? args[3] : "pileup.promc";
        new File(outFilename).delete();
        try {
            fout = new FileOutputStream(outFilename);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error: Cannot open file " + outFilename);
            System.exit(1);
        }
        String txt = "ProMC: Mixing " + Integer.toString(num_events) + " (const) events";
        if (poisson) {
            txt = "ProMC: Mixing " + Integer.toString(num_events) + " (Poisson average) events";
        }
        System.out.println(txt);
        System.out.println("  Signal   Input=" + args[1].trim());
        System.out.println("  MinBias  Input=" + args[2].trim());
        System.out.println("           Output=" + outFilename);
        zout = new ZipOutputStream(new BufferedOutputStream(fout));
        FileMC datafile = new FileMC(args[1].trim(), "r");
        FileMC biasfile = new FileMC(args[2].trim(), "r");
        if (!MixPileup.checkFileForConsistency(datafile) || !MixPileup.checkFileForConsistency(biasfile)) {
            MixPileup.closeFiles();
            System.exit(1);
        }
        long version = datafile.getVersion();
        MixPileup.writeInfo("version", Long.toString(version).getBytes());
        ProMCDescriptionFile.ProMCDescription desc = datafile.fetchDescription();
        ProMCDescriptionFile.ProMCDescription bias = biasfile.fetchDescription();
        MixPileup.writeInfo("description", desc.toByteArray());
        ProMCHeaderFile.ProMCHeader header = datafile.getHeader();
        int unit = header.getMomentumUnit();
        int lunit = header.getLengthUnit();
        ProMCHeaderFile.ProMCHeader header_bias = biasfile.getHeader();
        if (unit != header_bias.getMomentumUnit()) {
            System.err.println("Error: Energy units in the signal and MinBias files are inconsistent!");
            System.err.println("Error: Signal file energy unit:" + Integer.toString(unit));
            System.err.println("Error:   Bias file energy unit:" + Integer.toString(header_bias.getMomentumUnit()));
            MixPileup.closeFiles();
            System.exit(1);
        }
        if (lunit != header_bias.getLengthUnit()) {
            System.err.println("Error: Lenght units in the signal and MinBias files are inconsistent!");
            System.err.println("Error: Signal file length unit:" + Integer.toString(lunit));
            System.err.println("Error:   Bias file length unit:" + Integer.toString(header_bias.getLengthUnit()));
            MixPileup.closeFiles();
            System.exit(1);
        }
        MixPileup.writeInfo("header", header.toByteArray());
        long n_data_events = datafile.getNEntries();
        long n_bias_events = biasfile.getNEntries();
        int n_events = num_events;
        int next_particle_id = 0;
        int oldPercentComplete = 0;
        int eventNo = 0;
        while ((long)eventNo < n_data_events) {
            int percentComplete;
            ProMC.ProMCEvent event = datafile.read(eventNo);
            ProMC.ProMCEvent.Builder builder = event.toBuilder();
            ProMC.ProMCEvent.Particles particles = event.getParticles();
            if (poisson) {
                n_events = MixPileup.getPoissonRandom(num_events);
            }
            if ((percentComplete = (int)((double)eventNo * 100.0 / (double)n_data_events)) % 5 == 0 && percentComplete > oldPercentComplete) {
                System.out.println(Integer.toString(percentComplete) + "% complete");
                oldPercentComplete = percentComplete;
            }
            next_particle_id = 1 + particles.getId(particles.getIdCount() - 1);
            for (int i = 1; i <= n_events; ++i) {
                int rand = (int)(Math.random() * (double)n_bias_events);
                ProMC.ProMCEvent event2 = biasfile.read(rand);
                ProMC.ProMCEvent.Particles particles2 = event2.getParticles();
                ProMC.ProMCEvent.Particles.Builder builder2 = particles2.toBuilder();
                int count = particles2.getBarcodeCount();
                for (int j = 0; j < count; ++j) {
                    builder2.setBarcode(j, i);
                    builder2.setId(j, particles2.getId(j) + next_particle_id);
                    builder2.setMother1(j, particles2.getMother1(j) + next_particle_id);
                    builder2.setMother2(j, particles2.getMother2(j) + next_particle_id);
                    builder2.setDaughter1(j, particles2.getDaughter1(j) + next_particle_id);
                    builder2.setDaughter2(j, particles2.getDaughter2(j) + next_particle_id);
                }
                next_particle_id = 1 + builder2.getId(builder2.getIdCount() - 1);
                builder.mergeParticles(builder2.build());
            }
            event = builder.build();
            MixPileup.writeInfo(Integer.toString(eventNo), event.toByteArray());
            ++eventNo;
        }
        String txtdescription = datafile.getDescription() + "  + PILEUP WITH " + Integer.toString(num_events) + " (const)";
        if (poisson) {
            txtdescription = datafile.getDescription() + "  + PILEUP WITH " + Integer.toString(num_events) + " (Poisson average)";
        }
        MixPileup.writeInfo("promc_description", txtdescription.getBytes());
        MixPileup.writeInfo("promc_nevents", Long.toString(n_data_events).getBytes());
        ProMCStatFile.ProMCStat stat = datafile.getStat();
        MixPileup.writeInfo("statistics", stat.toByteArray());
        MixPileup.writeInfo("ProMCHeader.proto", datafile.getProMCHeaderTxt().getBytes());
        MixPileup.writeInfo("ProMC.proto", datafile.getProMCTxt().getBytes());
        MixPileup.writeInfo("ProMCStat.proto", datafile.getProMCStatTxt().getBytes());
        MixPileup.writeInfo("ProMCDescription.proto", datafile.getProMCDescriptionTxt().getBytes());
        MixPileup.writeInfo("logfile.txt", datafile.readLogfile().getBytes());
        MixPileup.closeFiles();
        System.out.println("done");
    }

    static boolean checkFileForConsistency(FileMC infile) {
        long nev2;
        if (infile == null) {
            System.err.println("Error: a file wasn't opened properly or is not a ProMC file.");
            return false;
        }
        long nev1 = infile.getNEntries();
        if (nev1 != (nev2 = infile.getEvents())) {
            System.err.println("Error: There is a problem with a file: inconsistent number of entries.  The file was truncated!");
            return false;
        }
        return true;
    }

    static void closeFiles() {
        try {
            datafile.close();
            datafile = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            biasfile.close();
            biasfile = null;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            zout.finish();
            zout.close();
            zout = null;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            fout.close();
            fout = null;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    static void writeInfo(String key, byte[] data) {
        try {
            ZipEntry entry = new ZipEntry(key);
            zout.putNextEntry(entry);
            entry.setSize(data.length);
            zout.write(data);
            zout.closeEntry();
        }
        catch (IOException e) {
            System.err.println("Error: Cannot write zip entry \"" + key + "\"");
            MixPileup.closeFiles();
            System.exit(1);
        }
        catch (NullPointerException e) {
            System.err.println(e.getMessage());
        }
    }

    static int getPoissonRandom(double mean) {
        Random r = new Random();
        double L = Math.exp(-mean);
        int k = 0;
        double p = 1.0;
        do {
            ++k;
        } while ((p *= r.nextDouble()) > L);
        return k - 1;
    }
}

