/*
 * Decompiled with CFR 0.152.
 */
package hepsim;

import hepsim.HepSim;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Get {
    private static String toDir = "";

    public Get(String inputURL, File dest) {
        URL website = null;
        try {
            website = new URL(inputURL);
            Files.copy(website.openStream(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (MalformedURLException e) {
            HepSim.ErrorMessage("No such location: " + inputURL);
        }
        catch (IOException e) {
            HepSim.ErrorMessage("Error for " + dest);
        }
    }

    private static List<List<String[]>> createBatch(List<String[]> originalList, int chunkSize) {
        ArrayList<List<String[]>> listOfChunks = new ArrayList<List<String[]>>();
        for (int i = 0; i < originalList.size() / chunkSize; ++i) {
            listOfChunks.add(originalList.subList(i * chunkSize, i * chunkSize + chunkSize));
        }
        if (originalList.size() % chunkSize != 0) {
            listOfChunks.add(originalList.subList(originalList.size() - originalList.size() % chunkSize, originalList.size()));
        }
        return listOfChunks;
    }

    public static void main(String[] args) {
        File newDirectory;
        String surl;
        String[] parts;
        DecimalFormat formatter = new DecimalFormat("####.##");
        int Nthreads = 2;
        int xlength = args.length;
        int nfiles = -1;
        String pattern = "";
        if (xlength < 1) {
            HepSim.ErrorMessage("Usage: The command takes 1, 2, 3, 4 or 5 arguments:  URL, OUTPUT directory, Nr of threads (optional), Nr of files (optional), pattern. Exit!");
            System.exit(1);
        }
        if (xlength == 1 && HepSim.isValidURL(toDir = args[0].trim())) {
            String[] sss = toDir.split("/");
            toDir = sss[sss.length - 1];
            toDir = toDir.replace("/", "");
        }
        if (xlength > 1) {
            toDir = args[1].trim();
        }
        if (xlength >= 3) {
            System.out.println("HepSim: Downloading using " + args[2].trim() + " threads");
            try {
                Nthreads = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                HepSim.ErrorMessage("Error: Cannot parse number of threads. It is not an integer number! Exit!");
                System.exit(1);
            }
            if (Nthreads > 6) {
                HepSim.ErrorMessage("Too many threads given.  Fall back to 2!");
                Nthreads = 2;
            }
        }
        if (xlength >= 4) {
            try {
                nfiles = Integer.parseInt(args[3]);
            }
            catch (NumberFormatException e) {
                HepSim.ErrorMessage("Error: Cannot parse the number of files for download: Not an integer number! Exit!");
                System.exit(1);
            }
        }
        if (xlength == 5) {
            pattern = args[4].trim();
        }
        if (xlength > 5) {
            HepSim.ErrorMessage("Too many arguments! This command takes 2, 3, 4 or 5 arguments:  URL, OUTPUT directory, Nr of threads (optional), Nr of files (optional), pattern. Exit!");
            System.exit(1);
        }
        if ((parts = (surl = args[0].trim()).split("%")).length == 2) {
            surl = parts[0];
        } else if (parts.length > 2) {
            HepSim.ErrorMessage("HepSim does not support download of multiple datasets at the same time.");
            System.exit(1);
        }
        String[] surl_array = HepSim.urlRedirector(surl);
        surl = surl_array[0];
        if (surl_array != null) {
            surl = surl_array[0];
        }
        if (parts.length == 2) {
            surl = surl + "/" + parts[1];
        }
        if (surl.length() < 5) {
            HepSim.ErrorMessage("Exit!");
            System.exit(1);
        }
        if (!HepSim.isValidURL(surl)) {
            HepSim.ErrorMessage("HepSim: This is not valid URL link for data download. Exit!");
            System.exit(0);
        }
        if (!(newDirectory = new File(toDir)).exists()) {
            boolean result = newDirectory.mkdir();
            if (result) {
                System.err.println("HepSim: The directory " + toDir + " is created!");
            }
        } else {
            System.out.println("\u001b[33mWarning: The directory \"" + toDir + "\" already exists!" + "\u001b[0m");
        }
        System.out.println("\nStart downloading in " + Integer.toString(Nthreads) + " threads");
        System.out.println("From: " + surl);
        System.out.println("To:   " + toDir);
        if (pattern.length() > 1) {
            System.out.println("Pattern:   " + pattern);
        }
        ArrayList<String[]> data = HepSim.getListArraySizes(surl);
        ArrayList<String[]> data_pattern = new ArrayList<String[]>();
        for (int j = 0; j < data.size(); ++j) {
            if (pattern.length() > 1) {
                String[] xname = data.get(j);
                if (xname[0].indexOf(pattern) <= -1) continue;
                data_pattern.add(data.get(j));
                continue;
            }
            data_pattern.add(data.get(j));
        }
        ArrayList<String[]> data_new = new ArrayList<String[]>();
        if (nfiles == -1) {
            System.out.println("Nr files:   All " + Integer.toString(data_pattern.size()) + " files will be downloaded");
        } else {
            System.out.println("Nr files:   A subsample with " + Integer.toString(nfiles) + " files will be downloaded");
        }
        for (int j = 0; j < data_pattern.size() && (nfiles <= -1 || j <= nfiles - 1); ++j) {
            data_new.add((String[])data_pattern.get(j));
        }
        List<List<String[]>> batchfiles = Get.createBatch(data_new, Nthreads);
        int bntot = batchfiles.size();
        for (int n = 0; n < bntot; ++n) {
            List<String[]> batch = batchfiles.get(n);
            ArrayList<String> fileNames = new ArrayList<String>();
            int isdone = (int)(100.0 * ((double)n / (double)bntot));
            System.out.print(formatter.format(isdone) + "% -> ");
            for (int j = 0; j < batch.size(); ++j) {
                String[] dd = batch.get(j);
                fileNames.add(dd[0]);
                System.out.print(dd[0] + " ");
            }
            System.out.println("");
            long done = 0L;
            for (int j = 0; j < batch.size(); ++j) {
                long kilobytes;
                String[] dd = batch.get(j);
                long l = Long.parseLong(dd[1]);
                File f = new File(toDir + File.separator + dd[0]);
                if (!f.exists() || Math.abs((kilobytes = f.length() / 1024L) - l) >= 5L) continue;
                ++done;
            }
            if (done == (long)Nthreads) {
                System.out.println("Already done: ");
                continue;
            }
            ArrayList<1> threads = new ArrayList<1>();
            Iterator iterator = fileNames.iterator();
            while (iterator.hasNext()) {
                String string;
                String NAME = string = (String)iterator.next();
                final String inputURL = surl + "/" + string;
                final String destFile = toDir + File.separator + NAME;
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        File dest = new File(destFile);
                        Get d = new Get(inputURL, dest);
                    }
                };
                t.start();
                threads.add(t);
            }
            for (Thread thread : threads) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    HepSim.ErrorMessage("Download was interrupted!");
                }
            }
        }
    }
}

