/*
 * Decompiled with CFR 0.152.
 */
package dmanag;

import dmanag.Download;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JProgressBar;
import javax.swing.table.AbstractTableModel;

public class DownloadsTableModel
extends AbstractTableModel
implements Observer {
    private static final String[] columnNames = new String[]{"URL", "Size", "Progress", "Status"};
    private static final Class[] columnClasses = new Class[]{String.class, String.class, JProgressBar.class, String.class};
    private ArrayList<Download> downloadList = new ArrayList();

    public void addDownload(Download download) {
        download.addObserver(this);
        this.downloadList.add(download);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public Download getDownload(int row) {
        return this.downloadList.get(row);
    }

    public void clearDownload(int row) {
        this.downloadList.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Class getColumnClass(int col) {
        return columnClasses[col];
    }

    @Override
    public int getRowCount() {
        return this.downloadList.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        Download download = this.downloadList.get(row);
        switch (col) {
            case 0: {
                return download.getUrl();
            }
            case 1: {
                int size = download.getSize();
                return size == -1 ? "" : Integer.toString(size);
            }
            case 2: {
                return new Float(download.getProgress());
            }
            case 3: {
                return Download.STATUSES[download.getStatus()];
            }
        }
        return "";
    }

    @Override
    public void update(Observable o, Object arg) {
        int index = this.downloadList.indexOf(o);
        this.fireTableRowsUpdated(index, index);
    }
}

