/*
 * Decompiled with CFR 0.152.
 */
package dmanag;

import dmanag.Download;
import dmanag.DownloadsTableModel;
import dmanag.ProgressRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DownloadManager
extends JFrame
implements Observer {
    private JTextField addTextField;
    private DownloadsTableModel tableModel;
    private JTable table;
    private JButton pauseButton;
    private JButton resumeButton;
    private JButton cancelButton;
    private JButton clearButton;
    private Download selectedDownload;
    private boolean clearing;

    public DownloadManager() {
        this.setTitle("DManag");
        this.setSize(640, 500);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DownloadManager.this.actionExit();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        JMenuItem fileExitMenuItem = new JMenuItem("Exit", 88);
        fileExitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadManager.this.actionExit();
            }
        });
        fileMenu.add(fileExitMenuItem);
        menuBar.add(fileMenu);
        this.setJMenuBar(menuBar);
        JPanel addPanel = new JPanel();
        this.addTextField = new JTextField(30);
        addPanel.add(this.addTextField);
        JButton addButton = new JButton("Add Download");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadManager.this.actionAdd();
            }
        });
        addPanel.add(addButton);
        this.tableModel = new DownloadsTableModel();
        this.table = new JTable(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DownloadManager.this.tableSelectionChanged();
            }
        });
        this.table.setSelectionMode(0);
        ProgressRenderer renderer = new ProgressRenderer(0, 100);
        renderer.setStringPainted(true);
        this.table.setDefaultRenderer(JProgressBar.class, renderer);
        this.table.setRowHeight((int)renderer.getPreferredSize().getHeight());
        JPanel downloadsPanel = new JPanel();
        downloadsPanel.setBorder(BorderFactory.createTitledBorder("Downloads"));
        downloadsPanel.setLayout(new BorderLayout());
        downloadsPanel.add((Component)new JScrollPane(this.table), "Center");
        JPanel buttonsPanel = new JPanel();
        this.pauseButton = new JButton("Pause");
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadManager.this.actionPause();
            }
        });
        this.pauseButton.setEnabled(false);
        buttonsPanel.add(this.pauseButton);
        this.resumeButton = new JButton("Resume");
        this.resumeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadManager.this.actionResume();
            }
        });
        this.resumeButton.setEnabled(false);
        buttonsPanel.add(this.resumeButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadManager.this.actionCancel();
            }
        });
        this.cancelButton.setEnabled(false);
        buttonsPanel.add(this.cancelButton);
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownloadManager.this.actionClear();
            }
        });
        this.clearButton.setEnabled(false);
        buttonsPanel.add(this.clearButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)addPanel, "North");
        this.getContentPane().add((Component)downloadsPanel, "Center");
        this.getContentPane().add((Component)buttonsPanel, "South");
    }

    private void actionExit() {
        System.exit(0);
    }

    private void actionAdd() {
        URL verifiedUrl = this.verifyUrl(this.addTextField.getText());
        if (verifiedUrl != null) {
            this.tableModel.addDownload(new Download(verifiedUrl));
            this.addTextField.setText("");
        } else {
            JOptionPane.showMessageDialog(this, "Invalid Download URL", "Error", 0);
        }
    }

    private URL verifyUrl(String url) {
        if (!(url.toLowerCase().startsWith("http://") || url.toLowerCase().startsWith("https://") || url.toLowerCase().startsWith("ftp://"))) {
            return null;
        }
        URL verifiedUrl = null;
        try {
            verifiedUrl = new URL(url);
        }
        catch (Exception e) {
            return null;
        }
        if (verifiedUrl.getFile().length() < 2) {
            return null;
        }
        return verifiedUrl;
    }

    private void tableSelectionChanged() {
        if (this.selectedDownload != null) {
            this.selectedDownload.deleteObserver(this);
        }
        if (!this.clearing && this.table.getSelectedRow() > -1) {
            this.selectedDownload = this.tableModel.getDownload(this.table.getSelectedRow());
            this.selectedDownload.addObserver(this);
            this.updateButtons();
        }
    }

    private void actionPause() {
        this.selectedDownload.pause();
        this.updateButtons();
    }

    private void actionResume() {
        this.selectedDownload.resume();
        this.updateButtons();
    }

    private void actionCancel() {
        this.selectedDownload.cancel();
        this.updateButtons();
    }

    private void actionClear() {
        this.clearing = true;
        this.tableModel.clearDownload(this.table.getSelectedRow());
        this.clearing = false;
        this.selectedDownload = null;
        this.updateButtons();
    }

    private void updateButtons() {
        if (this.selectedDownload != null) {
            int status = this.selectedDownload.getStatus();
            switch (status) {
                case 0: {
                    this.pauseButton.setEnabled(true);
                    this.resumeButton.setEnabled(false);
                    this.cancelButton.setEnabled(true);
                    this.clearButton.setEnabled(false);
                    break;
                }
                case 1: {
                    this.pauseButton.setEnabled(false);
                    this.resumeButton.setEnabled(true);
                    this.cancelButton.setEnabled(true);
                    this.clearButton.setEnabled(false);
                    break;
                }
                case 4: {
                    this.pauseButton.setEnabled(false);
                    this.resumeButton.setEnabled(true);
                    this.cancelButton.setEnabled(false);
                    this.clearButton.setEnabled(true);
                    break;
                }
                default: {
                    this.pauseButton.setEnabled(false);
                    this.resumeButton.setEnabled(false);
                    this.cancelButton.setEnabled(false);
                    this.clearButton.setEnabled(true);
                    break;
                }
            }
        } else {
            this.pauseButton.setEnabled(false);
            this.resumeButton.setEnabled(false);
            this.cancelButton.setEnabled(false);
            this.clearButton.setEnabled(false);
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.selectedDownload != null && this.selectedDownload.equals(o)) {
            this.updateButtons();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadManager manager = new DownloadManager();
                manager.setVisible(true);
            }
        });
    }
}

