/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.objects.ConstructionObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.MyGraphics13;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import javax.swing.JPanel;

public class UniversalTracker
extends JPanel {
    private static final long serialVersionUID = 1L;
    public BufferedImage TrackI = null;
    public MyGraphics TrackIG = null;
    int IW = 0;
    int IH = 0;
    double DX = 0.0;
    double Xmin = 0.0;
    double Ymin = 0.0;
    boolean isActive = false;
    ZirkelCanvas ZC;

    public UniversalTracker(ZirkelCanvas zc) {
        this.ZC = zc;
    }

    public void setActive(boolean b2) {
        this.isActive = b2;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void clearTrackObjects() {
        Enumeration e2 = this.ZC.getConstruction().V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            o.setTracked(false);
        }
        this.isActive = false;
    }

    public synchronized void draw() {
        if (this.TrackI == null) {
            return;
        }
        if (!this.isActive) {
            return;
        }
        if (this.ZC.DX != this.DX || this.ZC.Xmin != this.Xmin || this.ZC.Ymin != this.Ymin) {
            this.IW = this.ZC.IW;
            this.IH = this.ZC.IH;
            this.DX = this.ZC.DX;
            this.Xmin = this.ZC.Xmin;
            this.Ymin = this.ZC.Ymin;
            this.clearTrackImage();
        }
        this.ZC.I.getGraphics().drawImage(this.TrackI, 0, 0, this);
    }

    public void createTrackImage() {
        this.IW = this.ZC.IW;
        this.IH = this.ZC.IH;
        this.DX = this.ZC.DX;
        this.Xmin = this.ZC.Xmin;
        this.Ymin = this.ZC.Ymin;
        this.TrackI = new BufferedImage(this.IW, this.IH, 2);
        this.clearTrackImage();
        this.TrackIG = new MyGraphics13(this.TrackI.getGraphics(), this.ZC);
    }

    public void clearTrackImage() {
        Graphics2D g2D = this.TrackI.createGraphics();
        g2D.setComposite(AlphaComposite.getInstance(1, 0.0f));
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.IW, this.IH);
        g2D.fill(rect);
    }

    public void drawTrackCircle(PrimitiveCircleObject o, double d2, double d0, double r) {
        this.isActive = true;
        this.TrackIG.setColor(o);
        this.TrackIG.drawCircle(d2, d0, r, o);
    }

    public void drawTrackLine(ConstructionObject o, double c1, double r1, double c2, double r2) {
        this.isActive = true;
        this.TrackIG.setColor(o);
        this.TrackIG.drawLine(c1, r1, c2, r2, o);
    }

    public void drawTrackPoint(ConstructionObject o, double X, double Y, int type) {
        this.isActive = true;
        if (this.TrackIG == null) {
            return;
        }
        double size = this.ZC.pointSize();
        if (size < 1.0) {
            size = 1.0;
        }
        double r = this.ZC.col(X);
        double c2 = this.ZC.row(Y);
        if (o.visible(this.ZC)) {
            boolean ind = o.indicated();
            boolean sel = o.selected();
            o.setIndicated(false);
            o.setSelected(false);
            switch (type) {
                case 0: {
                    double sx = r - size - 1.0;
                    double sy = c2 - size - 1.0;
                    double sw = 2.0 * size + 2.0;
                    if (o.getColorType() == 1) {
                        this.TrackIG.fillRect(sx, sy, sw, sw, true, false, o);
                    } else {
                        this.TrackIG.fillRect(sx, sy, sw, sw, new Color(250, 250, 250));
                    }
                    this.TrackIG.setColor(o);
                    this.TrackIG.drawRect(sx, sy, sw, sw);
                    break;
                }
                case 1: {
                    double dx = r - size - 2.0;
                    double dy = c2 - size - 2.0;
                    double dw = 2.0 * size + 4.0;
                    this.TrackIG.drawDiamond(dx, dy, dw, o.getColorType() == 1, o);
                    break;
                }
                case 2: {
                    double cx = r - size - 1.0;
                    double cy = c2 - size - 1.0;
                    double cw = 2.0 * size + 2.0;
                    if (o.getColorType() == 1) {
                        this.TrackIG.fillOval(cx, cy, cw, cw, true, false, o);
                        break;
                    }
                    this.TrackIG.fillOval(cx, cy, cw, cw, new Color(250, 250, 250));
                    this.TrackIG.setColor(o);
                    this.TrackIG.drawOval(cx, cy, cw, cw);
                    break;
                }
                case 3: {
                    if (o.getColorType() == 1) {
                        this.TrackIG.fillRect(r, c2, 1.0, 1.0, true, false, o);
                        break;
                    }
                    this.TrackIG.fillRect(r, c2, 1.0, 1.0, false, false, o);
                    break;
                }
                case 4: {
                    if (o.getColorType() == 1) {
                        this.TrackIG.drawThickLine(r - size, c2, r + size, c2);
                        this.TrackIG.drawThickLine(r, c2 - size, r, c2 + size);
                        break;
                    }
                    this.TrackIG.drawLine(r - size, c2, r + size, c2);
                    this.TrackIG.drawLine(r, c2 - size, r, c2 + size);
                    break;
                }
                case 5: {
                    double dcx = r - size - 1.0;
                    double dcy = c2 - size - 1.0;
                    double dcw = 2.0 * size + 1.0;
                    this.TrackIG.drawDcross(dcx, dcy, dcw, o.getColorType() == 1, o);
                }
            }
            o.setIndicated(ind);
            o.setSelected(sel);
        }
    }
}

