/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.tools;

import carmetal.constructors.ObjectConstructor;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class SetRangeTool
extends ObjectConstructor {
    ObjectConstructor OC;
    PrimitiveCircleObject C;
    PointObject P1;
    PointObject P2;

    public SetRangeTool(ZirkelCanvas zc, PrimitiveCircleObject c2, ObjectConstructor oc) {
        this.C = c2;
        this.OC = oc;
        this.C.setSelected(true);
        zc.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (this.P1 == null) {
            this.P1 = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P1 != null) {
                this.P1.setSelected(true);
                this.showStatus(zc);
                zc.repaint();
            }
        } else {
            this.P2 = zc.selectPoint(e2.getX(), e2.getY());
            if (this.P2 == null) {
                return;
            }
            this.C.setRange(this.P1, this.P2);
            this.reset(zc);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2, ZirkelCanvas zc, boolean simple) {
        zc.indicatePointObjects(e2.getX(), e2.getY());
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.P1 == null) {
            zc.showStatus(Global.name("message.range.first"));
        } else {
            zc.showStatus(Global.name("message.range.second"));
        }
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        zc.setTool(this.OC);
        zc.validate();
        zc.repaint();
    }
}

