/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.macro;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.objects.ConstructionObject;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTagText;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.util.Enumeration;
import java.util.Vector;

public class Macro
extends Construction
implements Cloneable {
    public String Name;
    public String[] Prompts;
    public ConstructionObject[] Params;
    public String[] PromptFor = new String[0];
    public String[] PromptName = new String[0];
    public String[] LastParams;
    public boolean[] Fixed;
    boolean Protected = false;
    boolean HideDuplicates = true;

    public Macro(ZirkelCanvas zc, String name, String comment, String[] s) {
        this.Name = name;
        this.Comment = comment;
        this.Prompts = s;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    @Override
    public String getComment() {
        return this.Comment;
    }

    public String[] getPrompts() {
        return this.Prompts;
    }

    public void setParams(ConstructionObject[] p) {
        this.Params = p;
    }

    public ConstructionObject[] getParams() {
        return this.Params;
    }

    public void initLast() {
        this.LastParams = new String[this.Params.length];
    }

    public void setLast(String name, int i) {
        try {
            this.LastParams[i] = name;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLast(int i) {
        if (this.LastParams != null && this.LastParams[i] != null) {
            return this.LastParams[i];
        }
        return "";
    }

    public void setPromptFor(String[] s) {
        this.PromptFor = s;
        this.PromptName = new String[this.PromptFor.length];
        for (int i = 0; i < this.PromptFor.length; ++i) {
            this.PromptName[i] = this.PromptFor[i];
        }
    }

    public void setPromptName(int i, String s) {
        this.PromptName[i] = s;
    }

    public boolean promptFor(String s) {
        return this.getPromptFor(s) >= 0;
    }

    public int getPromptFor(String s) {
        for (int i = 0; i < this.PromptFor.length; ++i) {
            if (!this.PromptFor[i].equals(s)) continue;
            return i;
        }
        return -1;
    }

    public String getPromptName(String s) {
        for (int i = 0; i < this.PromptFor.length; ++i) {
            if (!this.PromptFor[i].equals(s)) continue;
            return this.PromptName[i];
        }
        return "";
    }

    public int countPrompts() {
        return this.PromptFor.length;
    }

    public void saveMacro(XmlWriter xml) {
        int i;
        xml.startTagStart("Macro");
        xml.printArg("Name", this.Name);
        if (!this.HideDuplicates) {
            xml.printArg("showduplicates", "true");
        }
        xml.startTagEndNewLine();
        for (i = 0; i < this.Params.length; ++i) {
            xml.startTagStart("Parameter");
            xml.printArg("name", this.Params[i].getName());
            if (this.Fixed != null && this.Fixed[i] && this.LastParams != null && this.LastParams[i] != null) {
                xml.printArg("fixed", this.LastParams[i]);
            }
            xml.startTagEnd();
            xml.print(this.Prompts[i]);
            xml.endTagNewLine("Parameter");
        }
        if (!this.getComment().equals("")) {
            xml.startTagNewLine("Comment");
            xml.printParagraphs(this.getComment(), 60);
            xml.endTagNewLine("Comment");
        }
        xml.startTagNewLine("Objects");
        this.save(xml);
        xml.endTagNewLine("Objects");
        if (this.PromptFor.length > 0) {
            xml.startTagStart("PromptFor");
            for (i = 0; i < this.PromptFor.length; ++i) {
                xml.printArg("object" + i, this.PromptFor[i]);
                xml.printArg("prompt" + i, this.PromptName[i]);
            }
            xml.finishTagNewLine();
        }
        xml.endTagNewLine("Macro");
    }

    public Macro(ZirkelCanvas zc, XmlTree tree) throws ConstructionException {
        XmlTag tag = tree.getTag();
        if (!tag.name().equals("Macro")) {
            throw new ConstructionException("No macro!");
        }
        if (!tag.hasParam("Name")) {
            throw new ConstructionException("Name missing!");
        }
        this.Name = tag.getValue("Name");
        if (tag.hasParam("showduplicates")) {
            this.HideDuplicates = false;
        }
        Enumeration e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            XmlTree t = (XmlTree)e2.nextElement();
            tag = t.getTag();
            if (tag.name().equals("Objects")) {
                this.readConstruction(t, false);
                break;
            }
            if (!tag.name().equals("Comment")) continue;
            try {
                this.setComment(t.parseComment());
            }
            catch (Exception ex) {
                throw new ConstructionException("Illegal Comment");
            }
        }
        int ParamCount = 0;
        e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            int i;
            XmlTree t = (XmlTree)e2.nextElement();
            tag = t.getTag();
            if (tag.name().equals("Parameter")) {
                if (!tag.hasParam("name")) {
                    throw new ConstructionException("Parameter name missing!");
                }
                ++ParamCount;
                continue;
            }
            if (!tag.name().equals("PromptFor")) continue;
            if (tag.hasParam("object")) {
                String[] s = new String[]{tag.getValue("object")};
                this.setPromptFor(s);
                if (!tag.hasParam("prompt")) continue;
                this.setPromptName(0, tag.getValue("prompt"));
                continue;
            }
            int n = 0;
            while (tag.hasParam("object" + n)) {
                ++n;
            }
            String[] s = new String[n];
            for (i = 0; i < n; ++i) {
                s[i] = tag.getValue("object" + i);
            }
            this.setPromptFor(s);
            for (i = 0; i < n; ++i) {
                if (!tag.hasParam("prompt" + i)) continue;
                this.setPromptName(i, tag.getValue("prompt" + i));
            }
        }
        this.Params = new ConstructionObject[ParamCount];
        this.initLast();
        this.Prompts = new String[ParamCount];
        for (int pr = 0; pr < ParamCount; ++pr) {
            this.Prompts[pr] = "";
        }
        int i = 0;
        e2 = tree.getContent();
        while (e2.hasMoreElements()) {
            XmlTree t = (XmlTree)e2.nextElement();
            tag = t.getTag();
            if (!tag.name().equals("Parameter")) continue;
            this.Params[i] = this.find(tag.getValue("name"));
            if (this.Params[i] == null) {
                throw new ConstructionException("Illegal parameter " + tag.getValue("name") + "!");
            }
            if (tag.hasParam("fixed")) {
                if (this.Fixed == null) {
                    this.Fixed = new boolean[ParamCount];
                    for (int j = 0; j < ParamCount; ++j) {
                        this.Fixed[j] = false;
                    }
                }
                this.Fixed[i] = true;
                this.LastParams[i] = tag.getValue("fixed");
            }
            Enumeration en = t.getContent();
            while (en.hasMoreElements()) {
                tree = (XmlTree)en.nextElement();
                if (!(tree.getTag() instanceof XmlTagText)) continue;
                this.Prompts[i] = ((XmlTagText)tree.getTag()).getContent();
            }
            ++i;
        }
    }

    @Override
    public Vector getTargets() {
        Vector<ConstructionObject> v = new Vector<ConstructionObject>();
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            ConstructionObject o = (ConstructionObject)e2.nextElement();
            if (!o.isTarget()) continue;
            v.addElement(o);
        }
        return v;
    }

    public boolean hasFixed() {
        for (String prompt : this.Prompts) {
            if (!prompt.startsWith("=")) continue;
            return true;
        }
        if (this.Fixed == null) {
            return false;
        }
        for (boolean element : this.Fixed) {
            if (!element) continue;
            return true;
        }
        return false;
    }

    public boolean isFixed(int i) {
        if (this.Fixed == null) {
            return false;
        }
        return this.Fixed[i];
    }

    public void setFixed(int i, boolean f2) {
        if (this.Fixed == null) {
            return;
        }
        this.Fixed[i] = f2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isProtected() {
        return this.Protected;
    }

    public void setProtected(boolean flag) {
        this.Protected = flag;
    }

    public boolean hideDuplicates() {
        return this.HideDuplicates;
    }

    public void hideDuplicates(boolean flag) {
        this.HideDuplicates = flag;
    }
}

