/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.expression;

import carmetal.construction.ConstructionException;
import carmetal.rene.zirkel.expression.BasicExpression;
import carmetal.rene.zirkel.expression.FunctionExpression;

class RandomExpression
extends FunctionExpression {
    double rand = Double.NaN;

    public RandomExpression(BasicExpression e2, BasicExpression ee) {
        super(43, e2, ee);
    }

    public RandomExpression(BasicExpression e2) {
        super(43, e2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double getValue() throws ConstructionException {
        if (this.NParams > 1) {
            try {
                double r = this.E[0].getValue();
                double p = this.E[1].getValue();
                if (p != 1.0 && !Double.isNaN(this.rand)) return this.rand;
                this.rand = r * Math.random();
                return this.rand;
            }
            catch (Exception e2) {
                this.rand = 0.0;
                return this.rand;
            }
        } else {
            double r = this.E[0].getValue();
            this.rand = r * Math.random();
        }
        return this.rand;
    }

    @Override
    public void reset() {
        this.rand = 0.0;
        super.reset();
    }
}

