/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.zirkel.expression;

import carmetal.construction.ConstructionException;
import carmetal.objects.ConstructionObject;
import carmetal.objects.Evaluator;
import carmetal.objects.FunctionObject;
import carmetal.objects.InsideObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.SimulationObject;
import carmetal.objects.TrackObject;
import carmetal.objects.UserFunctionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.MyVector;
import carmetal.rene.zirkel.expression.BasicExpression;
import carmetal.rene.zirkel.expression.ConvexMin;
import carmetal.rene.zirkel.expression.CumSumExpression;
import carmetal.rene.zirkel.expression.DExpression;
import carmetal.rene.zirkel.expression.ExpressionText;
import carmetal.rene.zirkel.expression.FindObjectExpression;
import carmetal.rene.zirkel.expression.IfExpression;
import carmetal.rene.zirkel.expression.InvalidException;
import carmetal.rene.zirkel.expression.ObjectExpression;
import carmetal.rene.zirkel.expression.OldExpression;
import carmetal.rene.zirkel.expression.RandomExpression;
import carmetal.rene.zirkel.expression.Romberg;
import carmetal.rene.zirkel.expression.Secant;
import carmetal.rene.zirkel.expression.SimulationExpression;
import carmetal.rene.zirkel.expression.TopExpression;
import carmetal.rene.zirkel.expression.UserFunctionExpression;

class FunctionExpression
extends BasicExpression {
    int F;
    BasicExpression[] E;
    int NParams;
    static final String[] Functions = new String[]{"sin", "cos", "tan", "arcsin", "arccos", "arctan", "sqrt", "exp", "log", "round", "x", "y", "floor", "ceil", "d", "a", "angle180", "angle360", "abs", "scale", "sign", "d", "sum", "if", "deg", "rad", "integrate", "zero", "diff", "min", "max", "length", "rsin", "rcos", "rtan", "rarcsin", "rarccos", "rarctan", "sinhyp", "coshyp", "z", "simulate", "inside", "random", "old"};
    static final int NX = 10;
    static final int NY = 11;
    static final int ND = 14;
    static final int NA = 15;
    static final int NS = 19;
    static final int NSUM = 22;
    static final int NIF = 23;
    static final int NINT = 26;
    static final int NZERO = 27;
    static final int NDIFF = 28;
    static final int NMIN = 29;
    static final int NMAX = 30;
    static final int NLENGTH = 31;
    static final int NZ = 40;
    static final int NSIM = 41;
    static final int NINSIDE = 42;
    static final int NRANDOM = 43;
    static final int NOLD = 44;

    public FunctionExpression(int f2, BasicExpression e2) {
        this.F = f2;
        this.E = new BasicExpression[1];
        this.E[0] = e2;
        this.NParams = 1;
    }

    public FunctionExpression(int f2, BasicExpression e2, BasicExpression ee) {
        this.F = f2;
        this.E = new BasicExpression[2];
        this.E[0] = e2;
        this.E[1] = ee;
        this.NParams = 2;
    }

    public FunctionExpression(int f2, BasicExpression e2, BasicExpression ee, BasicExpression eee) {
        this.F = f2;
        this.E = new BasicExpression[3];
        this.E[0] = e2;
        this.E[1] = ee;
        this.E[2] = eee;
        this.NParams = 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BasicExpression scan(ExpressionText t, String name) throws ConstructionException {
        int f2 = -1;
        for (int i = 0; i < Functions.length; ++i) {
            if (!name.equals(Functions[i])) continue;
            f2 = i;
            break;
        }
        if (f2 < 0) {
            boolean forward = false;
            ConstructionObject o = t.getConstruction().find(name, t.getObject());
            if (o == null) {
                o = t.getConstruction().find(name);
                forward = true;
            }
            if (o == null || !(o instanceof FunctionObject) && !(o instanceof UserFunctionObject) || o == t.getObject() || t.getConstruction().dependsOn(o, t.getObject())) throw new ConstructionException(Global.name("exception.function") + " (" + name + ")");
            if (t.next() != '(') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            MyVector ex = new MyVector();
            while (true) {
                BasicExpression e2 = TopExpression.scan(t);
                ex.addElement(e2);
                if (t.next() == ')') break;
                if (t.next() != ',') {
                    throw new ConstructionException(Global.name("exception.parameter"));
                }
                t.advance();
            }
            t.advance();
            t.getDepList().add(o);
            if (forward) {
                t.getConstruction().needsOrdering();
            }
            Object[] exp = new BasicExpression[ex.size()];
            ex.copyInto(exp);
            return new UserFunctionExpression(o, (BasicExpression[])exp);
        }
        if (t.next() != '(') {
            throw new ConstructionException(Global.name("exception.parameter"));
        }
        t.advance();
        BasicExpression e3 = TopExpression.scan(t);
        if (f2 == 10 || f2 == 11 || f2 == 40) {
            if (e3 instanceof FindObjectExpression) {
                e3 = new FunctionExpression(f2, e3);
            } else if (e3 instanceof ObjectExpression && ((ObjectExpression)e3).getObject() instanceof PointObject) {
                e3 = new FunctionExpression(f2, e3);
            } else {
                if (!(e3 instanceof ObjectExpression) || !(((ObjectExpression)e3).getObject() instanceof PrimitiveLineObject)) throw new ConstructionException(Global.name("exception.parameter") + " (" + Functions[f2] + ")");
                e3 = new FunctionExpression(f2, e3);
            }
        } else if (f2 == 14) {
            if (t.next() != ',') {
                e3 = new DExpression(e3);
            } else {
                t.advance();
                BasicExpression ee = TopExpression.scan(t);
                if ((!(e3 instanceof ObjectExpression) || !(((ObjectExpression)e3).getObject() instanceof PointObject)) && !(e3 instanceof FindObjectExpression) || (!(ee instanceof ObjectExpression) || !(((ObjectExpression)ee).getObject() instanceof PointObject)) && !(ee instanceof FindObjectExpression)) throw new ConstructionException(Global.name("exception.parameter") + " (" + Functions[f2] + ")");
                e3 = new FunctionExpression(f2, e3, ee);
            }
        } else if (f2 == 44) {
            if (t.next() != ',') {
                e3 = new OldExpression(e3);
            } else {
                t.advance();
                BasicExpression ee = TopExpression.scan(t);
                e3 = new OldExpression(e3, ee);
            }
        } else if (f2 == 15) {
            if (t.next() != ',') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            BasicExpression ee = TopExpression.scan(t);
            if (t.next() != ',') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            BasicExpression eee = TopExpression.scan(t);
            if ((!(e3 instanceof ObjectExpression) || !(((ObjectExpression)e3).getObject() instanceof PointObject)) && !(e3 instanceof FindObjectExpression) || (!(ee instanceof ObjectExpression) || !(((ObjectExpression)ee).getObject() instanceof PointObject)) && !(ee instanceof FindObjectExpression) || (!(eee instanceof ObjectExpression) || !(((ObjectExpression)eee).getObject() instanceof PointObject)) && !(eee instanceof FindObjectExpression)) throw new ConstructionException(Global.name("exception.parameter") + " (" + Functions[f2] + ")");
            e3 = new FunctionExpression(f2, e3, ee, eee);
        } else if (f2 == 19) {
            if (t.next() != ',') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            BasicExpression ee = TopExpression.scan(t);
            if (t.next() != ',') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            BasicExpression eee = TopExpression.scan(t);
            e3 = new FunctionExpression(f2, e3, ee, eee);
        } else if (f2 == 22) {
            if (t.next() != ',') {
                e3 = new CumSumExpression(e3);
            } else {
                t.advance();
                BasicExpression ee = TopExpression.scan(t);
                e3 = new CumSumExpression(e3, ee);
            }
        } else if (f2 == 43) {
            if (t.next() != ',') {
                e3 = new RandomExpression(e3);
            } else {
                t.advance();
                BasicExpression ee = TopExpression.scan(t);
                e3 = new RandomExpression(e3, ee);
            }
        } else if (f2 == 23) {
            if (t.next() != ',') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            BasicExpression ee = TopExpression.scan(t);
            if (t.next() != ',') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            BasicExpression eee = TopExpression.scan(t);
            e3 = new IfExpression(e3, ee, eee);
        } else if (f2 == 26 || f2 == 27 || f2 == 29 || f2 == 30 || f2 == 31) {
            if (!(e3 instanceof ObjectExpression)) {
                if (f2 != 30 && f2 != 29) throw new ConstructionException(Global.name("exception.parameter") + " (" + Functions[f2] + ")");
                if (t.next() != ',') {
                    throw new ConstructionException(Global.name("exception.parameter"));
                }
                t.advance();
                BasicExpression ee = TopExpression.scan(t);
                e3 = new FunctionExpression(f2, e3, ee);
            } else {
                boolean function;
                boolean bl = function = ((ObjectExpression)e3).getObject() instanceof Evaluator || ((ObjectExpression)e3).getObject() instanceof TrackObject;
                if ((f2 == 26 || f2 == 31) && t.next() == ')') {
                    if (!function) {
                        throw new ConstructionException(Global.name("exception.parameter") + " (" + Functions[f2] + ")");
                    }
                    e3 = new FunctionExpression(f2, e3);
                } else {
                    if (f2 == 31) {
                        throw new ConstructionException(Global.name("exception.parameter"));
                    }
                    if (t.next() != ',') {
                        throw new ConstructionException(Global.name("exception.parameter"));
                    }
                    t.advance();
                    BasicExpression ee = TopExpression.scan(t);
                    if (function) {
                        if (t.next() != ',') {
                            throw new ConstructionException(Global.name("exception.parameter"));
                        }
                        t.advance();
                        BasicExpression eee = TopExpression.scan(t);
                        e3 = new FunctionExpression(f2, e3, ee, eee);
                    } else {
                        if (f2 != 29 && f2 != 30) throw new ConstructionException(Global.name("exception.parameter") + " (" + Functions[f2] + ")");
                        e3 = new FunctionExpression(f2, e3, ee);
                    }
                }
            }
        } else if (f2 == 28) {
            if (!(e3 instanceof ObjectExpression) || !(((ObjectExpression)e3).getObject() instanceof Evaluator)) {
                throw new ConstructionException(Global.name("exception.parameter") + " (" + Functions[f2] + ")");
            }
            if (t.next() != ',') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            BasicExpression ee = TopExpression.scan(t);
            e3 = new FunctionExpression(f2, e3, ee);
        } else if (f2 == 41) {
            if (t.next() != ',') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            BasicExpression ee = TopExpression.scan(t);
            if (t.next() != ',') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            BasicExpression eee = TopExpression.scan(t);
            if ((!(e3 instanceof ObjectExpression) || !(((ObjectExpression)e3).getObject() instanceof SimulationObject)) && eee instanceof ObjectExpression) throw new ConstructionException(Global.name("exception.parameter") + " (" + Functions[f2] + ")");
            ConstructionObject SO = ((ObjectExpression)e3).getObject();
            if (t.getConstruction().dependsOn(SO, t.getObject())) {
                throw new ConstructionException(Global.name("exception.parameter") + " (" + Functions[f2] + ")");
            }
            e3 = new SimulationExpression(((ObjectExpression)e3).getObject(), t.getObject(), ee, ((ObjectExpression)eee).getObject());
        } else if (f2 == 42) {
            if (t.next() != ',') {
                throw new ConstructionException(Global.name("exception.parameter"));
            }
            t.advance();
            BasicExpression ee = TopExpression.scan(t);
            if ((!(e3 instanceof ObjectExpression) || !(((ObjectExpression)e3).getObject() instanceof PointObject)) && !(e3 instanceof FindObjectExpression) || (!(ee instanceof ObjectExpression) || !(((ObjectExpression)ee).getObject() instanceof InsideObject)) && !(ee instanceof FindObjectExpression)) throw new ConstructionException(Global.name("exception.parameter") + " (" + Functions[f2] + ")");
            e3 = new FunctionExpression(f2, e3, ee);
        } else {
            e3 = new FunctionExpression(f2, e3);
        }
        if (t.next() != ')') {
            throw new ConstructionException(Global.name("exception.parameter"));
        }
        t.advance();
        return e3;
    }

    @Override
    public double getValue() throws ConstructionException {
        switch (this.F) {
            case 10: {
                double cc = this.getPointLineX(0);
                return cc;
            }
            case 11: {
                double cc = this.getPointLineY(0);
                return cc;
            }
            case 40: {
                PointObject P = this.getPoint(0);
                if (!P.valid()) {
                    throw new InvalidException(Global.name("exception.invalid"));
                }
                return P.getZ();
            }
            case 14: {
                PointObject P = this.getPoint(0);
                PointObject PP = this.getPoint(1);
                if (!P.valid() || !PP.valid()) {
                    throw new InvalidException(Global.name("exception.invalid"));
                }
                double dx = P.getX() - PP.getX();
                double dy = P.getY() - PP.getY();
                return Math.sqrt(dx * dx + dy * dy);
            }
            case 15: {
                PointObject P = this.getPoint(0);
                PointObject PP = this.getPoint(1);
                PointObject PPP = this.getPoint(2);
                if (!(P.valid() && PP.valid() && PPP.valid())) {
                    throw new InvalidException(Global.name("exception.invalid"));
                }
                double dx = P.getX() - PP.getX();
                double dy = P.getY() - PP.getY();
                double dx1 = PPP.getX() - PP.getX();
                double dy1 = PPP.getY() - PP.getY();
                double a2 = Math.atan2(dx, dy) - Math.atan2(dx1, dy1);
                if ((a2 = a2 / Math.PI * 180.0) < 0.0) {
                    a2 += 360.0;
                }
                if (a2 > 360.0) {
                    a2 -= 360.0;
                }
                return a2;
            }
            case 19: {
                double x = this.E[0].getValue();
                double xa = this.E[1].getValue();
                double xb = this.E[2].getValue();
                if (x < xa || x >= xb || xb <= xa) {
                    throw new InvalidException(Global.name("exception.invalid"));
                }
                return (x - xa) / (xb - xa);
            }
            case 26: {
                Evaluator F;
                if (((ObjectExpression)this.E[0]).getObject() instanceof Evaluator) {
                    F = (Evaluator)((Object)((ObjectExpression)this.E[0]).getObject());
                    if (this.E.length > 1) {
                        double aa = this.E[1].getValue();
                        double bb = this.E[2].getValue();
                        return Romberg.compute(F, aa, bb, 10, 1.0E-10, 10);
                    }
                    if (F instanceof FunctionObject) {
                        return ((FunctionObject)F).getIntegral();
                    }
                } else {
                    TrackObject TO = (TrackObject)((ObjectExpression)this.E[0]).getObject();
                    if (this.E.length > 1) {
                        double aa = this.E[1].getValue();
                        double bb = this.E[2].getValue();
                        return TO.getSum(aa, bb);
                    }
                    return TO.getSum();
                }
            }
            case 31: {
                Evaluator F;
                if (((ObjectExpression)this.E[0]).getObject() instanceof FunctionObject) {
                    F = (FunctionObject)((ObjectExpression)this.E[0]).getObject();
                    return ((FunctionObject)F).getLength();
                }
                TrackObject TO = (TrackObject)((ObjectExpression)this.E[0]).getObject();
                return TO.getLength();
            }
            case 27: {
                Evaluator F = (Evaluator)((Object)((ObjectExpression)this.E[0]).getObject());
                double aa = this.E[1].getValue();
                double bb = this.E[2].getValue();
                return Secant.compute(F, aa, bb, 1.0E-10);
            }
            case 28: {
                Evaluator F = (Evaluator)((Object)((ObjectExpression)this.E[0]).getObject());
                double aa = this.E[1].getValue();
                return (F.evaluateF(aa + 1.0E-7) - F.evaluateF(aa - 1.0E-7)) / 2.0E-7;
            }
            case 29: {
                if (this.NParams == 2) {
                    return Math.min(this.E[0].getValue(), this.E[1].getValue());
                }
                Evaluator F = (Evaluator)((Object)((ObjectExpression)this.E[0]).getObject());
                double aa = this.E[1].getValue();
                double bb = this.E[2].getValue();
                return ConvexMin.computeMin(F, aa, bb, 1.0E-10);
            }
            case 30: {
                if (this.NParams == 2) {
                    return Math.max(this.E[0].getValue(), this.E[1].getValue());
                }
                Evaluator F = (Evaluator)((Object)((ObjectExpression)this.E[0]).getObject());
                double aa = this.E[1].getValue();
                double bb = this.E[2].getValue();
                return ConvexMin.computeMax(F, aa, bb, 1.0E-10);
            }
            case 42: {
                PointObject P = this.getPoint(0);
                InsideObject IO = (InsideObject)((Object)((ObjectExpression)this.E[1]).getObject());
                return IO.containsInside(P);
            }
        }
        double x = this.E[0].getValue();
        switch (this.F) {
            case 0: {
                return Math.sin(x / 180.0 * Math.PI);
            }
            case 1: {
                return Math.cos(x / 180.0 * Math.PI);
            }
            case 2: {
                return Math.tan(x / 180.0 * Math.PI);
            }
            case 3: {
                return Math.asin(x) / Math.PI * 180.0;
            }
            case 4: {
                return Math.acos(x) / Math.PI * 180.0;
            }
            case 5: {
                return Math.atan(x) / Math.PI * 180.0;
            }
            case 6: {
                return Math.sqrt(x);
            }
            case 7: {
                return Math.exp(x);
            }
            case 8: {
                return Math.log(x);
            }
            case 9: {
                return Math.round(x);
            }
            case 12: {
                return Math.floor(x);
            }
            case 13: {
                return Math.ceil(x);
            }
            case 16: {
                x /= 360.0;
                x -= Math.floor(x);
                x *= 360.0;
                if (x < 180.0) {
                    return x;
                }
                return x - 360.0;
            }
            case 17: {
                x /= 360.0;
                x -= Math.floor(x);
                return x * 360.0;
            }
            case 18: {
                return Math.abs(x);
            }
            case 20: {
                if (x > 0.0) {
                    return 1.0;
                }
                if (x == 0.0) {
                    return 0.0;
                }
                return -1.0;
            }
            case 24: {
                return x / Math.PI * 180.0;
            }
            case 25: {
                return x / 180.0 * Math.PI;
            }
            case 32: {
                return Math.sin(x);
            }
            case 33: {
                return Math.cos(x);
            }
            case 34: {
                return Math.tan(x);
            }
            case 35: {
                return Math.asin(x);
            }
            case 36: {
                return Math.acos(x);
            }
            case 37: {
                return Math.atan(x);
            }
            case 38: {
                return (Math.exp(x) - Math.exp(-x)) / 2.0;
            }
            case 39: {
                return (Math.exp(x) + Math.exp(-x)) / 2.0;
            }
        }
        throw new ConstructionException("");
    }

    public double getPointLineX(int n) throws ConstructionException {
        try {
            PointObject p = (PointObject)((ObjectExpression)this.E[n]).getObject();
            if (!p.valid()) {
                throw new ConstructionException("exception.invalid");
            }
            return p.getX();
        }
        catch (Exception e2) {
            try {
                PrimitiveLineObject l = (PrimitiveLineObject)((ObjectExpression)this.E[n]).getObject();
                if (!l.valid()) {
                    throw new ConstructionException("exception.invalid");
                }
                return l.getDX();
            }
            catch (Exception ee) {
                throw new ConstructionException("exception.notfound");
            }
        }
    }

    public double getPointLineY(int n) throws ConstructionException {
        try {
            PointObject p = (PointObject)((ObjectExpression)this.E[n]).getObject();
            if (!p.valid()) {
                throw new ConstructionException("exception.invalid");
            }
            return p.getY();
        }
        catch (Exception e2) {
            try {
                PrimitiveLineObject l = (PrimitiveLineObject)((ObjectExpression)this.E[n]).getObject();
                if (!l.valid()) {
                    throw new ConstructionException("exception.invalid");
                }
                return l.getDY();
            }
            catch (Exception ee) {
                throw new ConstructionException("exception.notfound");
            }
        }
    }

    public PointObject getPoint(int n) throws ConstructionException {
        PointObject p;
        try {
            p = (PointObject)((ObjectExpression)this.E[n]).getObject();
        }
        catch (Exception e2) {
            throw new ConstructionException("exception.notfound");
        }
        if (!p.valid()) {
            throw new ConstructionException("exception.invalid");
        }
        return p;
    }

    @Override
    public void translate() {
        for (int i = 0; i < this.NParams; ++i) {
            this.E[i].translate();
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.NParams; ++i) {
            this.E[i].reset();
        }
    }

    public String toString() {
        String s = Functions[this.F] + "(";
        for (int i = 0; i < this.NParams; ++i) {
            if (i > 0) {
                s = s + ",";
            }
            s = s + this.E[i];
        }
        return s + ")";
    }
}

