/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.gui;

import carmetal.rene.gui.BasicIcon;
import carmetal.rene.gui.Global;
import carmetal.rene.gui.IconBar;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.InputStream;

class MultipleIcon
extends BasicIcon {
    private static final long serialVersionUID = 1L;
    int N;
    Image[] I;
    int Selected;
    int[] X;
    int[] Y;
    int[] W;
    int[] H;

    public MultipleIcon(IconBar bar, String name, int number) {
        super(bar, name);
        this.N = number;
        this.I = new Image[this.N];
        this.X = new int[this.N];
        this.Y = new int[this.N];
        this.W = new int[this.N];
        this.H = new int[this.N];
        MediaTracker T = new MediaTracker(bar);
        try {
            int i;
            for (i = 0; i < this.N; ++i) {
                try {
                    int k;
                    InputStream in = this.getClass().getResourceAsStream(this.Bar.Resource + name + i + "." + Global.getParameter("icontype", "gif"));
                    int pos = 0;
                    int n = in.available();
                    byte[] b2 = new byte[20000];
                    while (n > 0 && (k = in.read(b2, pos, n)) >= 0) {
                        pos += k;
                        n = in.available();
                    }
                    in.close();
                    this.I[i] = Toolkit.getDefaultToolkit().createImage(b2, 0, pos);
                    T.addImage(this.I[i], i);
                    continue;
                }
                catch (Exception e2) {
                    this.I[i] = null;
                }
            }
            T.waitForAll();
            for (i = 0; i < this.N; ++i) {
                this.W[i] = this.I[i].getWidth(this);
                this.H[i] = this.I[i].getHeight(this);
                this.X[i] = Size / 2 - this.W[i] / 2;
                this.Y[i] = Size / 2 - this.H[i] / 2;
            }
        }
        catch (Exception e3) {
            for (int i = 0; i < this.N; ++i) {
                this.I[i] = null;
            }
        }
    }

    public MultipleIcon(IconBar bar, String name) {
        super(bar, name);
        this.Selected = 0;
    }

    @Override
    public void dopaint(Graphics g) {
        if (this.I[this.Selected] != null) {
            if (this.W[this.Selected] > this.getSize().width) {
                g.drawImage(this.I[this.Selected], 1, 1, Size - 2, Size - 2, this);
            } else {
                g.drawImage(this.I[this.Selected], this.X[this.Selected], this.Y[this.Selected], this);
            }
        }
    }

    @Override
    public void pressed(MouseEvent e2) {
        if (e2.isMetaDown()) {
            --this.Selected;
            if (this.Selected < 0) {
                this.Selected = this.N - 1;
            }
        } else {
            ++this.Selected;
            if (this.Selected >= this.N) {
                this.Selected = 0;
            }
        }
    }

    public void setSelected(int s) {
        if (this.Selected == s) {
            return;
        }
        this.Selected = s;
        this.repaint();
    }

    public int getSelected() {
        return this.Selected;
    }
}

