/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.gui;

import carmetal.rene.dialogs.ItemEditorElement;
import carmetal.rene.gui.Global;
import carmetal.rene.gui.Keyboard;
import carmetal.rene.util.sort.SortObject;
import java.util.StringTokenizer;

public class KeyboardItem
implements ItemEditorElement,
SortObject {
    boolean Shift;
    boolean Control;
    boolean Alt;
    String CharKey;
    String MenuString;
    String ActionName;
    int CommandType = 0;

    public KeyboardItem(KeyboardItem item) {
        this.Shift = item.Shift;
        this.Control = item.Control;
        this.Alt = item.Alt;
        this.CharKey = item.CharKey;
        this.MenuString = item.MenuString;
        this.ActionName = item.ActionName;
        this.CommandType = item.CommandType;
    }

    public KeyboardItem(String charkey, String menustring, String actionname, boolean shift, boolean control, boolean alt, int commandtype) {
        this.Shift = shift;
        this.Control = control;
        this.Alt = alt;
        this.CharKey = charkey.toLowerCase();
        this.MenuString = menustring;
        this.ActionName = actionname;
        this.CommandType = commandtype;
    }

    public KeyboardItem(String menu, String key) {
        this.MenuString = menu;
        this.Alt = false;
        this.Control = false;
        this.Shift = false;
        this.CommandType = 0;
        this.CharKey = "";
        StringTokenizer t = new StringTokenizer(key, ".");
        while (t.hasMoreTokens()) {
            String token = t.nextToken();
            if (t.hasMoreTokens()) {
                if (token.equals("control")) {
                    this.Control = true;
                    continue;
                }
                if (token.equals("shift")) {
                    this.Shift = true;
                    continue;
                }
                if (token.equals("alt")) {
                    this.Alt = true;
                    continue;
                }
                if (token.startsWith("esc")) {
                    try {
                        this.CommandType = Integer.parseInt(token.substring(3));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                return;
            }
            if (key.equals("")) {
                return;
            }
            this.CharKey = token.toLowerCase();
        }
        this.ActionName = Global.name(this.getStrippedMenuString());
    }

    public String getMenuString() {
        return this.MenuString;
    }

    public String getActionName() {
        return this.ActionName;
    }

    public String getCharKey() {
        return this.CharKey;
    }

    public boolean isShift() {
        return this.Shift;
    }

    public boolean isControl() {
        return this.Control;
    }

    public boolean isAlt() {
        return this.Alt;
    }

    public int getCommandType() {
        return this.CommandType;
    }

    public String getStrippedMenuString() {
        String s = this.MenuString;
        while (s.endsWith("*")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String shortcut() {
        if (this.CharKey.equals("none")) {
            return "";
        }
        String s = this.CharKey.toUpperCase();
        if (this.Alt) {
            s = Global.name("shortcut.alt") + " " + s;
        }
        if (this.Control) {
            s = Global.name("shortcut.control") + " " + s;
        }
        if (this.Shift) {
            s = Global.name("shortcut.shift") + " " + s;
        }
        if (this.CommandType > 0) {
            s = Keyboard.commandShortcut(this.CommandType) + " " + s;
        }
        return s;
    }

    @Override
    public String getName() {
        return this.MenuString;
    }

    @Override
    public int compare(SortObject o) {
        return this.getName().compareTo(((KeyboardItem)o).getName());
    }

    public String keyDescription() {
        String s = this.CharKey.toLowerCase();
        if (s.equals("none") || s.equals("default")) {
            return s;
        }
        if (this.Alt) {
            s = "alt." + s;
        }
        if (this.Control) {
            s = "control." + s;
        }
        if (this.Shift) {
            s = "shift." + s;
        }
        if (this.CommandType > 0) {
            s = "esc" + this.CommandType + "." + s;
        }
        return s;
    }
}

