/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.gui;

import carmetal.rene.dialogs.ItemEditor;
import carmetal.rene.dialogs.MyFileDialog;
import carmetal.rene.gui.Global;
import carmetal.rene.gui.KeyDictionary;
import carmetal.rene.gui.KeyboardItem;
import carmetal.rene.gui.KeyboardPanel;
import carmetal.rene.util.sort.SortObject;
import carmetal.rene.util.sort.Sorter;
import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Keyboard {
    static Vector V;
    static Hashtable Hmenu;
    static Hashtable Hcharkey;

    public static void makeKeys() {
        String charkey;
        String menu;
        String key;
        V = new Vector();
        Hmenu = new Hashtable();
        Hcharkey = new Hashtable();
        Enumeration e2 = Global.names();
        if (e2 == null) {
            return;
        }
        while (e2.hasMoreElements()) {
            key = (String)e2.nextElement();
            if (!key.startsWith("key.")) continue;
            menu = key.substring(4);
            charkey = Global.getParameter(key, "default");
            String normalcharkey = Global.name(key);
            if (charkey.equals("default")) {
                charkey = normalcharkey;
            }
            KeyboardItem k = new KeyboardItem(menu, charkey);
            V.addElement(k);
            Hmenu.put(menu, k);
            Hcharkey.put(charkey, k);
        }
        e2 = Global.properties();
        while (e2.hasMoreElements()) {
            key = (String)e2.nextElement();
            if (!key.startsWith("key.") || Keyboard.findMenu(menu = key.substring(4)) != null || (charkey = Global.getParameter(key, "default")).equals("default")) continue;
            KeyboardItem k = new KeyboardItem(menu, charkey);
            V.addElement(k);
            Hmenu.put(menu, k);
            Hcharkey.put(charkey, k);
        }
    }

    public static KeyboardItem findMenu(String menu) {
        Object o = Hmenu.get(menu);
        if (o == null) {
            return null;
        }
        return (KeyboardItem)o;
    }

    public static String shortcut(String tag) {
        Enumeration e2 = V.elements();
        while (e2.hasMoreElements()) {
            KeyboardItem item = (KeyboardItem)e2.nextElement();
            if (!item.getMenuString().equals(tag)) continue;
            String shortcut = item.shortcut();
            if (!shortcut.equals("")) {
                shortcut = " (" + shortcut + ")";
            }
            return shortcut;
        }
        return "";
    }

    public static String findKey(KeyEvent event, int type) {
        Object o = Hcharkey.get(Keyboard.toCharKey(event, type));
        if (o == null) {
            return "";
        }
        String s = ((KeyboardItem)o).getMenuString();
        while (s.endsWith("*")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String toCharKey(KeyEvent e2, int type) {
        String s = "";
        if (type > 0) {
            s = s + "esc" + type + ".";
        }
        if (e2.isShiftDown()) {
            s = s + "shift.";
        }
        if (e2.isControlDown()) {
            s = s + "control.";
        }
        if (e2.isAltDown()) {
            s = s + "alt.";
        }
        return s + KeyDictionary.translate(e2.getKeyCode()).toLowerCase();
    }

    public static void edit(Frame f2) {
        String filename;
        Properties parameters;
        Object[] keys = new KeyboardItem[V.size()];
        V.copyInto(keys);
        Sorter.sort((SortObject[])keys);
        Vector<Object> v = new Vector<Object>();
        for (Object key2 : keys) {
            v.addElement(key2);
        }
        KeyboardPanel p = new KeyboardPanel();
        ItemEditor d2 = new ItemEditor(f2, p, v, "keyeditor", Global.name("keyeditor.prompt"), true, false, true, Global.name("keyeditor.clearall"));
        p.setItemEditor(d2);
        p.makeCommandChoice();
        d2.center(f2);
        d2.setVisible(true);
        if (d2.isAborted()) {
            return;
        }
        Global.removeAllParameters("key.");
        V = d2.getElements();
        Enumeration<Object> e2 = V.elements();
        while (e2.hasMoreElements()) {
            KeyboardItem k = (KeyboardItem)e2.nextElement();
            if (k.getCharKey().equals("default")) continue;
            String keytag = "key." + k.getMenuString();
            String description = k.keyDescription();
            if (Global.name(keytag).toLowerCase().equals(description)) continue;
            Global.setParameter(keytag, description);
        }
        Keyboard.makeKeys();
        if (d2.getAction() == 1) {
            parameters = new Properties();
            e2 = Global.properties();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                if (!key.startsWith("key.")) continue;
                parameters.put(key, Global.getParameter(key, "default"));
            }
            MyFileDialog save = new MyFileDialog(f2, Global.name("save"), Global.name("save"), true);
            save.setPattern("*.keys");
            save.center(f2);
            save.update();
            save.setVisible(true);
            if (save.isAborted()) {
                return;
            }
            filename = save.getFilePath();
            if (filename.equals("")) {
                return;
            }
            try {
                FileOutputStream o = new FileOutputStream(filename);
                parameters.store(o, "JE Keyboard Definition");
            }
            catch (Exception o) {}
        } else if (d2.getAction() == 2) {
            parameters = new Properties();
            MyFileDialog load = new MyFileDialog(f2, Global.name("load"), Global.name("load"), true);
            load.setPattern("*.keys");
            load.center(f2);
            load.update();
            load.setVisible(true);
            if (load.isAborted()) {
                return;
            }
            filename = load.getFilePath();
            if (filename.equals("")) {
                return;
            }
            try {
                FileInputStream in = new FileInputStream(filename);
                parameters.load(in);
            }
            catch (Exception in) {
                // empty catch block
            }
            Global.removeAllParameters("key.");
            e2 = parameters.keys();
            while (e2.hasMoreElements()) {
                String key = (String)e2.nextElement();
                Global.setParameter(key, (String)parameters.get(key));
            }
            Keyboard.makeKeys();
        }
    }

    public static Vector getKeys() {
        Vector<String> keys = new Vector<String>();
        Sorter.sort(V);
        Enumeration e2 = V.elements();
        while (e2.hasMoreElements()) {
            KeyboardItem k = (KeyboardItem)e2.nextElement();
            if (k.getCharKey().equals("none")) continue;
            String shortcut = k.shortcut();
            int n = shortcut.length();
            for (int i = 0; i < 30 - n; ++i) {
                shortcut = shortcut + " ";
            }
            keys.addElement(shortcut + " = " + k.getActionName());
        }
        return keys;
    }

    public static String commandShortcut(int type) {
        Object o = Hmenu.get("command." + type);
        if (o == null) {
            return "";
        }
        return ((KeyboardItem)o).shortcut();
    }

    static {
        Keyboard.makeKeys();
    }
}

