/*
 * Decompiled with CFR 0.152.
 */
package carmetal.rene.gui;

import carmetal.rene.gui.IconBar;
import carmetal.rene.gui.ToggleIcon;
import java.awt.Color;

class IconGroup {
    String[] Files;
    String[] Breaks;
    IconBar Bar;
    int N;
    ToggleIcon[] Icons;

    public IconGroup(IconBar bar, String[] files, String[] breaks) {
        this.Files = files;
        this.Breaks = breaks;
        this.Bar = bar;
        this.init();
    }

    public IconGroup(IconBar bar, String[] files) {
        this(bar, files, files);
    }

    public void init() {
        this.N = 0;
        for (int i = 0; i < this.Files.length; ++i) {
            if (this.Files[i].equals("")) continue;
            ++this.N;
        }
        this.Icons = new ToggleIcon[this.N];
        int k = 0;
        for (int i = 0; i < this.Files.length; ++i) {
            if (this.Files[i].equals("")) continue;
            this.Icons[k++] = new ToggleIcon(this.Bar, this.Files[i], this);
        }
    }

    public IconGroup(IconBar bar, String name, int n) {
        this.Files = new String[n];
        this.Breaks = this.Files;
        for (int i = 0; i < n; ++i) {
            this.Files[i] = name + i;
        }
        this.Bar = bar;
        this.init();
    }

    public IconGroup(IconBar bar, String name, Color[] colors) {
        int i;
        this.N = colors.length;
        this.Files = new String[this.N];
        this.Breaks = this.Files;
        for (i = 0; i < this.N; ++i) {
            this.Files[i] = name + i;
        }
        this.Bar = bar;
        this.Icons = new ToggleIcon[this.N];
        for (i = 0; i < this.N; ++i) {
            this.Icons[i] = new ToggleIcon(this.Bar, this.Files[i], colors[i], this);
        }
    }

    public void addLeft() {
        int i = 0;
        for (int k = 0; k < this.Files.length; ++k) {
            if (this.Files[k].equals("")) {
                this.Bar.addSeparatorLeft();
                continue;
            }
            if (this.Breaks[k].startsWith("!")) {
                this.Bar.addSeparatorLeft();
            }
            this.Bar.addLeft(this.Icons[i++]);
        }
    }

    public void addRight() {
        int i = 0;
        for (int k = 0; k < this.Files.length; ++k) {
            if (this.Files[k].equals("")) {
                this.Bar.addSeparatorRight();
                continue;
            }
            if (this.Breaks[k].startsWith("!")) {
                this.Bar.addSeparatorRight();
            }
            this.Bar.addRight(this.Icons[i++]);
        }
    }

    public void toggle(ToggleIcon icon) {
        for (int i = 0; i < this.N; ++i) {
            if (this.Icons[i] == icon) {
                icon.setStateInGroup(true);
                continue;
            }
            this.Icons[i].setStateInGroup(false);
        }
    }

    public void unselect() {
        for (int i = 0; i < this.N; ++i) {
            this.Icons[i].setStateInGroup(false);
        }
    }

    public int getN() {
        return this.N;
    }

    public void unset(boolean flag) {
        for (int i = 0; i < this.N; ++i) {
            this.Icons[i].dounset(flag);
        }
    }
}

