/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.construction.Count;
import carmetal.eric.bar.JProperties;
import carmetal.objects.AngleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.DriverObject;
import carmetal.objects.Evaluator;
import carmetal.objects.MoveableObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import carmetal.rene.zirkel.expression.InvalidException;
import carmetal.rene.zirkel.graphics.MyGraphics;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class UserFunctionObject
extends ConstructionObject
implements MoveableObject,
DriverObject,
Evaluator {
    static Count N = new Count();
    Expression EY = null;
    double[] X = new double[]{0.0};
    String[] Var = new String[]{"x"};
    protected double Xpos;
    protected double Ypos;
    protected boolean Fixed;
    protected Expression EXpos;
    protected Expression EYpos;
    String LASTE = "";
    double C;
    double R;
    double W;
    double H;
    public boolean EditAborted;
    double oldx;
    double oldy;
    double startx;
    double starty;

    public UserFunctionObject(Construction c2) {
        super(c2);
        this.validate();
        this.updateText();
        N.reset();
    }

    @Override
    public void setDefaults() {
        this.setShowName(Global.getParameter("options.text.shownames", false));
        this.setShowValue(Global.getParameter("options.text.showvalues", false));
        this.setColor(Global.getParameter("options.text.color", 0), Global.getParameter("options.text.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.text.colortype", 0));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
        this.setPartial(this.Cn.Partial);
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.text.shownames", false));
        this.setShowValue(Global.getParameter("options.text.showvalues", false));
        this.setColor(Global.getParameter("options.text.color", 0), Global.getParameter("options.text.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.text.colortype", 0));
    }

    @Override
    public String getTag() {
        return "Function";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        this.setText(this.getDisplayValue());
    }

    public boolean isValid() {
        return this.Valid;
    }

    @Override
    public void validate() {
        this.Valid = this.EY != null ? this.EY.isValid() : false;
        if (this.Fixed && this.EXpos != null && this.EXpos.isValid()) {
            try {
                this.Xpos = this.EXpos.getValue();
            }
            catch (Exception e2) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EYpos != null && this.EYpos.isValid()) {
            try {
                this.Ypos = this.EYpos.getValue();
            }
            catch (Exception e3) {
                this.Valid = false;
                return;
            }
        }
    }

    public void setExpressions(String t, String ey) {
        StringTokenizer tok = new StringTokenizer(t);
        this.Var = new String[tok.countTokens()];
        this.X = new double[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            this.Var[i++] = tok.nextToken();
        }
        this.EY = new Expression(ey, this.getConstruction(), this, this.Var);
        this.validate();
    }

    @Override
    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "0";
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        this.H = fm.getHeight();
        this.C = zc.col(this.Xpos);
        this.R = zc.row(this.Ypos);
        g.setColor(this);
        this.setFont(g);
        String s = AngleObject.translateToUnicode(this.getDisplayValue());
        g.drawString(s, this.C, this.R);
        this.R -= this.H;
        this.W = fm.stringWidth(s);
    }

    @Override
    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.X[0];
    }

    public double getValue(String var) throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        for (int i = 0; i < this.Var.length; ++i) {
            if (!var.equals(this.Var[i])) continue;
            return this.X[i];
        }
        return this.X[0];
    }

    @Override
    public String getDisplayValue() {
        String s = "";
        if (this.showName()) {
            if (this.getAlias() != null) {
                s = this.getAlias() + " : ";
            }
            s = s + this.getName() + "(" + this.Var[0];
            for (int i = 1; i < this.Var.length; ++i) {
                s = s + "," + this.Var[i];
            }
            s = s + ")";
            if (this.showValue()) {
                s = s + "=";
            }
        }
        if (this.showValue()) {
            s = s + (this.EY == null ? "" : JProperties.Point_To_Comma(this.EY.toString(), this.Cn, true));
        }
        return s;
    }

    @Override
    public boolean nearto(int cc, int rr, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        return this.C <= (double)cc && this.R <= (double)rr && (double)cc <= this.C + this.W && (double)rr <= this.R + this.H;
    }

    @Override
    public void printArgs(XmlWriter xml) {
        xml.printArg("f", this.EY.toString());
        if (this.Fixed && this.EXpos != null && this.EXpos.isValid()) {
            xml.printArg("x", this.EXpos.toString());
        } else {
            xml.printArg("x", "" + this.Xpos);
        }
        if (this.Fixed && this.EYpos != null && this.EYpos.isValid()) {
            xml.printArg("y", this.EYpos.toString());
        } else {
            xml.printArg("y", "" + this.Ypos);
        }
        if (this.Fixed) {
            xml.printArg("fixed", "true");
        }
        xml.printArg("var", this.getVar());
    }

    @Override
    public void translate() {
        try {
            this.EY = new Expression(this.EY.toString(), this.getConstruction(), this, this.Var);
            ConstructionObject O = this.getTranslation();
            this.setTranslation(this);
            if (this.Fixed) {
                try {
                    this.setFixed(this.EXpos.toString(), this.EYpos.toString());
                    this.EXpos.translate();
                    this.EYpos.translate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.validate();
            this.setTranslation(O);
        }
        catch (Exception e2) {
            System.out.println();
            System.out.println(this.getName());
            System.out.println(e2);
            e2.printStackTrace();
        }
    }

    @Override
    public void setFixed(boolean flag) {
        this.Fixed = flag;
        if (!this.Fixed) {
            this.EYpos = null;
            this.EXpos = null;
        }
        this.updateText();
    }

    @Override
    public void setFixed(String x, String y) {
        this.Fixed = true;
        this.EXpos = new Expression(x, this.getConstruction(), this);
        this.EYpos = new Expression(y, this.getConstruction(), this);
        this.updateText();
    }

    @Override
    public boolean fixed() {
        return this.Fixed;
    }

    @Override
    public String getEXpos() {
        if (this.EXpos != null) {
            return this.EXpos.toString();
        }
        return "" + this.round(this.Xpos);
    }

    @Override
    public String getEYpos() {
        if (this.EYpos != null) {
            return this.EYpos.toString();
        }
        return "" + this.round(this.Ypos);
    }

    @Override
    public boolean onlynearto(int x, int y, ZirkelCanvas zc) {
        return false;
    }

    @Override
    public boolean equals(ConstructionObject o) {
        return false;
    }

    @Override
    public Enumeration depending() {
        DL.reset();
        this.addDepending(this.EY);
        if (this.Fixed) {
            this.addDepending(this.EXpos);
            this.addDepending(this.EYpos);
        }
        return DL.elements();
    }

    public void addDepending(Expression E) {
        if (E != null) {
            Enumeration e2 = E.getDepList().elements();
            while (e2.hasMoreElements()) {
                DL.add((ConstructionObject)e2.nextElement());
            }
        }
    }

    @Override
    public boolean hasUnit() {
        return false;
    }

    public double evaluateF(double[] x) throws ConstructionException {
        int i;
        int n = x.length;
        if (n > this.X.length) {
            n = this.X.length;
        }
        for (i = 0; i < n; ++i) {
            this.X[i] = x[i];
        }
        for (i = n; i < this.X.length; ++i) {
            this.X[i] = 0.0;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    @Override
    public double evaluateF(double x) throws ConstructionException {
        this.X[0] = x;
        for (int i = 1; i < this.X.length; ++i) {
            this.X[i] = 0.0;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    public double evaluateF(double x, double y) throws ConstructionException {
        this.X[0] = x;
        this.X[1] = y;
        for (int i = 2; i < this.X.length; ++i) {
            this.X[i] = 0.0;
        }
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    @Override
    public boolean maybeTransparent() {
        return true;
    }

    @Override
    public boolean canDisplayName() {
        return true;
    }

    @Override
    public boolean isFilledForSelect() {
        return false;
    }

    public String getVar() {
        String vars = this.Var[0];
        for (int i = 1; i < this.Var.length; ++i) {
            vars = vars + " " + this.Var[i];
        }
        return vars;
    }

    @Override
    public void dragTo(double x, double y) {
        this.move(this.oldx + (x - this.startx), this.oldy + (y - this.starty));
    }

    @Override
    public void move(double x, double y) {
        this.Xpos = x;
        this.Ypos = y;
    }

    @Override
    public boolean moveable() {
        return !this.Fixed;
    }

    @Override
    public void startDrag(double x, double y) {
        this.oldx = this.Xpos;
        this.oldy = this.Ypos;
        this.startx = x;
        this.starty = y;
    }

    @Override
    public double getOldX() {
        return this.oldx;
    }

    @Override
    public double getOldY() {
        return this.oldy;
    }

    @Override
    public double getX() {
        return this.Xpos;
    }

    @Override
    public double getY() {
        return this.Ypos;
    }

    @Override
    public boolean isDriverObject() {
        return true;
    }

    @Override
    public boolean somethingChanged() {
        return !this.EY.toString().equals(this.LASTE);
    }

    @Override
    public void clearChanges() {
        this.LASTE = this.EY.toString();
    }
}

