/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.objects.MoveableObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.util.Enumeration;

public class TwoPointLineObject
extends PrimitiveLineObject
implements MoveableObject {
    protected PointObject P2;
    double X2;
    double Y2;
    double R;
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;

    public TwoPointLineObject(Construction c2, PointObject p1, PointObject p2) {
        super(c2);
        this.P1 = p1;
        this.P2 = p2;
    }

    public void setP1P2(PointObject p1, PointObject p2) {
        this.P1 = p1;
        this.P2 = p2;
    }

    public PointObject getP2() {
        return this.P2;
    }

    @Override
    public Enumeration depending() {
        super.depending();
        return this.depset(this.P1, this.P2);
    }

    public double getLength() {
        return this.R;
    }

    @Override
    public void translate() {
        this.P1 = (PointObject)this.P1.getTranslation();
        this.P2 = (PointObject)this.P2.getTranslation();
    }

    @Override
    public boolean contains(PointObject p) {
        return this.P1 == p || this.P2 == p;
    }

    @Override
    public Enumeration secondaryParams() {
        DL.reset();
        return this.depset(this.P1, this.P2);
    }

    @Override
    public void dragTo(double x, double y) {
        this.P1.move(this.x1 + (x - this.x3), this.y1 + (y - this.y3));
        this.P2.move(this.x2 + (x - this.x3), this.y2 + (y - this.y3));
    }

    @Override
    public void move(double x, double y) {
    }

    @Override
    public boolean moveable() {
        return this.P1.moveable() && this.P2.moveable();
    }

    @Override
    public void startDrag(double x, double y) {
        this.x1 = this.P1.getX();
        this.y1 = this.P1.getY();
        this.x2 = this.P2.getX();
        this.y2 = this.P2.getY();
        this.x3 = x;
        this.y3 = y;
    }

    @Override
    public void snap(ZirkelCanvas zc) {
        if (this.moveable()) {
            this.P1.snap(zc);
            this.P2.snap(zc);
        }
    }

    @Override
    public double getOldX() {
        return 0.0;
    }

    @Override
    public double getOldY() {
        return 0.0;
    }
}

