/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.construction.Count;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ExpressionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PointonObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.RayObject;
import carmetal.objects.SegmentObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.MyGraphics13;
import carmetal.rene.zirkel.graphics.PolygonDrawer;
import carmetal.rene.zirkel.graphics.PolygonFiller;
import carmetal.rene.zirkel.structures.Coordinates;
import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

public class TrackObject
extends ConstructionObject
implements PointonObject {
    static Count N = new Count();
    public PointObject PM;
    public ConstructionObject O;
    public ConstructionObject P;
    public int PMax = 16;
    public int PN;
    public ConstructionObject[] PO = new ConstructionObject[this.PMax];
    public boolean Filled = false;
    public boolean Discrete = false;
    public int Type = 0;
    public PolygonFiller PF = null;
    public Vector V = new Vector();
    public Vector[] VO = new Vector[this.PMax];
    public double da = 0.0;
    double oldx;
    double oldy;
    public double X;
    public double Y;
    public double DX;
    public double DY;
    double[] XO = new double[this.PMax];
    double[] YO = new double[this.PMax];
    double[] DXO = new double[this.PMax];
    double[] DYO = new double[this.PMax];
    int Omit = 1;
    public boolean DontProject = false;
    public double DMin = 0.005;
    public double StepSize = 5.0;
    public boolean Fixed = false;
    public boolean StartFix;

    @Override
    public void setFilled(boolean flag) {
        this.Filled = flag;
    }

    @Override
    public boolean isFilled() {
        return this.Filled;
    }

    public TrackObject(Construction c2) {
        super(c2);
    }

    public TrackObject(Construction c2, ConstructionObject p, ConstructionObject[] po, int pn, ConstructionObject o, PointObject pm) {
        super(c2);
        this.P = p;
        this.PN = pn;
        for (int i = 0; i < this.PN; ++i) {
            this.PO[i] = po[i];
        }
        this.O = o;
        this.PM = pm;
        this.validate();
        this.updateText();
    }

    @Override
    public void setDefaults() {
        this.setShowName(Global.getParameter("options.locus.shownames", false));
        this.setShowValue(Global.getParameter("options.locus.showvalues", false));
        this.setColor(Global.getParameter("options.locus.color", 0), Global.getParameter("options.locus.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.locus.colortype", 0));
        this.setFilled(Global.getParameter("options.locus.filled", false));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.locus.shownames", false));
        this.setShowValue(Global.getParameter("options.locus.showvalues", false));
        this.setColor(Global.getParameter("options.locus.color", 0), Global.getParameter("options.locus.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.locus.colortype", 0));
        this.setFilled(Global.getParameter("options.locus.filled", false));
    }

    @Override
    public String getTag() {
        return "Track";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        if (this.PM != null) {
            this.setText(TrackObject.text3(Global.name("text.track"), this.P.getName(), this.PM.getName(), this.O.getName()));
        } else {
            this.setText(TrackObject.text2(Global.name("text.trackof"), this.P.getName(), this.O.getName()));
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        double r;
        double c2;
        double r0;
        double c0;
        Coordinates C;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        Enumeration e2 = this.V.elements();
        if (!this.Discrete && this.isStrongSelected() && g instanceof MyGraphics13) {
            PolygonDrawer pm = new PolygonDrawer(g, this);
            pm.useAsMarker();
            if (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                c0 = zc.col(C.X);
                r0 = zc.row(C.Y);
                pm.drawTo(c0, r0);
                while (e2.hasMoreElements()) {
                    C = (Coordinates)e2.nextElement();
                    c2 = zc.col(C.X);
                    r = zc.row(C.Y);
                    if (Math.abs(c0 - c2) < 100.0 && Math.abs(r0 - r) < 100.0) {
                        pm.drawTo(c2, r);
                    } else {
                        if (this.isFilled()) {
                            this.PF.finishPolygon();
                        }
                        pm.finishPolygon();
                    }
                    c0 = c2;
                    r0 = r;
                }
                pm.finishPolygon();
            }
        }
        e2 = this.V.elements();
        if (this.indicated()) {
            boolean sel = this.P.indicated();
            this.P.setIndicated(true);
            g.setColor(this.P);
            this.P.setIndicated(sel);
        } else {
            g.setColor(this);
        }
        if (this.Discrete) {
            int col = this.getColorIndex();
            int th = this.getColorType();
            if (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                c0 = zc.col(C.X);
                r0 = zc.row(C.Y);
                this.PF.drawTo(c0, r0);
                while (e2.hasMoreElements()) {
                    C = (Coordinates)e2.nextElement();
                    c2 = zc.col(C.X);
                    r = zc.row(C.Y);
                    if (Math.abs(c0 - c2) < 100.0 && Math.abs(r0 - r) < 100.0) {
                        if (this.isFilled()) {
                            this.PF.drawTo(c2, r);
                        }
                    } else if (this.isFilled()) {
                        this.PF.finishPolygon();
                    }
                    if (C.Color >= 0) {
                        this.setColor(C.Color);
                    }
                    if (C.Thickness >= 0) {
                        this.setColorType(C.Thickness);
                    }
                    PointObject.drawPoint(g, zc, this, C.X, C.Y, this.Type);
                    this.setColor(col);
                    this.setColorType(th);
                    c0 = c2;
                    r0 = r;
                }
                if (this.isFilled()) {
                    this.PF.finishPolygon();
                }
            }
            for (int i = 0; i < this.PN; ++i) {
                e2 = this.VO[i].elements();
                g.setColor(this.PO[i]);
                if (!e2.hasMoreElements()) continue;
                C = (Coordinates)e2.nextElement();
                while (e2.hasMoreElements()) {
                    C = (Coordinates)e2.nextElement();
                    if (C.Color >= 0) {
                        this.setColor(C.Color);
                    }
                    if (C.Thickness >= 0) {
                        this.setColorType(C.Thickness);
                    }
                    PointObject.drawPoint(g, zc, this, C.X, C.Y, this.Type);
                    this.setColor(col);
                    this.setColorType(th);
                }
            }
        } else {
            PolygonDrawer pd = new PolygonDrawer(g, this);
            if (this.isFilled()) {
                if (this.PF == null) {
                    this.PF = new PolygonFiller(g, this);
                }
                this.PF.start();
                this.PF.setGraphics(g);
            }
            if (e2.hasMoreElements()) {
                C = (Coordinates)e2.nextElement();
                c0 = zc.col(C.X);
                r0 = zc.row(C.Y);
                pd.drawTo(c0, r0);
                while (e2.hasMoreElements()) {
                    C = (Coordinates)e2.nextElement();
                    c2 = zc.col(C.X);
                    r = zc.row(C.Y);
                    if (Math.abs(c0 - c2) < 100.0 && Math.abs(r0 - r) < 100.0) {
                        if (this.isFilled()) {
                            this.PF.drawTo(c2, r);
                        }
                        pd.drawTo(c2, r);
                    } else {
                        if (this.isFilled()) {
                            this.PF.finishPolygon();
                        }
                        pd.finishPolygon();
                    }
                    c0 = c2;
                    r0 = r;
                }
                if (this.isFilled()) {
                    this.PF.finishPolygon();
                }
                pd.finishPolygon();
            }
            for (int i = 0; i < this.PN; ++i) {
                e2 = this.VO[i].elements();
                g.setColor(this.PO[i]);
                pd = new PolygonDrawer(g, this.PO[i]);
                if (e2.hasMoreElements()) {
                    C = (Coordinates)e2.nextElement();
                    c0 = zc.col(C.X);
                    r0 = zc.row(C.Y);
                    while (e2.hasMoreElements()) {
                        C = (Coordinates)e2.nextElement();
                        c2 = zc.col(C.X);
                        r = zc.row(C.Y);
                        if (Math.abs(c0 - c2) < 100.0 && Math.abs(r0 - r) < 100.0) {
                            pd.drawTo(c2, r);
                        } else {
                            pd.finishPolygon();
                        }
                        c0 = c2;
                        r0 = r;
                    }
                }
                pd.finishPolygon();
            }
        }
    }

    public double getSum(double x, double y) throws ConstructionException {
        if (!this.Valid) {
            throw new ConstructionException("");
        }
        double sum = 0.0;
        boolean started = false;
        double x0 = 0.0;
        double y0 = 0.0;
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            Coordinates C = (Coordinates)e2.nextElement();
            if (started) {
                sum += (-(C.X - x) * (y0 - y) + (C.Y - y) * (x0 - x)) / 2.0;
            }
            x0 = C.X;
            y0 = C.Y;
            started = true;
        }
        return sum;
    }

    public double getSum() throws ConstructionException {
        if (!this.Valid) {
            throw new ConstructionException("");
        }
        double sum = 0.0;
        boolean started = false;
        double x0 = 0.0;
        double y0 = 0.0;
        double x = 0.0;
        double y = 0.0;
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            Coordinates C = (Coordinates)e2.nextElement();
            if (started) {
                sum += (-(C.X - x) * (y0 - y) + (C.Y - y) * (x0 - x)) / 2.0;
            } else {
                x = C.X;
                y = C.Y;
            }
            x0 = C.X;
            y0 = C.Y;
            started = true;
        }
        return sum;
    }

    public double getLength() throws ConstructionException {
        if (!this.Valid) {
            throw new ConstructionException("");
        }
        double sum = 0.0;
        boolean started = false;
        double x0 = 0.0;
        double y0 = 0.0;
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            Coordinates C = (Coordinates)e2.nextElement();
            if (started) {
                sum += Math.sqrt((C.X - x0) * (C.X - x0) + (C.Y - y0) * (C.Y - y0));
            }
            x0 = C.X;
            y0 = C.Y;
            started = true;
        }
        return sum;
    }

    @Override
    public void printArgs(XmlWriter xml) {
        super.printArgs(xml);
        if (this.PM != null) {
            xml.printArg("point", this.PM.getName());
        }
        xml.printArg("on", this.O.getName());
        xml.printArg("track", this.P.getName());
        xml.printArg("dmin", "" + this.DMin);
        for (int i = 0; i < this.PN; ++i) {
            xml.printArg("track" + i, this.PO[i].getName());
        }
        if (this.Filled) {
            xml.printArg("filled", "true");
        }
        if (this.Fixed) {
            xml.printArg("fixed", "true");
        }
        if (this.Discrete) {
            xml.printArg("discrete", "true");
        }
        this.printType(xml);
    }

    public void printType(XmlWriter xml) {
        if (this.Type != 0) {
            switch (this.Type) {
                case 1: {
                    xml.printArg("shape", "diamond");
                    break;
                }
                case 2: {
                    xml.printArg("shape", "circle");
                    break;
                }
                case 3: {
                    xml.printArg("shape", "dot");
                    break;
                }
                case 4: {
                    xml.printArg("shape", "cross");
                    break;
                }
                case 5: {
                    xml.printArg("shape", "dcross");
                }
            }
        }
    }

    @Override
    public Enumeration depending() {
        super.depending();
        if (this.PM != null) {
            DL.add(this.PM);
        }
        DL.add(this.O);
        DL.add(this.P);
        for (int i = 0; i < this.PN; ++i) {
            DL.add(this.PO[i]);
        }
        return DL.elements();
    }

    @Override
    public boolean equals(ConstructionObject o) {
        return false;
    }

    @Override
    public void translate() {
        if (this.PM != null) {
            this.PM = (PointObject)this.PM.getTranslation();
        }
        this.O = this.O.getTranslation();
        this.P = this.P.getTranslation();
    }

    @Override
    public boolean maybeTransparent() {
        return false;
    }

    @Override
    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        int size = (int)zc.selectionSize();
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            Coordinates c2 = (Coordinates)e2.nextElement();
            double col = zc.col(c2.X);
            double row = zc.row(c2.Y);
            if (!(Math.max(Math.abs(col - (double)x), Math.abs(row - (double)y)) < (double)size)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean onlynearto(int c2, int r, ZirkelCanvas zc) {
        return false;
    }

    public double mod(double x) {
        if (x >= Math.PI) {
            return x - Math.PI * 2;
        }
        if (x < -Math.PI) {
            return x + Math.PI * 2;
        }
        return x;
    }

    public synchronized void docompute(ZirkelCanvas zc) {
        block80: {
            boolean Break;
            double a2;
            block81: {
                boolean Break2;
                block79: {
                    boolean Break3;
                    this.V = new Vector();
                    for (int i = 0; i < this.PN; ++i) {
                        this.VO[i] = new Vector();
                    }
                    if (!(this.O instanceof PrimitiveCircleObject)) break block79;
                    zc.getConstruction().shouldSwitch(false);
                    PrimitiveCircleObject c2 = (PrimitiveCircleObject)this.O;
                    double x = c2.getX();
                    double y = c2.getY();
                    double r = c2.getR();
                    this.PM.project(c2);
                    double amin = 0.0;
                    double amax = 0.0;
                    double astart = 0.0;
                    double anull = 0.0;
                    double dmax = 0.5;
                    boolean range = false;
                    if (c2.hasRange()) {
                        double d2;
                        range = true;
                        double a1 = c2.getA1();
                        double a22 = c2.getA2();
                        for (d2 = a22 - a1; d2 < 0.0; d2 += Math.PI * 2) {
                        }
                        while (d2 >= Math.PI * 2) {
                            d2 -= Math.PI * 2;
                        }
                        amin = astart = -d2 / 2.0;
                        amax = d2 / 2.0;
                        anull = (a1 + a22) / 2.0;
                    } else {
                        astart = -3.141278494324434;
                        amin = -3.141278494324434;
                        amax = 3.141278494324434;
                    }
                    double a3 = astart;
                    this.PM.move(x + r * Math.cos(anull + a3), y + r * Math.sin(anull + a3));
                    this.PM.project(c2);
                    zc.getConstruction().validate(this, this.PM);
                    zc.resetSum();
                    double x1 = 0.0;
                    double y1 = 0.0;
                    boolean started = false;
                    if (this.P.valid()) {
                        zc.getConstruction().shouldSwitch(true);
                        if (this.P instanceof PointObject) {
                            PointObject p = (PointObject)this.P;
                            x1 = p.getX();
                            y1 = p.getY();
                            this.addCoordinates(this.V, this.P, x1, y1);
                            started = true;
                        } else if (this.P instanceof PrimitiveLineObject) {
                            PrimitiveLineObject L = (PrimitiveLineObject)this.P;
                            this.X = L.getX();
                            this.Y = L.getY();
                            this.DX = L.getDX();
                            this.DY = L.getDY();
                            started = true;
                        }
                    }
                    boolean[] startedO = new boolean[this.PMax];
                    for (int i = 0; i < this.PN; ++i) {
                        startedO[i] = false;
                    }
                    long time = System.currentTimeMillis();
                    this.addSecondary(startedO);
                    double dmin = this.DMin;
                    if (this.da < 1.0E-10 || this.da > zc.dx(1)) {
                        this.da = zc.dx(1) / 10.0;
                    }
                    double aold = a3;
                    do {
                        a3 += this.da;
                        Break3 = false;
                        if ((!started || range) && a3 >= amax) {
                            a3 = amax;
                            Break3 = true;
                        } else if ((!started || range) && a3 <= amin) {
                            a3 = amin;
                            Break3 = true;
                        } else if (started && this.da > 0.0 && this.mod(aold - astart) < 0.0 && this.mod(a3 - astart) >= 0.0 && !zc.getConstruction().haveSwitched()) {
                            Break3 = true;
                            a3 = astart;
                        }
                        aold = a3;
                        this.PM.move(x + r * Math.cos(anull + a3), y + r * Math.sin(anull + a3));
                        this.PM.project(c2);
                        zc.getConstruction().validate(this, this.PM);
                        if (this.P.valid()) {
                            boolean different;
                            if (!started) {
                                zc.getConstruction().shouldSwitch(true);
                                astart = a3;
                            }
                            double x2 = 0.0;
                            double y2 = 0.0;
                            boolean valid = false;
                            if (this.P instanceof PointObject) {
                                PointObject p = (PointObject)this.P;
                                x2 = p.getX();
                                y2 = p.getY();
                                valid = true;
                            } else if (this.P instanceof PrimitiveLineObject) {
                                PrimitiveLineObject L = (PrimitiveLineObject)this.P;
                                if (!started) {
                                    this.X = L.getX();
                                    this.Y = L.getY();
                                    this.DX = L.getDX();
                                    this.DY = L.getDY();
                                } else {
                                    double dy;
                                    double xx = L.getX();
                                    double yy = L.getY();
                                    double dx = L.getDX();
                                    double det = dx * this.DY - (dy = L.getDY()) * this.DX;
                                    if (Math.sqrt(Math.abs(det)) > 1.0E-9) {
                                        double h = (-(this.X - xx) * this.DY + this.DX * (this.Y - yy)) / -det;
                                        x2 = xx + h * dx;
                                        y2 = yy + h * dy;
                                        valid = true;
                                    }
                                    this.X = xx;
                                    this.Y = yy;
                                    this.DX = dx;
                                    this.DY = dy;
                                }
                            }
                            double dist = zc.dCenter(x2, y2);
                            boolean bl = different = (int)zc.col(x1) != (int)zc.col(x2) || (int)zc.row(y1) != (int)zc.row(y2);
                            if (valid && different) {
                                this.addCoordinates(this.V, this.P, x2, y2);
                            }
                            double dp = Math.abs(x2 - x1) + Math.abs(y2 - y1);
                            this.da = this.updateDA(this.da, valid, dist, dp, dmin, 0.5, zc);
                            x1 = x2;
                            y1 = y2;
                            started = true;
                        } else if (started) {
                            this.da = -this.da;
                        }
                        this.addSecondary(startedO);
                    } while (!Break3 && System.currentTimeMillis() - time <= 1000L);
                    break block80;
                }
                if (!(this.O instanceof PrimitiveLineObject)) break block81;
                zc.getConstruction().shouldSwitch(false);
                PrimitiveLineObject l = (PrimitiveLineObject)this.O;
                this.PM.project(l);
                double lx = l.getX();
                double ly = l.getY();
                double ldx = l.getDX();
                double ldy = l.getDY();
                double amin = 0.0;
                double amax = 0.0;
                double astart = 0.0;
                double dmax = 0.5;
                boolean range = false;
                if (l instanceof RayObject) {
                    astart = 0.0;
                    amin = 0.0;
                    amax = 3.141278494324434;
                    range = true;
                } else if (l instanceof SegmentObject) {
                    astart = 0.0;
                    amin = 0.0;
                    double r = ((SegmentObject)l).getLength();
                    dmax = r / 20.0;
                    amax = Math.atan(r) * 2.0;
                    range = true;
                } else {
                    astart = -3.1415612376632573;
                    amin = -3.1415612376632573;
                    amax = 3.141278494324434;
                }
                double a4 = astart;
                double hd = Math.tan(this.mod(a4) / 2.0);
                this.PM.move(lx + hd * ldx, ly + hd * ldy);
                this.PM.project(l);
                zc.getConstruction().validate(this, this.PM);
                zc.resetSum();
                double x1 = 0.0;
                double y1 = 0.0;
                boolean started = false;
                if (this.P.valid()) {
                    zc.getConstruction().shouldSwitch(true);
                    if (this.P instanceof PointObject) {
                        PointObject p = (PointObject)this.P;
                        x1 = p.getX();
                        y1 = p.getY();
                        this.addCoordinates(this.V, this.P, x1, y1);
                        started = true;
                    } else if (this.P instanceof PrimitiveLineObject) {
                        PrimitiveLineObject L = (PrimitiveLineObject)this.P;
                        this.X = L.getX();
                        this.Y = L.getY();
                        this.DX = L.getDX();
                        this.DY = L.getDY();
                        started = true;
                    }
                }
                boolean[] startedO = new boolean[this.PMax];
                for (int i = 0; i < this.PN; ++i) {
                    startedO[i] = false;
                }
                long time = System.currentTimeMillis();
                this.addSecondary(startedO);
                double dmin = this.DMin;
                if (this.da < 1.0E-10 || this.da > zc.dx(1)) {
                    this.da = zc.dx(1) / 10.0;
                }
                double aold = a4;
                do {
                    a4 += this.da;
                    Break2 = false;
                    if ((!started || range) && a4 >= amax) {
                        a4 = amax;
                        Break2 = true;
                    } else if ((!started || range) && a4 <= amin) {
                        a4 = amin;
                        Break2 = true;
                    } else if (started && this.da > 0.0 && this.mod(aold - astart) < 0.0 && this.mod(a4 - astart) >= 0.0 && !zc.getConstruction().haveSwitched()) {
                        Break2 = true;
                        a4 = astart;
                    }
                    aold = a4;
                    hd = Math.tan(this.mod(a4) / 2.0);
                    this.PM.move(lx + hd * ldx, ly + hd * ldy);
                    this.PM.project(l);
                    zc.getConstruction().validate(this, this.PM);
                    if (this.P.valid()) {
                        boolean different;
                        if (!started) {
                            zc.getConstruction().shouldSwitch(true);
                            astart = a4;
                        }
                        double x2 = 0.0;
                        double y2 = 0.0;
                        boolean valid = false;
                        if (this.P instanceof PointObject) {
                            PointObject p = (PointObject)this.P;
                            x2 = p.getX();
                            y2 = p.getY();
                            valid = true;
                        } else if (this.P instanceof PrimitiveLineObject) {
                            PrimitiveLineObject L = (PrimitiveLineObject)this.P;
                            if (!started) {
                                this.X = L.getX();
                                this.Y = L.getY();
                                this.DX = L.getDX();
                                this.DY = L.getDY();
                            } else {
                                double dy;
                                double xx = L.getX();
                                double yy = L.getY();
                                double dx = L.getDX();
                                double det = dx * this.DY - (dy = L.getDY()) * this.DX;
                                if (Math.sqrt(Math.abs(det)) > 1.0E-9) {
                                    double h = (-(this.X - xx) * this.DY + this.DX * (this.Y - yy)) / -det;
                                    x2 = xx + h * dx;
                                    y2 = yy + h * dy;
                                    valid = true;
                                }
                                this.X = xx;
                                this.Y = yy;
                                this.DX = dx;
                                this.DY = dy;
                            }
                        }
                        double dist = zc.dCenter(x2, y2);
                        boolean bl = different = (int)zc.col(x1) != (int)zc.col(x2) || (int)zc.row(y1) != (int)zc.row(y2);
                        if (valid && different) {
                            this.addCoordinates(this.V, this.P, x2, y2);
                        }
                        double dp = Math.abs(x2 - x1) + Math.abs(y2 - y1);
                        this.da = this.updateDA(this.da, valid, dist, dp, dmin, dmax, zc);
                        x1 = x2;
                        y1 = y2;
                        started = true;
                    } else if (started) {
                        this.da = -this.da;
                    }
                    this.addSecondary(startedO);
                } while (!Break2 && System.currentTimeMillis() - time <= 1000L);
                break block80;
            }
            if (!(this.O instanceof ExpressionObject)) break block80;
            zc.getConstruction().shouldSwitch(false);
            ExpressionObject eo = (ExpressionObject)this.O;
            if (!eo.isSlider()) {
                return;
            }
            double amin = 0.0;
            double amax = 0.0;
            double astart = 0.0;
            double dmax = 0.5;
            boolean range = false;
            astart = 0.0;
            amin = 0.0;
            double r = 1.0;
            dmax = 0.05;
            amax = 1.0;
            range = true;
            double hd = a2 = astart;
            eo.setSliderPosition(0.0);
            zc.getConstruction().validate(this.P, null);
            zc.resetSum();
            double x1 = 0.0;
            double y1 = 0.0;
            boolean started = false;
            if (this.P.valid()) {
                zc.getConstruction().shouldSwitch(true);
                if (this.P instanceof PointObject) {
                    PointObject p = (PointObject)this.P;
                    x1 = p.getX();
                    y1 = p.getY();
                    this.addCoordinates(this.V, this.P, x1, y1);
                    started = true;
                } else if (this.P instanceof PrimitiveLineObject) {
                    PrimitiveLineObject L = (PrimitiveLineObject)this.P;
                    this.X = L.getX();
                    this.Y = L.getY();
                    this.DX = L.getDX();
                    this.DY = L.getDY();
                    started = true;
                }
            }
            boolean[] startedO = new boolean[this.PMax];
            for (int i = 0; i < this.PN; ++i) {
                startedO[i] = false;
            }
            long time = System.currentTimeMillis();
            this.addSecondary(startedO);
            double dmin = this.DMin;
            if (this.da < 1.0E-10 || this.da > zc.dx(1)) {
                this.da = zc.dx(1) / 10.0;
            }
            double aold = a2;
            double x2 = 0.0;
            double y2 = 0.0;
            do {
                a2 += this.da;
                Break = false;
                if ((!started || range) && a2 >= amax) {
                    a2 = amax;
                    Break = true;
                } else if ((!started || range) && a2 <= amin) {
                    a2 = amin;
                    Break = true;
                } else if (started && this.da > 0.0 && this.mod(aold - astart) < 0.0 && this.mod(a2 - astart) >= 0.0 && !zc.getConstruction().haveSwitched()) {
                    Break = true;
                    a2 = astart;
                }
                aold = a2;
                hd = a2;
                eo.setSliderPosition(hd);
                zc.getConstruction().validate(this.P, null);
                if (this.P.valid()) {
                    boolean different;
                    if (!started) {
                        zc.getConstruction().shouldSwitch(true);
                        astart = a2;
                    }
                    boolean valid = false;
                    if (this.P instanceof PointObject) {
                        PointObject p = (PointObject)this.P;
                        x2 = p.getX();
                        y2 = p.getY();
                        valid = true;
                    } else if (this.P instanceof PrimitiveLineObject) {
                        PrimitiveLineObject L = (PrimitiveLineObject)this.P;
                        if (!started) {
                            this.X = L.getX();
                            this.Y = L.getY();
                            this.DX = L.getDX();
                            this.DY = L.getDY();
                        } else {
                            double dy;
                            double xx = L.getX();
                            double yy = L.getY();
                            double dx = L.getDX();
                            double det = dx * this.DY - (dy = L.getDY()) * this.DX;
                            if (Math.sqrt(Math.abs(det)) > 1.0E-9) {
                                double h = (-(this.X - xx) * this.DY + this.DX * (this.Y - yy)) / -det;
                                x2 = xx + h * dx;
                                y2 = yy + h * dy;
                                valid = true;
                            }
                            this.X = xx;
                            this.Y = yy;
                            this.DX = dx;
                            this.DY = dy;
                        }
                    }
                    double dist = zc.dCenter(x2, y2);
                    boolean bl = different = (int)zc.col(x1) != (int)zc.col(x2) || (int)zc.row(y1) != (int)zc.row(y2);
                    if (valid && different) {
                        this.addCoordinates(this.V, this.P, x2, y2);
                    }
                    double dp = Math.abs(x2 - x1) + Math.abs(y2 - y1);
                    this.da = this.updateDA(this.da, valid, dist, dp, dmin, dmax, zc);
                    x1 = x2;
                    y1 = y2;
                    started = true;
                } else if (started) {
                    this.addCoordinates(this.V, this.P, x2, y2);
                    this.da = -this.da;
                }
                this.addSecondary(startedO);
            } while (!Break && System.currentTimeMillis() - time <= 1000L);
        }
    }

    public synchronized void compute(ZirkelCanvas zc) {
        if (this.Fixed && !this.StartFix) {
            return;
        }
        this.StartFix = false;
        double x = 0.0;
        double y = 0.0;
        if (this.PM != null) {
            x = this.PM.getX();
            y = this.PM.getY();
        } else if (this.O instanceof ExpressionObject && ((ExpressionObject)this.O).isSlider()) {
            x = ((ExpressionObject)this.O).getSliderPosition();
        }
        zc.getConstruction().clearSwitches();
        zc.getConstruction().shouldSwitch(true);
        this.DontProject = true;
        this.docompute(zc);
        this.DontProject = false;
        zc.getConstruction().shouldSwitch(false);
        zc.getConstruction().clearSwitches();
        if (this.PM != null) {
            this.PM.move(x, y);
        } else if (this.O instanceof ExpressionObject && ((ExpressionObject)this.O).isSlider()) {
            ((ExpressionObject)this.O).setSliderPosition(x);
        }
        Enumeration e2 = this.V.elements();
        if (e2.hasMoreElements()) {
            Coordinates c2 = (Coordinates)e2.nextElement();
            x = c2.X;
            y = c2.Y;
            double col1 = zc.col(c2.X);
            double row1 = zc.row(c2.Y);
            while (e2.hasMoreElements()) {
                c2 = (Coordinates)e2.nextElement();
                double col2 = zc.col(c2.X);
                double row2 = zc.row(c2.Y);
                c2.flag = Math.abs(col2 - col1) < 100.0 && Math.abs(row2 - row1) < 100.0;
                row1 = row2;
                col1 = col2;
            }
        }
        zc.dovalidate();
    }

    public void addSecondary(boolean[] startedO) {
        for (int i = 0; i < this.PN; ++i) {
            double dy;
            if (!this.PO[i].valid()) continue;
            if (this.PO[i] instanceof PointObject) {
                PointObject p = (PointObject)this.PO[i];
                this.addCoordinates(this.VO[i], p, p.getX(), p.getY());
                this.VO[i].addElement(new Coordinates(p.getX(), p.getY()));
                continue;
            }
            if (!(this.PO[i] instanceof PrimitiveLineObject)) continue;
            PrimitiveLineObject L = (PrimitiveLineObject)this.PO[i];
            if (!startedO[i]) {
                this.XO[i] = L.getX();
                this.YO[i] = L.getY();
                this.DXO[i] = L.getDX();
                this.DYO[i] = L.getDY();
                startedO[i] = true;
                continue;
            }
            double xx = L.getX();
            double yy = L.getY();
            double dx = L.getDX();
            double det = dx * this.DYO[i] - (dy = L.getDY()) * this.DXO[i];
            if (!(Math.sqrt(Math.abs(det)) > 1.0E-9)) continue;
            double h = (-(this.XO[i] - xx) * this.DYO[i] + this.DXO[i] * (this.YO[i] - yy)) / -det;
            this.XO[i] = xx;
            this.YO[i] = yy;
            this.DXO[i] = dx;
            this.DYO[i] = dy;
            this.addCoordinates(this.VO[i], this.PO[i], xx + h * dx, yy + h * dy);
        }
    }

    public void addCoordinates(Vector v, ConstructionObject p, double x, double y) {
        Coordinates C = new Coordinates(x, y);
        if (this.Discrete && p instanceof PointObject) {
            C.Color = p.getColorIndex();
            C.Thickness = p.getColorType();
        }
        v.addElement(C);
    }

    public void addCoordinates(Vector v, ConstructionObject p) {
        v.addElement(new Coordinates(p.getX(), p.getY()));
    }

    public void addCoordinates(Vector v, double x, double y) {
        v.addElement(new Coordinates(x, y));
    }

    public double updateDA(double da, boolean valid, double dist, double dp, double dmin, double dmax, ZirkelCanvas zc) {
        if (this.V.size() > 0 && valid) {
            if (dist < 1.2) {
                if (dp > zc.dx(this.StepSize)) {
                    da /= 2.0;
                } else if (dp < zc.dx(this.StepSize / 2.0)) {
                    da *= 2.0;
                }
                if (da > 0.0 && da < dmin) {
                    da = dmin;
                } else if (da < 0.0 && da > -dmin) {
                    da = -dmin;
                }
                if (da > dmax) {
                    da = dmax;
                } else if (da < -dmax) {
                    da = -dmax;
                }
            } else {
                if (dp > zc.dx(this.StepSize * 10.0)) {
                    da /= 2.0;
                } else if (dp < zc.dx(this.StepSize * 5.0)) {
                    da *= 2.0;
                }
                if (da > 0.0 && da < dmin) {
                    da = dmin;
                } else if (da < 0.0 && da > -dmin) {
                    da = -dmin;
                }
                if (da > dmax) {
                    da = dmax;
                } else if (da < -dmax) {
                    da = -dmax;
                }
            }
        }
        return da;
    }

    @Override
    public boolean hasUnit() {
        return false;
    }

    @Override
    public synchronized void project(PointObject P) {
        if (this.DontProject) {
            return;
        }
        Enumeration e2 = this.V.elements();
        double x = 0.0;
        double y = 0.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double dmin = 0.0;
        boolean started = false;
        while (e2.hasMoreElements()) {
            Coordinates c2 = (Coordinates)e2.nextElement();
            double x1 = c2.X;
            double y1 = c2.Y;
            if (!started) {
                dmin = Math.sqrt((P.getX() - x1) * (P.getX() - x1) + (P.getY() - y1) * (P.getY() - y1));
                x0 = x = x1;
                y0 = y = y1;
                started = true;
                continue;
            }
            if (c2.flag) {
                double g;
                double h = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
                if (h < 1.0E-10) {
                    h = 1.0E-10;
                }
                if ((g = (P.getX() - x0) * (x1 - x0) + (P.getY() - y0) * (y1 - y0)) < 0.0) {
                    g = 0.0;
                }
                if (g > h) {
                    g = h;
                }
                double x2 = x0 + g / h * (x1 - x0);
                double y2 = y0 + g / h * (y1 - y0);
                double d2 = Math.sqrt((P.getX() - x2) * (P.getX() - x2) + (P.getY() - y2) * (P.getY() - y2));
                if (d2 < dmin) {
                    dmin = d2;
                    x = x2;
                    y = y2;
                }
            }
            x0 = x1;
            y0 = y1;
        }
        if (started) {
            P.setXY(x, y);
            P.Valid = true;
        } else {
            P.Valid = false;
        }
    }

    @Override
    public synchronized int getDistance(PointObject P) {
        Enumeration e2 = this.V.elements();
        double x = 0.0;
        double y = 0.0;
        double x0 = 0.0;
        double y0 = 0.0;
        double dmin = 0.0;
        boolean started = false;
        while (e2.hasMoreElements()) {
            Coordinates c2 = (Coordinates)e2.nextElement();
            double x1 = c2.X;
            double y1 = c2.Y;
            if (!started) {
                dmin = Math.sqrt((P.getX() - x1) * (P.getX() - x1) + (P.getY() - y1) * (P.getY() - y1));
                x0 = x = x1;
                y0 = y = y1;
                started = true;
                continue;
            }
            if (c2.flag) {
                double g;
                double h = (x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0);
                if (h < 1.0E-10) {
                    h = 1.0E-10;
                }
                if ((g = (P.getX() - x0) * (x1 - x0) + (P.getY() - y0) * (y1 - y0)) < 0.0) {
                    g = 0.0;
                }
                if (g > h) {
                    g = h;
                }
                double x2 = x0 + g / h * (x1 - x0);
                double y2 = y0 + g / h * (y1 - y0);
                double d2 = Math.sqrt((P.getX() - x2) * (P.getX() - x2) + (P.getY() - y2) * (P.getY() - y2));
                if (d2 < dmin) {
                    dmin = d2;
                    x = x2;
                    y = y2;
                }
            }
            x0 = x1;
            y0 = y1;
        }
        if (started) {
            P.Valid = true;
            double dd = Math.sqrt((P.getX() - x) * (P.getX() - x) + (P.getY() - y) * (P.getY() - y));
            return (int)Math.round(dd * this.Cn.getPixel());
        }
        P.Valid = false;
        return Integer.MAX_VALUE;
    }

    @Override
    public String getDisplayValue() {
        try {
            return "" + this.getSum();
        }
        catch (Exception e2) {
            return "???";
        }
    }

    @Override
    public void project(PointObject P, double alpha) {
        this.project(P);
    }

    @Override
    public boolean canDisplayName() {
        return false;
    }

    @Override
    public boolean isFixed() {
        return this.Fixed;
    }

    @Override
    public void setFixed(boolean f2) {
        this.Fixed = f2;
        if (this.Fixed) {
            this.StartFix = true;
        }
    }

    public void setDMin(double dmin) {
        this.DMin = dmin;
    }

    public double getDMin() {
        return this.DMin;
    }

    @Override
    public int getType() {
        return this.Type;
    }

    @Override
    public void setType(int type) {
        this.Type = type;
    }

    public boolean isDiscrete() {
        return this.Discrete;
    }

    public void setDiscrete(boolean discrete) {
        this.Discrete = discrete;
    }

    @Override
    public boolean canInteresectWith(ConstructionObject o) {
        return true;
    }

    @Override
    public void repulse(PointObject P) {
        this.project(P);
    }
}

