/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.Count;
import carmetal.objects.ConstructionObject;
import carmetal.objects.InsideObject;
import carmetal.objects.PointObject;
import carmetal.objects.PointonObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.MyGraphics13;
import carmetal.rene.zirkel.structures.Coordinates;
import java.awt.Color;
import java.util.Enumeration;

public class PrimitiveCircleObject
extends ConstructionObject
implements PointonObject,
InsideObject {
    protected double X;
    protected double Y;
    protected double R;
    static Count N = new Count();
    boolean Partial = false;
    PointObject[] Dep;
    int NDep;
    PointObject M;
    boolean Filled = false;
    String StartPtName = null;
    String EndPtName = null;
    PointObject StartPt = null;
    PointObject EndPt = null;
    double A1;
    double A2;
    double A;
    boolean Arc = true;

    public PrimitiveCircleObject(Construction c2, PointObject p) {
        super(c2);
        this.setColor(this.ColorIndex, this.SpecialColor);
        this.M = p;
        this.Unit = Global.getParameter("unit.length", "");
    }

    public void setMR(PointObject p1, double r) {
        this.M = p1;
        this.R = r;
    }

    @Override
    public void setDefaults() {
        this.setShowName(Global.getParameter("options.circle.shownames", false));
        this.setShowValue(Global.getParameter("options.circle.showvalues", false));
        this.setColor(Global.getParameter("options.circle.color", 0), Global.getParameter("options.circle.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.circle.colortype", 0));
        this.setFilled(Global.getParameter("options.circle.filled", false));
        this.setSolid(Global.getParameter("options.circle.solid", false));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
        this.setPartial(this.Cn.Partial);
        this.Cn.updateCircleDep();
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.circle.shownames", false));
        this.setShowValue(Global.getParameter("options.circle.showvalues", false));
        this.setColor(Global.getParameter("options.circle.color", 0), Global.getParameter("options.circle.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.circle.colortype", 0));
        this.setFilled(Global.getParameter("options.circle.filled", false));
        this.setSolid(Global.getParameter("options.circle.solid", false));
    }

    @Override
    public String getTag() {
        return "Circle";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        double c1 = zc.col(this.X - this.R);
        double c2 = zc.col(this.X + this.R);
        double r1 = zc.row(this.Y + this.R);
        double r2 = zc.row(this.Y - this.R);
        double r = (r2 - r1) / 2.0;
        double ssa = 1.0 / Math.sqrt(2.0);
        double ssb = -ssa;
        if (!zc.showHidden() && this.Dep != null && this.NDep > 0 && this.Partial && !this.hasRange()) {
            for (int i = 0; i < this.NDep; ++i) {
                String s;
                if (!this.Dep[i].valid() || !zc.isPreview() && this.Dep[i].mustHide(zc)) continue;
                double A = Math.atan2(this.Dep[i].getY() - this.Y, this.Dep[i].getX() - this.X);
                if (A < 0.0) {
                    A += Math.PI * 2;
                }
                double a2 = A / Math.PI * 180.0;
                if (this.visible(zc)) {
                    if (this.isStrongSelected() && g instanceof MyGraphics13) {
                        ((MyGraphics13)g).drawMarkerArc((c1 + c2) / 2.0, (r1 + r2) / 2.0, r, a2 - 10.0, 20.0);
                    }
                    g.setColor(this);
                    g.drawCircleArc(c1 + r, r1 + r, r, a2 - 10.0, 20.0, this);
                }
                if (i != 0 || (s = this.getDisplayText()).equals("")) continue;
                g.setLabelColor(this);
                this.DisplaysText = true;
                double sx = Math.cos(A - 0.1);
                double sy = Math.sin(A - 0.1);
                this.drawLabel(g, s, zc, this.X + sx * this.R, this.Y + sy * this.R, sy, -sx, this.XcOffset, this.YcOffset);
            }
        } else {
            if (this.hasRange()) {
                this.computeA1A2();
                if (this.visible(zc)) {
                    if (this.isStrongSelected() && g instanceof MyGraphics13) {
                        ((MyGraphics13)g).drawMarkerArc((c1 + c2) / 2.0, (r1 + r2) / 2.0, r, this.A1 / Math.PI * 180.0, this.A / Math.PI * 180.0);
                    }
                    g.setColor(this);
                    if (this.Filled) {
                        g.fillArc(c1, r1, c2 - c1, r2 - r1, this.A1 / Math.PI * 180.0, this.A / Math.PI * 180.0, this.Selected || this.getColorType() != 2, this.getColorType() != 1, this.Arc, this);
                    } else if (this.visible(zc)) {
                        g.drawCircleArc(c1 + r, r1 + r, r, this.A1 / Math.PI * 180.0, this.A / Math.PI * 180.0, this);
                    }
                }
                ssa = Math.cos(this.A1 + this.A / 2.0);
                ssb = Math.sin(this.A1 + this.A / 2.0);
            } else if (this.Filled) {
                if (this.visible(zc)) {
                    if (this.isStrongSelected() && g instanceof MyGraphics13) {
                        ((MyGraphics13)g).drawMarkerArc((c1 + c2) / 2.0, (r1 + r2) / 2.0, r, 0.0, 360.0);
                    }
                    g.setColor(this);
                    g.fillOval(c1, r1, c2 - c1, r2 - r1, this.Indicated || this.Selected || this.getColorType() == 0, this.getColorType() != 1, this);
                }
            } else if (this.visible(zc)) {
                if (this.isStrongSelected() && g instanceof MyGraphics13) {
                    ((MyGraphics13)g).drawMarkerArc((c1 + c2) / 2.0, (r1 + r2) / 2.0, r, 0.0, 360.0);
                }
                g.setColor(this);
                if (this.tracked()) {
                    zc.UniversalTrack.drawTrackCircle(this, c1 + r, r1 + r, r);
                }
                g.drawCircle(c1 + r, r1 + r, r, this);
            }
            String s = this.getDisplayText();
            if (!s.equals("")) {
                g.setLabelColor(this);
                this.DisplaysText = true;
                this.drawLabel(g, s, zc, this.X + ssa * this.R, this.Y + ssb * this.R, -ssa, ssb, this.XcOffset, this.YcOffset);
            }
        }
    }

    @Override
    public String getDisplayValue() {
        return Global.getLocaleNumber(this.R, "lengths");
    }

    @Override
    public String getEquation() {
        return "(x" + this.helpDisplayNumber(false, -this.X) + ")^2+(y" + this.helpDisplayNumber(false, -this.Y) + ")^2=" + this.helpDisplayNumber(true, this.R * this.R);
    }

    @Override
    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        return this.nearto(c2, r, false, zc);
    }

    @Override
    public boolean nearto(int c2, int r, boolean ignorefill, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        double x = zc.x(c2) - this.X;
        double y = zc.y(r) - this.Y;
        if (!ignorefill && this.Filled) {
            double d2 = Math.sqrt(x * x + y * y);
            if (d2 < this.R) {
                this.Value = 0.0;
            }
            return d2 < this.R;
        }
        if (this.hasRange()) {
            this.computeA1A2();
            double a2 = Math.atan2(y, x);
            if (a2 < 0.0) {
                a2 += Math.PI * 2;
            }
            if ((a2 -= this.A1) < 0.0) {
                a2 += Math.PI * 2;
            }
            double d3 = Math.abs(Math.sqrt(x * x + y * y) - this.R);
            if (a2 <= this.A + 0.01) {
                this.Value = Math.abs(zc.col(zc.minX() + d3) - zc.col(zc.minX()));
            }
            return this.Value < zc.selectionSize() && a2 <= this.A + 0.01;
        }
        if (!zc.showHidden() && this.NDep > 0 && this.Partial) {
            double d4 = Math.abs(Math.sqrt(x * x + y * y) - this.R);
            this.Value = Math.abs(zc.col(zc.minX() + d4) - zc.col(zc.minX()));
            if (Math.abs(zc.col(zc.minX() + d4) - zc.col(zc.minX())) >= zc.selectionSize()) {
                return false;
            }
            d4 = 0.17453292519943295;
            double a3 = Math.atan2(y, x);
            if (a3 < 0.0) {
                a3 += Math.PI * 2;
            }
            for (int i = 0; i < this.NDep; ++i) {
                double h;
                if (!this.Dep[i].valid() || this.Dep[i].mustHide(zc)) continue;
                double A = Math.atan2(this.Dep[i].getY() - this.Y, this.Dep[i].getX() - this.X);
                if (A < 0.0) {
                    A += Math.PI * 2;
                }
                if ((h = a3 - A) > Math.PI * 2) {
                    h -= Math.PI * 2;
                }
                if (h < Math.PI * -2) {
                    h += Math.PI * 2;
                }
                if (!(Math.abs(h) < d4)) continue;
                return true;
            }
            return false;
        }
        double d5 = Math.abs(Math.sqrt(x * x + y * y) - this.R);
        this.Value = Math.abs(zc.col(zc.minX() + d5) - zc.col(zc.minX()));
        return Math.abs(zc.col(zc.minX() + d5) - zc.col(zc.minX())) < zc.selectionSize();
    }

    @Override
    public boolean onlynearto(int c2, int r, ZirkelCanvas zc) {
        if (this.R < zc.dx(3 * (int)zc.pointSize())) {
            return true;
        }
        if (this.hasRange()) {
            double A;
            double A2;
            double A1 = Math.atan2(this.getStart().getY() - this.Y, this.getStart().getX() - this.X);
            if (A1 < 0.0) {
                A1 += Math.PI * 2;
            }
            if ((A2 = Math.atan2(this.getEnd().getY() - this.Y, this.getEnd().getX() - this.X)) < 0.0) {
                A2 += Math.PI * 2;
            }
            if ((A = A2 - A1) >= Math.PI * 2) {
                A -= Math.PI * 2;
            }
            if (A < 0.0) {
                A += Math.PI * 2;
            }
            if (!this.Obtuse && A > Math.PI) {
                A1 = A2;
                A = Math.PI * 2 - A;
                A2 = A1 + A;
            }
            if (A * this.R < zc.dx(6 * (int)zc.pointSize())) {
                return true;
            }
        }
        return false;
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public double getR() {
        return this.R;
    }

    public static Coordinates intersect(PrimitiveCircleObject c1, PrimitiveCircleObject c2) {
        double dx = c2.X - c1.X;
        double dy = c2.Y - c1.Y;
        double r = Math.sqrt(dx * dx + dy * dy);
        if (r > c1.R + c2.R + 1.0E-10) {
            return null;
        }
        if (r <= 1.0E-10) {
            return new Coordinates(c1.X, c1.Y, c1.X, c1.Y);
        }
        double l = (r * r + c1.R * c1.R - c2.R * c2.R) / (2.0 * r);
        double x = c1.X + l * (dx /= r);
        double y = c1.Y + l * (dy /= r);
        double h = c1.R * c1.R - l * l;
        if (h < -1.0E-10) {
            return null;
        }
        h = h < 0.0 ? 0.0 : Math.sqrt(h);
        return new Coordinates(x + h * dy, y - h * dx, x - h * dy, y + h * dx);
    }

    @Override
    public boolean equals(ConstructionObject o) {
        if (!(o instanceof PrimitiveCircleObject) || !o.valid()) {
            return false;
        }
        PrimitiveCircleObject l = (PrimitiveCircleObject)o;
        return this.equals(this.X, l.X) && this.equals(this.Y, l.Y) && this.equals(this.R, l.R);
    }

    @Override
    public void setPartial(boolean flag) {
        if (flag == this.Partial) {
            return;
        }
        this.Partial = flag;
        if (flag) {
            this.Dep = new PointObject[16];
            this.NDep = 0;
        } else {
            this.Dep = null;
        }
    }

    public void addDep(PointObject p) {
        if (!this.Partial || this.hasRange() || this.Dep == null || this.NDep >= this.Dep.length) {
            return;
        }
        this.Dep[this.NDep++] = p;
    }

    @Override
    public void clearCircleDep() {
        this.NDep = 0;
    }

    @Override
    public boolean isPartial() {
        return this.Partial;
    }

    @Override
    public void printArgs(XmlWriter xml) {
        xml.printArg("midpoint", this.M.getName());
        if (this.Partial) {
            xml.printArg("partial", "true");
        }
        if (this.Filled) {
            xml.printArg("filled", "true");
        }
        if (this.getStart() != null) {
            xml.printArg("start", this.getStart().getName());
        }
        if (this.getEnd() != null) {
            xml.printArg("end", this.getEnd().getName());
        }
        if (!this.Obtuse) {
            xml.printArg("acute", "true");
        }
        if (!this.Arc) {
            xml.printArg("chord", "true");
        }
        super.printArgs(xml);
    }

    @Override
    public ConstructionObject copy(double x, double y) {
        PrimitiveCircleObject o = (PrimitiveCircleObject)super.copy(0.0, 0.0);
        if (o.Partial) {
            o.Dep = new PointObject[16];
            o.NDep = 0;
        } else {
            o.Dep = null;
        }
        return o;
    }

    @Override
    public Enumeration depending() {
        super.depending();
        DL.add(this.M);
        return DL.elements();
    }

    @Override
    public Enumeration secondaryParams() {
        DL.reset();
        return this.depset(this.M);
    }

    @Override
    public void toggleHidden() {
        if (this.Hidden) {
            this.Hidden = false;
        } else if (this.Partial) {
            this.setPartial(false);
            this.Hidden = true;
        } else {
            this.setPartial(true);
        }
    }

    public PointObject getP1() {
        return this.M;
    }

    @Override
    public void setFilled(boolean flag) {
        this.Filled = flag;
    }

    @Override
    public boolean isFilled() {
        return this.Filled;
    }

    @Override
    public boolean isFilledForSelect() {
        return this.Filled;
    }

    @Override
    public void translate() {
        this.M = (PointObject)this.M.getTranslation();
        if (this.hasRange()) {
            this.StartPt = (PointObject)this.StartPt.getTranslation();
            this.EndPt = (PointObject)this.EndPt.getTranslation();
            this.StartPtName = this.StartPt.getName();
            this.EndPtName = this.EndPt.getName();
        }
    }

    public void setRange(String s1, String s2) {
        this.StartPtName = s1;
        this.EndPtName = s2;
        this.setRange((PointObject)this.Cn.find(this.StartPtName), (PointObject)this.Cn.find(this.EndPtName));
    }

    public void setRange(PointObject p1, PointObject p2) {
        this.StartPt = p1;
        this.EndPt = p2;
    }

    public PointObject getStart() {
        if (this.StartPt == null && this.StartPtName != null) {
            this.StartPt = (PointObject)this.Cn.find(this.StartPtName);
        }
        return this.StartPt;
    }

    public PointObject getEnd() {
        if (this.EndPt == null && this.EndPtName != null) {
            this.EndPt = (PointObject)this.Cn.find(this.EndPtName);
        }
        return this.EndPt;
    }

    public double getA1() {
        return this.A1;
    }

    public double getA2() {
        return this.A2;
    }

    public boolean hasRange() {
        return this.getStart() != null && this.getEnd() != null;
    }

    public void clearRange() {
        this.EndPt = null;
        this.StartPt = null;
        this.EndPtName = null;
        this.StartPtName = null;
    }

    @Override
    public boolean maybeTransparent() {
        return true;
    }

    @Override
    public boolean locallyLike(ConstructionObject o) {
        if (!(o instanceof PrimitiveCircleObject)) {
            return false;
        }
        return this.equals(this.X, ((PrimitiveCircleObject)o).X) && this.equals(this.Y, ((PrimitiveCircleObject)o).Y) && this.equals(this.R, ((PrimitiveCircleObject)o).R);
    }

    public boolean getArc() {
        return this.Arc;
    }

    public void setArc(boolean flag) {
        this.Arc = flag;
    }

    public void computeA1A2() {
        this.A1 = Math.atan2(this.getStart().getY() - this.Y, this.getStart().getX() - this.X);
        if (this.A1 < 0.0) {
            this.A1 += Math.PI * 2;
        }
        this.A2 = Math.atan2(this.getEnd().getY() - this.Y, this.getEnd().getX() - this.X);
        if (this.A2 < 0.0) {
            this.A2 += Math.PI * 2;
        }
        if (this.A2 < this.A1) {
            this.A2 += Math.PI * 2;
        }
        this.A = this.A2 - this.A1;
        if (!this.Obtuse && this.A > 3.141592653689793) {
            this.A1 = this.A2;
            if (this.A1 >= Math.PI * 2) {
                this.A1 -= Math.PI * 2;
            }
            this.A = Math.PI * 2 - this.A;
            this.A2 = this.A1 + this.A;
        }
        if (this.Partial) {
            this.A1 -= 0.17453292519943295;
            this.A += 0.3490658503988659;
        }
    }

    public boolean contains(double x, double y) {
        double d2;
        if (!this.hasRange()) {
            return true;
        }
        this.computeA1A2();
        double a2 = Math.atan2(y - this.Y, x - this.X);
        if (a2 < 0.0) {
            a2 += Math.PI * 2;
        }
        if ((d2 = a2 - this.A1) < 0.0) {
            d2 += Math.PI * 2;
        }
        return d2 < this.A + 1.0E-4;
    }

    @Override
    public void project(PointObject P) {
        double dx = P.getX() - this.getX();
        double dy = P.getY() - this.getY();
        double r = Math.sqrt(dx * dx + dy * dy);
        double X = 0.0;
        double Y = 0.0;
        if (r < 1.0E-10) {
            X = this.getX() + this.getR();
            Y = this.getY();
        } else {
            X = this.getX() + dx / r * this.getR();
            Y = this.getY() + dy / r * this.getR();
        }
        double Alpha = Math.atan2(P.getY() - this.getY(), P.getX() - this.getX());
        if (this.hasRange() && this.getStart() != P && this.getEnd() != P) {
            if (Alpha < 0.0) {
                Alpha += Math.PI * 2;
            }
            this.computeA1A2();
            double a1 = this.getA1();
            double a2 = this.getA2();
            if (Alpha < a1) {
                Alpha += Math.PI * 2;
            }
            if (Alpha > a2) {
                Alpha = Math.PI * 2 - (Alpha - a1) < Alpha - a2 ? a1 : a2;
            }
            X = this.getX() + this.getR() * Math.cos(Alpha);
            Y = this.getY() + this.getR() * Math.sin(Alpha);
        }
        P.setXY(X, Y);
        P.setA(Alpha);
    }

    @Override
    public int getDistance(PointObject P) {
        double dx = P.getX() - this.getX();
        double dy = P.getY() - this.getY();
        double r = Math.sqrt(dx * dx + dy * dy);
        double X = 0.0;
        double Y = 0.0;
        if (r < 1.0E-10) {
            X = this.getX() + this.getR();
            Y = this.getY();
        } else {
            X = this.getX() + dx / r * this.getR();
            Y = this.getY() + dy / r * this.getR();
        }
        double Alpha = Math.atan2(P.getY() - this.getY(), P.getX() - this.getX());
        if (this.hasRange() && this.getStart() != P && this.getEnd() != P) {
            if (Alpha < 0.0) {
                Alpha += Math.PI * 2;
            }
            this.computeA1A2();
            double a1 = this.getA1();
            double a2 = this.getA2();
            if (Alpha < a1) {
                Alpha += Math.PI * 2;
            }
            if (Alpha > a2) {
                Alpha = Math.PI * 2 - (Alpha - a1) < Alpha - a2 ? a1 : a2;
            }
            X = this.getX() + this.getR() * Math.cos(Alpha);
            Y = this.getY() + this.getR() * Math.sin(Alpha);
        }
        double d2 = Math.sqrt((P.getX() - X) * (P.getX() - X) + (P.getY() - Y) * (P.getY() - Y));
        return (int)Math.round(d2 * this.Cn.getPixel());
    }

    @Override
    public void project(PointObject P, double alpha) {
        double dx = P.getX() - this.getX();
        double dy = P.getY() - this.getY();
        double r = Math.sqrt(dx * dx + dy * dy);
        double X = 0.0;
        double Y = 0.0;
        if (r < 1.0E-10) {
            X = this.getX() + this.getR();
            Y = this.getY();
        } else {
            X = this.getX() + dx / r * this.getR();
            Y = this.getY() + dy / r * this.getR();
        }
        if (this.hasRange() && this.getStart() != P && this.getEnd() != P) {
            double Alpha = P.getAlpha();
            if (Alpha < 0.0) {
                Alpha += Math.PI * 2;
            }
            if (Alpha >= Math.PI * 2) {
                Alpha -= Math.PI * 2;
            }
            this.computeA1A2();
            double a1 = this.getA1();
            double a2 = this.getA2();
            if (Alpha < a1) {
                Alpha += Math.PI * 2;
            }
            if (Alpha > a2) {
                Alpha = Math.PI * 2 - (Alpha - a1) < Alpha - a2 ? a1 : a2;
            }
            P.setA(Alpha);
            X = this.getX() + this.getR() * Math.cos(Alpha);
            Y = this.getY() + this.getR() * Math.sin(Alpha);
        } else {
            X = this.getX() + this.getR() * Math.cos(alpha);
            Y = this.getY() + this.getR() * Math.sin(alpha);
        }
        P.setXY(X, Y);
    }

    @Override
    public double containsInside(PointObject P) {
        double dy;
        double dx = P.getX() - this.X;
        double r = Math.sqrt(dx * dx + (dy = P.getY() - this.Y) * dy);
        if (r < this.R * 0.9999999999) {
            return 1.0;
        }
        if (r < this.R * 1.0000000001) {
            return 0.5;
        }
        return 0.0;
    }

    @Override
    public boolean keepInside(PointObject P) {
        double dx = P.getX() - this.X;
        double dy = P.getY() - this.Y;
        double r = Math.sqrt(dx * dx + dy * dy);
        double f2 = 1.0;
        if (this.Filled && this.ColorType == 2) {
            f2 = 0.9999;
        }
        if (r < this.R * f2 || this.R < 1.0E-10) {
            return true;
        }
        P.setXY(this.X + dx / r * (this.R * f2), this.Y + dy / r * (this.R * f2));
        return false;
    }

    @Override
    public boolean canInteresectWith(ConstructionObject o) {
        return true;
    }

    @Override
    public void repulse(PointObject P) {
        this.project(P);
    }
}

