/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.Count;
import carmetal.objects.CircleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveLineObject;
import carmetal.objects.TwoPointLineObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import java.util.Enumeration;

public class IntersectionObject
extends PointObject {
    protected ConstructionObject P1;
    protected ConstructionObject P2;
    private static Count N = new Count();
    protected Expression Away;
    protected boolean StayAway = true;
    protected boolean First;
    protected boolean Switched;
    protected boolean Restricted;
    protected boolean Alternate;

    public IntersectionObject(Construction c2, ConstructionObject p1, ConstructionObject p2) {
        super(c2, 0.0, 0.0);
        this.Moveable = false;
        this.P1 = p1;
        this.P2 = p2;
        this.updateText();
        this.First = true;
        this.Switched = false;
        this.Restricted = true;
        this.Alternate = false;
    }

    @Override
    public String getTag() {
        return "Intersection";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        if (!this.displays(zc)) {
            return false;
        }
        double c2 = zc.col(this.X);
        double r = zc.row(this.Y);
        int size = (int)zc.selectionSize();
        this.Value = Math.abs((double)x - c2) + Math.abs((double)y - r);
        return this.Value <= (double)(size * 5);
    }

    @Override
    public void updateText() {
        try {
            this.setText(IntersectionObject.text2(Global.name("text.intersection"), this.P1.getName(), this.P2.getName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setFirst(boolean flag) {
        this.First = flag;
    }

    public boolean isFirst() {
        return this.First;
    }

    @Override
    public void validate() {
        this.Valid = this.P1.valid() && this.P2.valid();
    }

    public void validate(double x, double y) {
    }

    @Override
    public void printArgs(XmlWriter xml) {
        xml.printArg("first", this.P1.getName());
        xml.printArg("second", this.P2.getName());
        if (this.getAway() != null) {
            if (this.StayAway) {
                xml.printArg("awayfrom", this.getAway().getName());
            } else {
                xml.printArg("closeto", this.getAway().getName());
            }
        }
        this.printType(xml);
        if (!this.Restricted) {
            xml.printArg("valid", "true");
        }
        if (this.Alternate) {
            xml.printArg("alternate", "true");
        }
    }

    public String away() {
        if (this.getAway() != null) {
            return this.getAway().getName();
        }
        return "";
    }

    public boolean stayAway() {
        return this.StayAway;
    }

    public boolean setAway(String s, boolean flag) {
        this.Away = null;
        if (s.equals("")) {
            return true;
        }
        if (this.Cn == null) {
            return true;
        }
        this.Away = new Expression("@\"" + s + "\"", this.Cn, this);
        this.StayAway = flag;
        return this.getAway() != null;
    }

    public boolean setAway(String s) {
        return this.setAway(s, true);
    }

    @Override
    public Enumeration depending() {
        super.depending();
        return this.depset(this.P1, this.P2);
    }

    @Override
    public void translate() {
        this.P1 = this.P1.getTranslation();
        this.P2 = this.P2.getTranslation();
        if (this.getAway() != null) {
            this.setAway(this.getAway().getName(), this.StayAway);
            this.Away.translate();
        }
    }

    public boolean isSwitchable() {
        return false;
    }

    public void autoAway() {
        if (!this.autoAway(this.P1, this.P2)) {
            this.autoAway(this.P2, this.P1);
        }
    }

    boolean autoAway(ConstructionObject o1, ConstructionObject o2) {
        if (o1 instanceof CircleObject) {
            PointObject p1 = ((CircleObject)o1).getP2();
            if (p1.isHidden()) {
                return false;
            }
            if (p1.dependsOn(o2) && !this.nearto(p1)) {
                this.setAway(p1.getName());
                return true;
            }
            if (o2 instanceof CircleObject) {
                PointObject p2 = ((CircleObject)o2).getP2();
                if (p2.isHidden()) {
                    return false;
                }
                if (p1 == p2 && !this.nearto(p1)) {
                    this.setAway(p1.getName());
                    return true;
                }
                return false;
            }
            if (o2 instanceof PrimitiveLineObject) {
                Enumeration en = ((PrimitiveLineObject)o2).points();
                while (en.hasMoreElements()) {
                    ConstructionObject oo = (ConstructionObject)en.nextElement();
                    if (!(oo instanceof PointObject)) continue;
                    PointObject o = (PointObject)oo;
                    if (o.isHidden()) {
                        return false;
                    }
                    if (p1 != o || this.nearto(p1)) continue;
                    this.setAway(p1.getName());
                    return true;
                }
            }
        } else if (o1 instanceof TwoPointLineObject) {
            PointObject p1 = ((TwoPointLineObject)o1).getP1();
            if (!p1.isHidden() && p1.dependsOn(o2) && !this.nearto(p1)) {
                this.setAway(p1.getName());
                return true;
            }
            PointObject p2 = ((TwoPointLineObject)o1).getP2();
            if (!p2.isHidden() && p2.dependsOn(o2) && !this.nearto(p2)) {
                this.setAway(p2.getName());
                return true;
            }
        }
        return false;
    }

    public void switchBack() {
        if (this.Switched) {
            this.First = !this.First;
        }
        this.Switched = false;
    }

    public void doSwitch() {
        this.Switched = !this.Switched;
        this.First = !this.First;
    }

    public boolean isSwitched() {
        return this.Switched;
    }

    public boolean isRestricted() {
        return this.Restricted;
    }

    public void setRestricted(boolean flag) {
        this.Restricted = flag;
    }

    public PointObject getAway() {
        return IntersectionObject.getPointObject(this.Away);
    }

    public void setAlternate(boolean flag) {
        this.Alternate = flag;
    }

    public boolean isAlternate() {
        return this.Alternate;
    }

    public boolean canAlternate() {
        return false;
    }
}

