/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.construction.Count;
import carmetal.objects.AngleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.DriverObject;
import carmetal.objects.MoveableObject;
import carmetal.objects.SimulationObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import carmetal.rene.zirkel.expression.InvalidException;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.graphics.MyGraphics13;
import java.awt.Color;
import java.awt.FontMetrics;
import java.util.Enumeration;

public class ExpressionObject
extends ConstructionObject
implements MoveableObject,
SimulationObject,
DriverObject {
    protected double X;
    protected double Y;
    private static Count N = new Count();
    public Expression E;
    protected Expression EX;
    protected Expression EY;
    protected boolean Fixed;
    String Prompt = Global.name("expression.value");
    protected double CurrentValue = 0.0;
    protected boolean CurrentValueValid = true;
    protected boolean Slider = false;
    protected Expression SMin;
    protected Expression SMax;
    private String LASTE = "";
    private boolean isOwned = false;
    public double C;
    public double R;
    public double W;
    public double H;
    public double SC;
    public double SR;
    public double SW;
    public double SH;
    public double SX;
    public double SY;
    public double SD;
    private double OldE;
    double oldx;
    double oldy;
    double startx;
    double starty;
    boolean DragSlider;

    public ExpressionObject(Construction c2, double x, double y) {
        super(c2);
        this.X = x;
        this.Y = y;
        this.setColor(this.ColorIndex, this.SpecialColor);
        this.updateText();
        this.setFixed("0");
    }

    @Override
    public void setDefaults() {
        this.setShowName(Global.getParameter("options.text.shownames", false));
        this.setShowValue(true);
        this.setColor(Global.getParameter("options.text.color", 0), Global.getParameter("options.text.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.text.colortype", 0));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
        this.setPartial(this.Cn.Partial);
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.text.shownames", false));
        this.setShowValue(Global.getParameter("options.text.showvalues", false));
        this.setColor(Global.getParameter("options.text.color", 0), Global.getParameter("options.text.pcolor", (Color)null));
        this.setColorType(Global.getParameter("options.text.colortype", 0));
    }

    @Override
    public String getTag() {
        return "Expression";
    }

    @Override
    public int getN() {
        return N.next();
    }

    @Override
    public void updateText() {
        if (this.E != null) {
            this.setText(ExpressionObject.text3(Global.name("text.expression"), this.E.toString(), "" + this.roundDisplay(this.X), "" + this.roundDisplay(this.Y)));
        } else {
            this.setText(ExpressionObject.text3(Global.name("text.expression"), "", "" + this.roundDisplay(this.X), "" + this.roundDisplay(this.Y)));
        }
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        this.DisplaysText = false;
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        this.C = zc.col(this.X);
        this.R = zc.row(this.Y);
        this.setFont(g);
        FontMetrics fm = g.getFontMetrics();
        if (this.isStrongSelected() && g instanceof MyGraphics) {
            ((MyGraphics13)g).drawMarkerRect(this.C - 5.0, this.R - 5.0, 10.0, 10.0);
        }
        g.setColor(this);
        String s = "";
        if (this.showName()) {
            s = this.Prompt;
            if (this.showValue()) {
                if (s.endsWith("_") && s.length() > 1) {
                    s = s.substring(0, s.length() - 1);
                } else if (!s.equals("")) {
                    s = s + " = ";
                }
            } else {
                s = this.Prompt;
            }
        }
        if (this.showValue()) {
            try {
                this.E.getValue();
                double x = this.round(this.CurrentValue);
                if (this.Slider) {
                    x = this.round(this.CurrentValue, 100.0);
                }
                s = Math.abs(x - (double)Math.round(x)) < 1.0E-10 ? s + Global.getLocaleNumber((double)((int)x), "edit") : s + Global.getLocaleNumber(x, "edit");
            }
            catch (Exception e2) {
                s = s + "???";
            }
        }
        s = s + this.Unit;
        if ((s = AngleObject.translateToUnicode(s)).equals("") && !this.Slider) {
            s = "-";
        }
        this.W = fm.stringWidth(s);
        if (!s.equals("")) {
            this.setFont(g);
            this.R -= (double)fm.getAscent();
            this.H = g.drawStringExtended(s, this.C, this.R);
            this.W = ((MyGraphics13)g).getW();
        }
        if (this.Slider) {
            int coffset = (int)(4.0 * zc.pointSize());
            this.R += this.H;
            g.drawLine(this.C, this.R + (double)(coffset / 2), this.C + (double)(10 * coffset), this.R + (double)(coffset / 2));
            double d2 = this.getSliderPosition();
            int size = coffset / 4;
            double rslider = this.C + d2 * 10.0 * (double)coffset;
            double cw = 2 * size + 2;
            if (this.getColorType() == 1) {
                g.fillOval(rslider - (double)size - 1.0, this.R + (double)(coffset / 2) - (double)size - 1.0, cw, cw, true, false, this);
            } else {
                g.fillOval(rslider - (double)size - 1.0, this.R + (double)(coffset / 2) - (double)size - 1.0, cw, cw, new Color(250, 250, 250));
                g.setColor(this);
                g.drawOval(rslider - (double)size - 1.0, this.R + (double)(coffset / 2) - (double)size - 1.0, cw, cw);
            }
            this.SC = rslider - (double)size;
            this.SR = this.R + (double)(coffset / 2) - (double)size;
            this.SW = this.SH = (double)(2 * size);
            this.SX = zc.x((int)this.C);
            this.SY = zc.y((int)this.R + coffset / 2 - size);
            this.SD = zc.x((int)this.C + 10 * coffset) - this.SX;
            this.R -= this.H;
        }
    }

    public double getSliderPosition() {
        try {
            double min = this.SMin.getValue();
            double max = this.SMax.getValue();
            double x = this.CurrentValue;
            if (min >= max) {
                this.Valid = false;
                return 0.0;
            }
            if (x < min) {
                x = min;
            }
            if (x > max) {
                x = max;
            }
            return (x - min) / (max - min);
        }
        catch (Exception e2) {
            this.Valid = false;
            return 0.0;
        }
    }

    public void setSliderPosition(double d2) {
        try {
            double min = this.SMin.getValue();
            double max = this.SMax.getValue();
            if (min >= max) {
                this.Valid = false;
                return;
            }
            double value = min + d2 * (max - min);
            if (value < min) {
                value = min;
            }
            if (value > max) {
                value = max;
            }
            this.E.setValue(value);
        }
        catch (Exception e2) {
            this.Valid = false;
        }
    }

    @Override
    public boolean nearto(int x, int y, ZirkelCanvas zc) {
        this.DragSlider = false;
        if (this.Valid && !this.displays(zc)) {
            return false;
        }
        if (this.C <= (double)x && (double)x <= this.C + this.W && this.R <= (double)y && (double)y <= this.R + this.H) {
            return true;
        }
        if (this.SC <= (double)x && this.SR <= (double)y && this.SC + this.SW >= (double)x && this.SR + this.SH >= (double)y) {
            this.DragSlider = true;
            return true;
        }
        return false;
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    public Expression getExp() {
        return this.E;
    }

    @Override
    public void move(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    @Override
    public void snap(ZirkelCanvas zc) {
        double d2 = zc.getGridSize() / 2.0;
        this.X = (double)Math.round(this.X / d2) * d2;
        this.Y = (double)Math.round(this.Y / d2) * d2;
    }

    @Override
    public void round() {
        this.move(this.round(this.X, ZirkelCanvas.LengthsFactor), this.round(this.Y, ZirkelCanvas.LengthsFactor));
    }

    @Override
    public void printArgs(XmlWriter xml) {
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            xml.printArg("x", this.EX.toString());
        } else {
            xml.printArg("x", "" + this.X);
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            xml.printArg("y", this.EY.toString());
        } else {
            xml.printArg("y", "" + this.Y);
        }
        if (this.E != null) {
            xml.printArg("value", this.E.toString());
        } else {
            xml.printArg("value", "");
        }
        xml.printArg("prompt", this.Prompt);
        if (this.Fixed) {
            xml.printArg("fixed", "true");
        }
        if (this.Slider) {
            xml.printArg("slider", "true");
            xml.printArg("min", this.SMin.toString());
            xml.printArg("max", this.SMax.toString());
        }
    }

    @Override
    public boolean equals(ConstructionObject o) {
        return false;
    }

    @Override
    public void setExpression(String expr, Construction c2) throws ConstructionException {
        this.E = new Expression(expr, c2, this);
        this.updateText();
    }

    @Override
    public void setFixed(String expr) {
        this.E = new Expression(expr, this.getConstruction(), this);
        this.updateText();
    }

    @Override
    public String getExpression() {
        if (this.E != null) {
            return this.E.toString();
        }
        return "";
    }

    @Override
    public Enumeration depending() {
        DL.reset();
        this.addDepending(this.E);
        this.addDepending(this.SMin);
        this.addDepending(this.SMax);
        if (this.Fixed) {
            this.addDepending(this.EX);
            this.addDepending(this.EY);
        }
        return DL.elements();
    }

    public void addDepending(Expression EE) {
        if (EE != null) {
            Enumeration e2 = EE.getDepList().elements();
            while (e2.hasMoreElements()) {
                DL.add((ConstructionObject)e2.nextElement());
            }
        }
    }

    @Override
    public double getValue() throws ConstructionException {
        if (!this.CurrentValueValid) {
            throw new InvalidException("");
        }
        return this.CurrentValue;
    }

    @Override
    public String getPrompt() {
        return this.Prompt;
    }

    @Override
    public void setPrompt(String prompt) {
        this.Prompt = prompt;
    }

    @Override
    public void translate() {
        if (this.Slider) {
            this.SMin.translate();
            this.SMax.translate();
        } else {
            this.E.translate();
        }
        if (this.Fixed) {
            try {
                this.setFixed(this.EX.toString(), this.EY.toString());
                this.EX.translate();
                this.EY.translate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.updateText();
    }

    @Override
    public void validate() {
        try {
            this.CurrentValue = this.E.getValue();
            this.CurrentValueValid = true;
        }
        catch (Exception e2) {
            this.CurrentValueValid = false;
        }
        this.Valid = true;
        if (this.Fixed && this.EX != null && this.EX.isValid()) {
            try {
                this.X = this.EX.getValue();
            }
            catch (Exception e3) {
                this.Valid = false;
                return;
            }
        }
        if (this.Fixed && this.EY != null && this.EY.isValid()) {
            try {
                this.Y = this.EY.getValue();
            }
            catch (Exception e4) {
                this.Valid = false;
                return;
            }
        }
    }

    @Override
    public void setFixed(boolean flag) {
        this.Fixed = flag;
        if (!this.Fixed) {
            this.EY = null;
            this.EX = null;
        }
        this.updateText();
    }

    @Override
    public void setFixed(String x, String y) {
        this.Fixed = true;
        this.EX = new Expression(x, this.getConstruction(), this);
        this.EY = new Expression(y, this.getConstruction(), this);
        this.updateText();
    }

    @Override
    public ConstructionObject copy(double x, double y) {
        try {
            ExpressionObject o = (ExpressionObject)this.clone();
            this.setTranslation(o);
            if (this.Slider) {
                o.setSlider(this.SMin.toString(), this.SMax.toString());
            } else {
                o.setExpression(this.E.toString(), this.getConstruction());
            }
            o.translateConditionals();
            o.translate();
            o.setName();
            o.updateText();
            o.setBreak(false);
            o.setTarget(false);
            return o;
        }
        catch (Exception e2) {
            return null;
        }
    }

    @Override
    public boolean moveable() {
        if (this.Slider) {
            return true;
        }
        return this.EX == null && this.EY == null;
    }

    public void reset() {
        if (this.E != null) {
            this.E.reset();
        }
    }

    @Override
    public boolean fixed() {
        return this.Fixed;
    }

    @Override
    public String getEX() {
        if (this.EX != null) {
            return this.EX.toString();
        }
        return "" + this.round(this.X);
    }

    @Override
    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "" + this.round(this.Y);
    }

    public void setCurrentValue(double x) {
        this.CurrentValue = x;
        this.CurrentValueValid = true;
    }

    @Override
    public void setSimulationValue(double x) {
        this.OldE = this.CurrentValue;
        this.CurrentValue = x;
    }

    @Override
    public void resetSimulationValue() {
        this.CurrentValue = this.OldE;
    }

    @Override
    public void setSlider(String smin, String smax) {
        this.Slider = true;
        this.SMin = new Expression(smin, this.getConstruction(), this);
        this.SMax = new Expression(smax, this.getConstruction(), this);
    }

    @Override
    public void setSlider(boolean flag) {
        this.Slider = flag;
    }

    @Override
    public void startDrag(double x, double y) {
        this.oldx = this.X;
        this.oldy = this.Y;
        this.startx = x;
        this.starty = y;
    }

    @Override
    public void dragTo(double x, double y) {
        if (this.DragSlider) {
            this.setSliderPosition((x - this.SX) / this.SD);
        } else {
            this.move(this.oldx + (x - this.startx), this.oldy + (y - this.starty));
        }
    }

    @Override
    public double getOldX() {
        return this.oldx;
    }

    @Override
    public double getOldY() {
        return this.oldy;
    }

    @Override
    public boolean isSlider() {
        return this.Slider;
    }

    public double getMinValue() {
        try {
            double d2 = this.SMin.getValue();
            return d2;
        }
        catch (Exception ex) {
            return -5.0;
        }
    }

    public double getMaxValue() {
        try {
            double d2 = this.SMax.getValue();
            return d2;
        }
        catch (Exception ex) {
            return -5.0;
        }
    }

    @Override
    public String getMin() {
        if (this.Slider) {
            return this.SMin.toString();
        }
        return "-5";
    }

    @Override
    public String getMax() {
        if (this.Slider) {
            return this.SMax.toString();
        }
        return "5";
    }

    @Override
    public String getDisplayValue() {
        String s = "";
        try {
            this.E.getValue();
            double x = this.round(this.CurrentValue);
            if (this.Slider) {
                x = this.round(this.CurrentValue, 100.0);
            }
            s = Math.abs(x - (double)Math.round(x)) < 1.0E-10 ? s + (int)x : s + x;
        }
        catch (Exception e2) {
            s = s + "???";
        }
        s = s + this.Unit;
        return s;
    }

    @Override
    public String getEquation() {
        if (this.E == null) {
            return "???";
        }
        return this.E.toString();
    }

    @Override
    public boolean isDriverObject() {
        return true;
    }

    @Override
    public boolean somethingChanged() {
        return !this.getEquation().equals(this.LASTE);
    }

    @Override
    public void clearChanges() {
        this.LASTE = this.getEquation();
    }

    @Override
    public boolean isOwnedByControl() {
        return this.isOwned;
    }

    @Override
    public void setOwnedByControl(boolean b2) {
        this.isOwned = b2;
    }
}

