/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.objects.ConstructionObject;
import carmetal.objects.PointObject;
import carmetal.objects.PointonObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import carmetal.rene.zirkel.expression.InvalidException;
import carmetal.rene.zirkel.graphics.MyGraphics;
import carmetal.rene.zirkel.structures.Coordinates;
import java.util.Enumeration;
import java.util.Vector;

public class EquationXYObject
extends ConstructionObject
implements PointonObject {
    Vector V = new Vector();
    int Dhor = 100;
    double Wl = 0.0;
    double Wt = 0.0;
    double Ww = 0.0;
    double Wh = 0.0;
    Construction C;
    Expression EY = null;
    double[] X = new double[]{0.0, 0.0};
    String[] Var = new String[]{"x", "y"};
    double[] xv = new double[2];
    double xx;
    double yy;
    double zz;

    public EquationXYObject(Construction c2, String eq) {
        super(c2);
        this.EY = new Expression(eq, c2, this, this.Var);
        this.updateText();
        this.C = c2;
    }

    public EquationXYObject(Construction c2, String eq, int d2) {
        this(c2, eq);
        this.Dhor = d2;
    }

    public int getDhor() {
        return this.Dhor;
    }

    public void setDhor(int newDHor) {
        this.Dhor = newDHor;
        this.compute();
        this.updateText();
    }

    @Override
    public void setDefaults() {
        this.setShowName(Global.getParameter("options.locus.shownames", false));
        this.setShowValue(Global.getParameter("options.locus.showvalues", false));
        this.setColor(Global.getParameter("options.locus.color", 0));
        this.setColorType(Global.getParameter("options.locus.colortype", 0));
        this.setFilled(Global.getParameter("options.locus.filled", false));
        this.setHidden(this.Cn.Hidden);
        this.setObtuse(this.Cn.Obtuse);
        this.setSolid(this.Cn.Solid);
        this.setLarge(this.Cn.LargeFont);
        this.setBold(this.Cn.BoldFont);
    }

    @Override
    public void setTargetDefaults() {
        this.setShowName(Global.getParameter("options.locus.shownames", false));
        this.setShowValue(Global.getParameter("options.locus.showvalues", false));
        this.setColor(Global.getParameter("options.locus.color", 0));
        this.setColorType(Global.getParameter("options.locus.colortype", 0));
        this.setFilled(Global.getParameter("options.locus.filled", false));
    }

    public void setEquation(String eq, ZirkelCanvas zc) {
        this.EY = new Expression(eq, this.C, this, this.Var);
        this.compute();
        this.updateText();
    }

    public double getValue(String var) throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return var.equals("x") ? this.X[0] : this.X[1];
    }

    public double evaluateF(double x, double y) throws ConstructionException {
        this.X[0] = x;
        this.X[1] = y;
        try {
            return this.EY.getValue();
        }
        catch (Exception e2) {
            throw new ConstructionException("");
        }
    }

    public void compute() {
        this.Wl = this.C.getX() - this.C.getW();
        this.Wt = this.C.getY() - this.C.getH() / 2.0;
        this.Ww = 2.0 * this.C.getW();
        this.Wh = this.C.getH();
        this.searchZerosSegments();
    }

    public void searchZerosSegments() {
        int j;
        int i;
        this.V.clear();
        double dx = this.Ww / (double)this.Dhor;
        double dy = dx * Math.sqrt(3.0) / 2.0;
        int xn = this.Dhor + 2;
        int yn = (int)(this.Wh / dy) + 1;
        double[] x = new double[xn + 1];
        double[] y = new double[yn + 1];
        double[][] z = new double[xn + 1][yn + 1];
        for (i = 0; i <= xn; ++i) {
            x[i] = this.Wl - dx + (double)i * dx;
        }
        for (int j2 = 0; j2 <= yn; ++j2) {
            y[j2] = this.Wt + (double)j2 * dy;
        }
        for (i = 0; i <= xn; ++i) {
            for (j = 0; j <= yn; ++j) {
                this.xv[0] = x[i];
                this.xv[1] = y[j];
                if (j % 2 == 0) {
                    this.xv[0] = this.xv[0] + dx / 2.0;
                }
                try {
                    z[i][j] = this.evaluateF(this.xv[0], this.xv[1]);
                    continue;
                }
                catch (Exception e2) {
                    z[i][j] = 0.0;
                }
            }
        }
        for (i = 0; i <= xn - 1; ++i) {
            for (j = 0; j <= yn - 1; ++j) {
                if (j % 2 == 0) {
                    this.searchOneZerosSegment(this.V, x[i] + dx / 2.0, y[j], z[i][j], x[i], y[j + 1], z[i][j + 1], x[i + 1], y[j + 1], z[i + 1][j + 1]);
                    this.searchOneZerosSegment(this.V, x[i] + dx / 2.0, y[j], z[i][j], x[i + 1] + dx / 2.0, y[j], z[i + 1][j], x[i + 1], y[j + 1], z[i + 1][j + 1]);
                    continue;
                }
                this.searchOneZerosSegment(this.V, x[i], y[j], z[i][j], x[i + 1], y[j], z[i + 1][j], x[i] + dx / 2.0, y[j + 1], z[i][j + 1]);
                this.searchOneZerosSegment(this.V, x[i + 1], y[j], z[i + 1][j], x[i + 1] - dx / 2.0, y[j + 1], z[i][j + 1], x[i + 1] + dx / 2.0, y[j + 1], z[i + 1][j + 1]);
            }
        }
    }

    public void searchOneZerosSegment(Vector v, double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        if (z1 * z2 < 0.0) {
            double l1 = z2 / (z2 - z1);
            l1 = this.fix(x1, y1, z1, x2, y2, z2, l1);
            double m1 = 1.0 - l1;
            if (z1 * z3 < 0.0) {
                double l2 = z3 / (z3 - z1);
                l2 = this.fix(x1, y1, z1, x3, y3, z3, l2);
                double m2 = 1.0 - l2;
                v.add(new Coordinates(l1 * x1 + m1 * x2, l1 * y1 + m1 * y2, l2 * x1 + m2 * x3, l2 * y1 + m2 * y3));
            } else {
                double l2 = z3 / (z3 - z2);
                l2 = this.fix(x2, y2, z2, x3, y3, z3, l2);
                double m2 = 1.0 - l2;
                v.add(new Coordinates(l1 * x1 + m1 * x2, l1 * y1 + m1 * y2, l2 * x2 + m2 * x3, l2 * y2 + m2 * y3));
            }
        } else if (z1 * z3 < 0.0) {
            double l1 = z3 / (z3 - z1);
            l1 = this.fix(x1, y1, z1, x3, y3, z3, l1);
            double m1 = 1.0 - l1;
            double l2 = z3 / (z3 - z2);
            l2 = this.fix(x2, y2, z2, x3, y3, z3, l2);
            double m2 = 1.0 - l2;
            v.add(new Coordinates(l1 * x1 + m1 * x3, l1 * y1 + m1 * y3, l2 * x2 + m2 * x3, l2 * y2 + m2 * y3));
        }
    }

    public double fix(double x1, double y1, double z1, double x2, double y2, double z2, double l1) {
        try {
            double z = this.evaluateF(x1 * l1 + x2 * (1.0 - l1), y1 * l1 + y2 * (1.0 - l1));
            if (Math.abs(z) > (Math.abs(z1) + Math.abs(z2)) * 1.0E-5) {
                double mu = 1.0 - l1;
                double mu2 = mu * mu;
                double mu3 = mu2 * mu;
                double mu4 = mu3 * mu;
                double h = Math.sqrt(mu4 * z2 * z2 + ((-2.0 * mu4 + 4.0 * mu3 - 2.0 * mu2) * z1 - 2.0 * mu2 * z) * z2 + (mu4 - 4.0 * mu3 + 6.0 * mu2 - 4.0 * mu + 1.0) * z1 * z1 + (-2.0 * mu2 + 4.0 * mu - 2.0) * z * z1 + z * z);
                double h1 = (mu2 * z2 - mu2 * z1 + z1 - z + h) / (2.0 * (mu * z2 - mu * z1 + z1 - z));
                double h2 = (mu2 * z2 - mu2 * z1 + z1 - z - h) / (2.0 * (mu * z2 - mu * z1 + z1 - z));
                if (h1 >= 0.0 && h1 <= 1.0) {
                    l1 = 1.0 - h1;
                } else if (h2 >= 0.0 && h2 <= 1.0) {
                    l1 = 1.0 - h2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l1;
    }

    @Override
    public void paint(MyGraphics g, ZirkelCanvas zc) {
        if (!this.Valid || this.mustHide(zc)) {
            return;
        }
        g.setColor(this);
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            Coordinates c1 = (Coordinates)e2.nextElement();
            g.drawLine(zc.col(c1.X), zc.row(c1.Y), zc.col(c1.X1), zc.row(c1.Y1), this);
        }
    }

    @Override
    public boolean nearto(int cc, int rr, ZirkelCanvas zc) {
        Enumeration e2 = this.V.elements();
        while (e2.hasMoreElements()) {
            Coordinates c1 = (Coordinates)e2.nextElement();
            if (!(Math.abs(zc.col(c1.X) - (double)cc) + Math.abs(zc.row(c1.Y) - (double)rr) < 5.0) && !(Math.abs(zc.col(c1.X1) - (double)cc) + Math.abs(zc.row(c1.Y1) - (double)rr) < 5.0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getDistance(PointObject P) {
        double dd;
        Coordinates c2;
        this.xx = P.getX();
        this.yy = P.getY();
        double dm = 0.0;
        double xm1 = 0.0;
        double ym1 = 0.0;
        double zm1 = 0.0;
        double xm2 = 0.0;
        double ym2 = 0.0;
        double zm2 = 0.0;
        Enumeration e2 = this.V.elements();
        if (e2.hasMoreElements()) {
            c2 = (Coordinates)e2.nextElement();
            xm1 = c2.X;
            ym1 = c2.Y;
            xm2 = c2.X1;
            ym2 = c2.Y1;
            dm = Math.sqrt((c2.X - this.xx) * (c2.X - this.xx) + (c2.Y - this.yy) * (c2.Y - this.yy)) + Math.sqrt((c2.X1 - this.xx) * (c2.X1 - this.xx) + (c2.Y1 - this.yy) * (c2.Y1 - this.yy)) - Math.sqrt((c2.X - c2.X1) * (c2.X - c2.X1) + (c2.Y - c2.Y1) * (c2.Y - c2.Y1));
        } else {
            return Integer.MAX_VALUE;
        }
        while (e2.hasMoreElements()) {
            c2 = (Coordinates)e2.nextElement();
            dd = Math.sqrt((c2.X - this.xx) * (c2.X - this.xx) + (c2.Y - this.yy) * (c2.Y - this.yy)) + Math.sqrt((c2.X1 - this.xx) * (c2.X1 - this.xx) + (c2.Y1 - this.yy) * (c2.Y1 - this.yy)) - Math.sqrt((c2.X - c2.X1) * (c2.X - c2.X1) + (c2.Y - c2.Y1) * (c2.Y - c2.Y1));
            if (!(dd < dm)) continue;
            xm1 = c2.X;
            ym1 = c2.Y;
            xm2 = c2.X1;
            ym2 = c2.Y1;
            dm = dd;
        }
        double lg = Math.sqrt((xm2 - xm1) * (xm2 - xm1) + (ym2 - ym1) * (ym2 - ym1));
        double dx = (xm2 - xm1) / lg;
        double dy = (ym2 - ym1) / lg;
        double h = (this.xx - xm1) * dx + (this.yy - ym1) * dy;
        double xh = xm1 + h * dx;
        double yh = ym1 + h * dy;
        lg = Math.sqrt((this.xx - xh) * (this.xx - xh) + (this.yy - yh) * (this.yy - yh));
        dx = (this.xx - xh) / lg;
        dy = (this.yy - yh) / lg;
        double d10 = 10.0 / this.C.getPixel();
        try {
            xm1 = xh + d10 * dx;
            ym1 = yh + d10 * dy;
            zm1 = this.evaluateF(xm1, ym1);
            xm2 = xh - d10 * dx;
            ym2 = yh - d10 * dy;
            zm2 = this.evaluateF(xm2, ym2);
            if (zm1 * zm2 < 0.0) {
                this.findRootBetween(xm1, ym1, zm1, xm2, ym2, zm2);
                dd = Math.sqrt((P.getX() - this.xx) * (P.getX() - this.xx) + (P.getY() - this.yy) * (P.getY() - this.yy));
                return (int)Math.round(dd * this.Cn.getPixel());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void project(PointObject P) {
        Coordinates c2;
        this.xx = P.getX();
        this.yy = P.getY();
        double dm = 0.0;
        double xm1 = 0.0;
        double ym1 = 0.0;
        double zm1 = 0.0;
        double xm2 = 0.0;
        double ym2 = 0.0;
        double zm2 = 0.0;
        Enumeration e2 = this.V.elements();
        if (e2.hasMoreElements()) {
            c2 = (Coordinates)e2.nextElement();
            xm1 = c2.X;
            ym1 = c2.Y;
            xm2 = c2.X1;
            ym2 = c2.Y1;
            dm = Math.sqrt((c2.X - this.xx) * (c2.X - this.xx) + (c2.Y - this.yy) * (c2.Y - this.yy)) + Math.sqrt((c2.X1 - this.xx) * (c2.X1 - this.xx) + (c2.Y1 - this.yy) * (c2.Y1 - this.yy)) - Math.sqrt((c2.X - c2.X1) * (c2.X - c2.X1) + (c2.Y - c2.Y1) * (c2.Y - c2.Y1));
        } else {
            return;
        }
        while (e2.hasMoreElements()) {
            c2 = (Coordinates)e2.nextElement();
            double dd = Math.sqrt((c2.X - this.xx) * (c2.X - this.xx) + (c2.Y - this.yy) * (c2.Y - this.yy)) + Math.sqrt((c2.X1 - this.xx) * (c2.X1 - this.xx) + (c2.Y1 - this.yy) * (c2.Y1 - this.yy)) - Math.sqrt((c2.X - c2.X1) * (c2.X - c2.X1) + (c2.Y - c2.Y1) * (c2.Y - c2.Y1));
            if (!(dd < dm)) continue;
            xm1 = c2.X;
            ym1 = c2.Y;
            xm2 = c2.X1;
            ym2 = c2.Y1;
            dm = dd;
        }
        double lg = Math.sqrt((xm2 - xm1) * (xm2 - xm1) + (ym2 - ym1) * (ym2 - ym1));
        double dx = (xm2 - xm1) / lg;
        double dy = (ym2 - ym1) / lg;
        double h = (this.xx - xm1) * dx + (this.yy - ym1) * dy;
        double xh = xm1 + h * dx;
        double yh = ym1 + h * dy;
        lg = Math.sqrt((this.xx - xh) * (this.xx - xh) + (this.yy - yh) * (this.yy - yh));
        dx = (this.xx - xh) / lg;
        dy = (this.yy - yh) / lg;
        double d10 = 10.0 / this.C.getPixel();
        try {
            xm1 = xh + d10 * dx;
            ym1 = yh + d10 * dy;
            zm1 = this.evaluateF(xm1, ym1);
            xm2 = xh - d10 * dx;
            ym2 = yh - d10 * dy;
            zm2 = this.evaluateF(xm2, ym2);
            if (zm1 * zm2 < 0.0) {
                this.findRootBetween(xm1, ym1, zm1, xm2, ym2, zm2);
                P.move(this.xx, this.yy);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        P.move(xh, yh);
    }

    public void findRootBetween(double x1, double y1, double z1, double x2, double y2, double z2) {
        try {
            this.xx = (x1 + x2) / 2.0;
            this.yy = (y1 + y2) / 2.0;
            this.zz = this.evaluateF(this.xx, this.yy);
            if (Math.abs(this.zz) < 1.0E-10) {
                return;
            }
            if (this.zz * z1 < 0.0) {
                this.findRootBetween(x1, y1, z1, this.xx, this.yy, this.zz);
            } else {
                this.findRootBetween(this.xx, this.yy, this.zz, x2, y2, z2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void project(PointObject P, double alpha) {
        this.project(P);
    }

    @Override
    public boolean canInteresectWith(ConstructionObject o) {
        return false;
    }

    @Override
    public String getEY() {
        if (this.EY != null) {
            return this.EY.toString();
        }
        return "0";
    }

    @Override
    public String getDisplayValue() {
        return this.EY.toString();
    }

    @Override
    public String getTag() {
        return "EqXY";
    }

    @Override
    public void printArgs(XmlWriter xml) {
        xml.printArg("f", this.EY.toString());
        xml.printArg("Dhor", String.valueOf(this.Dhor));
    }

    @Override
    public void updateText() {
        this.setText(this.getDisplayValue() + "=0");
    }

    @Override
    public void repulse(PointObject P) {
        this.project(P);
    }
}

