/*
 * Decompiled with CFR 0.152.
 */
package carmetal.objects;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.objects.ConstructionObject;
import carmetal.objects.MoveableObject;
import carmetal.objects.PointObject;
import carmetal.objects.PrimitiveCircleObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlWriter;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import carmetal.rene.zirkel.expression.InvalidException;
import java.util.Enumeration;

public class CircleObject
extends PrimitiveCircleObject
implements MoveableObject {
    protected PointObject P2;
    boolean Fixed = false;
    Expression E;
    boolean ExpressionFailed;
    boolean Ellipse = false;
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;

    public CircleObject(Construction c2, PointObject p1, PointObject p2) {
        super(c2, p1);
        this.P2 = p2;
        this.validate();
        this.updateText();
    }

    @Override
    public String getTag() {
        return "Circle";
    }

    @Override
    public void updateText() {
        if (this.Fixed) {
            if (this.E == null) {
                this.setText(CircleObject.text3(Global.name("text.circle.fixed"), this.M.getName(), this.P2.getName(), "" + this.round(this.R)));
            } else {
                this.setText(CircleObject.text3(Global.name("text.circle.fixed"), this.M.getName(), this.P2.getName(), "\"" + this.E.toString() + "\""));
            }
        } else {
            this.setText(CircleObject.text2(Global.name("text.circle"), this.M.getName(), this.P2.getName()));
        }
    }

    @Override
    public void validate() {
        super.validate();
        this.ExpressionFailed = false;
        if (!this.M.valid() || !this.P2.valid()) {
            this.Valid = false;
            return;
        }
        this.Valid = true;
        this.X = this.M.getX();
        this.Y = this.M.getY();
        double X2 = this.P2.getX();
        double Y2 = this.P2.getY();
        double DX = X2 - this.X;
        double DY = Y2 - this.Y;
        this.R = Math.sqrt(DX * DX + DY * DY);
        if (this.Fixed) {
            if (!this.P2.moveableBy(this)) {
                this.Fixed = false;
            } else {
                try {
                    double FixR = this.E.getValue();
                    if (FixR < 0.0) {
                        FixR = 0.0;
                    }
                    if (this.R < 1.0E-10) {
                        this.P2.move(this.X + FixR, this.Y);
                    } else {
                        this.P2.move(this.X + DX * FixR / this.R, this.Y + DY * FixR / this.R);
                    }
                    this.R = FixR;
                    this.P2.movedBy(this);
                }
                catch (Exception e2) {
                    this.R = 0.0;
                    this.P2.move(this.X, this.Y);
                    this.ExpressionFailed = true;
                    this.Valid = false;
                }
            }
        }
    }

    @Override
    public void printArgs(XmlWriter xml) {
        xml.printArg("through", this.P2.getName());
        if (this.Fixed && this.E != null) {
            xml.printArg("fixed", this.E.toString());
        }
        super.printArgs(xml);
    }

    @Override
    public boolean canFix() {
        return this.P2.moveableBy(this);
    }

    @Override
    public boolean fixed() {
        return this.Fixed;
    }

    @Override
    public void setFixed(boolean flag, String s) throws ConstructionException {
        if (!flag || s.equals("")) {
            this.Fixed = false;
            this.E = null;
        } else {
            this.E = new Expression(s, this.getConstruction(), this);
            if (!this.E.isValid()) {
                throw new ConstructionException(this.E.getErrorText());
            }
            this.Fixed = true;
        }
        this.updateText();
    }

    @Override
    public boolean nearto(int c2, int r, ZirkelCanvas zc) {
        if (this.ExpressionFailed && this.M.valid()) {
            return this.M.nearto(c2, r, zc);
        }
        return super.nearto(c2, r, zc);
    }

    public boolean isValidFix() {
        return this.E != null && this.E.isValid();
    }

    @Override
    public void updateCircleDep() {
        this.addDep(this.P2);
    }

    @Override
    public void translate() {
        super.translate();
        this.P2 = (PointObject)this.P2.getTranslation();
        try {
            this.setFixed(this.Fixed, this.E.toString());
            this.E.translate();
        }
        catch (Exception e2) {
            this.Fixed = false;
        }
    }

    @Override
    public String getStringLength() {
        if (this.E != null) {
            return this.E.toString();
        }
        return "" + this.roundDisplay(this.R);
    }

    @Override
    public double getValue() throws ConstructionException {
        if (!this.Valid) {
            throw new InvalidException("exception.invalid");
        }
        return this.R;
    }

    @Override
    public Enumeration depending() {
        super.depending();
        if (!this.Fixed || this.E == null) {
            return this.depset(this.P2);
        }
        this.depset(this.P2);
        Enumeration e2 = this.E.getDepList().elements();
        while (e2.hasMoreElements()) {
            DL.add((ConstructionObject)e2.nextElement());
        }
        return DL.elements();
    }

    public void setP1P2(PointObject p1, PointObject p2) {
        this.M = p1;
        this.P2 = p2;
    }

    public PointObject getP2() {
        return this.P2;
    }

    @Override
    public boolean contains(PointObject p) {
        return p == this.P2;
    }

    @Override
    public void dragTo(double x, double y) {
        this.M.move(this.x1 + (x - this.x3), this.y1 + (y - this.y3));
        this.P2.move(this.x2 + (x - this.x3), this.y2 + (y - this.y3));
    }

    @Override
    public void move(double x, double y) {
    }

    @Override
    public boolean moveable() {
        return !this.Fixed && this.M.moveable() && this.P2.moveable();
    }

    @Override
    public void startDrag(double x, double y) {
        this.x1 = this.M.getX();
        this.y1 = this.M.getY();
        this.x2 = this.P2.getX();
        this.y2 = this.P2.getY();
        this.x3 = x;
        this.y3 = y;
    }

    @Override
    public double getOldX() {
        return 0.0;
    }

    @Override
    public double getOldY() {
        return 0.0;
    }

    @Override
    public void snap(ZirkelCanvas zc) {
        if (this.moveable()) {
            this.M.snap(zc);
            this.P2.snap(zc);
        }
    }
}

