/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.restrict;

import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.windowComponent;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.restrict.RestrictPanelIconsLineTitle;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;

public class RestrictPanelIcon
extends JCheckBox
implements MouseListener,
ItemListener {
    private Image image;
    private String name;
    private RestrictPanelIconsLineTitle title;
    private int W = 60;
    private int H = 32;
    private int MARGINW = 18;
    private static boolean select = false;

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = windowComponent.getGraphics2D(g);
        if (this.isEnabled()) {
            g2.drawImage(this.image, this.MARGINW, 0, this);
        } else {
            GrayFilter filter = new GrayFilter(true, 50);
            Image disImage = this.createImage(new FilteredImageSource(this.image.getSource(), filter));
            ImageIcon myicn = new ImageIcon(disImage);
            g2.drawImage(myicn.getImage(), this.MARGINW, 0, this);
        }
        super.paintComponent(g);
    }

    public RestrictPanelIcon(RestrictPanelIconsLineTitle ttle, String nme) {
        this.name = nme;
        this.title = ttle;
        PaletteManager.fixsize(this, this.W, this.H);
        this.image = themes.getPaletteImage(nme);
        this.putClientProperty("JComponent.sizeVariant", "mini");
        this.setFocusable(false);
        this.setOpaque(false);
        this.setVerticalAlignment(3);
        this.addMouseListener(this);
        this.addItemListener(this);
        this.initState();
    }

    public void initState() {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            this.setSelected(!zc.isHiddenItem(this.name));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (e2.getButton() == 3) {
            select = !this.isSelected();
            this.setSelected(select);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        if (e2.getButton() == 3) {
            this.setSelected(select);
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            if (this.isSelected()) {
                zc.removeHiddenItem(this.name);
                if (!this.title.isSelected()) {
                    this.title.setSelected(false, true);
                }
            } else {
                zc.addHiddenItem(this.name);
                this.title.uncheckIfAlone();
            }
        }
        PaletteManager.init();
    }
}

