/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.macros;

import carmetal.eric.FileTools;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.macros.CTree;
import carmetal.eric.macros.JDefaultMutableTreeNode;
import carmetal.eric.macros.JMacrosInspector;
import carmetal.eric.macros.MacroTools;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.macro.Macro;
import carmetal.rene.zirkel.macro.MacroItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.SeparatorUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class NodePopupMenu
extends JPopupMenu {
    private final CTree macrostree;
    private JDefaultMutableTreeNode SelectedNode;
    private TreePath[] SelectedPath;
    private JMenuItem runitem;
    private JMenuItem renitem;
    private JMenuItem delitem;
    private JMenuItem tolibitem;
    private JMenuItem tofileitem;
    private JMenuItem saveitem;
    private JMenuItem updtitem;
    private JMenuItem propitem;
    private JMenuItem dupitem;

    public NodePopupMenu(CTree mytree) {
        this.macrostree = mytree;
        this.dupitem = new JMenuItem(Global.Loc("macros.popup.duplicate"));
        this.dupitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodePopupMenu.this.duplicatenodes();
            }
        });
        this.propitem = new JMenuItem(Global.Loc("macros.popup.properties"));
        this.propitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodePopupMenu.this.showproperties();
            }
        });
        this.runitem = new JMenuItem(Global.Loc("macros.popup.run"));
        this.runitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
            }
        });
        this.renitem = new JMenuItem(Global.Loc("macros.popup.rename"));
        this.renitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodePopupMenu.this.renamenode();
            }
        });
        this.delitem = new JMenuItem(Global.Loc("macros.popup.delete"));
        this.delitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodePopupMenu.this.deletenodes();
            }
        });
        this.tolibitem = new JMenuItem(Global.Loc("macros.popup.addtolibrary"));
        this.tolibitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodePopupMenu.this.changeMacroType(0);
            }
        });
        this.tofileitem = new JMenuItem(Global.Loc("macros.popup.removefromlibrary"));
        this.tofileitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodePopupMenu.this.changeMacroType(2);
            }
        });
        this.saveitem = new JMenuItem(Global.Loc("macros.popup.saveas"));
        this.saveitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodePopupMenu.this.saveMacros();
            }
        });
    }

    public void handleMouseClick(MouseEvent e2) {
        TreePath path = this.macrostree.getPathForLocation(e2.getX(), e2.getY());
        if (path != null) {
            this.SelectedNode = (JDefaultMutableTreeNode)path.getLastPathComponent();
            this.SelectedPath = this.macrostree.getSelectionPaths();
            if (this.SelectedPath.length == 1 && this.SelectedNode.isLeaf()) {
                if (JMacrosInspector.isDialogVisible()) {
                    JMacrosInspector.changemacro(this.SelectedNode);
                } else {
                    PaletteManager.deselectgeomgroup();
                    this.SelectedNode.runZmacro();
                }
            }
        }
    }

    void actualiseproperties() {
    }

    private void showproperties() {
        JMacrosInspector.openInspector(this.SelectedNode);
    }

    public void handlePopup(MouseEvent e2) {
        TreePath path;
        if (e2.isPopupTrigger() && (path = this.macrostree.getPathForLocation(e2.getX(), e2.getY())) != null) {
            this.macrostree.addSelectionPath(path);
            this.SelectedNode = (JDefaultMutableTreeNode)path.getLastPathComponent();
            this.SelectedPath = this.macrostree.getSelectionPaths();
            this.removeAll();
            if (this.SelectedPath.length > 1) {
                this.add(this.delitem);
                if (!JZirkelCanvas.isRestrictedSession()) {
                    this.add(NodePopupMenu.createSeparator());
                    this.add(this.tolibitem);
                    this.add(this.tofileitem);
                    this.add(NodePopupMenu.createSeparator());
                    this.add(this.saveitem);
                }
            } else if (this.SelectedNode.isLeaf()) {
                this.add(this.renitem);
                if (!JZirkelCanvas.isRestrictedSession()) {
                    this.add(this.delitem);
                    this.add(this.dupitem);
                }
                this.add(NodePopupMenu.createSeparator());
                if (!JZirkelCanvas.isRestrictedSession()) {
                    this.add(this.tolibitem);
                    this.add(this.tofileitem);
                    this.add(NodePopupMenu.createSeparator());
                    this.add(this.saveitem);
                    this.add(NodePopupMenu.createSeparator());
                }
                this.add(this.runitem);
                this.add(NodePopupMenu.createSeparator());
                this.add(this.propitem);
            } else {
                this.add(this.renitem);
                this.add(this.delitem);
                this.add(NodePopupMenu.createSeparator());
                if (!JZirkelCanvas.isRestrictedSession()) {
                    this.add(this.tolibitem);
                    this.add(this.tofileitem);
                    this.add(NodePopupMenu.createSeparator());
                    this.add(this.saveitem);
                }
            }
            this.show(e2.getComponent(), e2.getX(), e2.getY());
        }
    }

    public void addfolder() {
        JDefaultMutableTreeNode node = new JDefaultMutableTreeNode(Global.Loc("macros.untitledfolder"));
        node.add(new JDefaultMutableTreeNode(Global.Loc("macros.emptynode")));
        TreePath[] paths = this.macrostree.getSelectionPaths();
        if (paths != null) {
            JDefaultMutableTreeNode root = (JDefaultMutableTreeNode)paths[0].getLastPathComponent();
            if (root.isLeaf()) {
                DefaultMutableTreeNode father = (DefaultMutableTreeNode)root.getParent();
                int i = father.getIndex(root) + 1;
                ((DefaultTreeModel)this.macrostree.getModel()).insertNodeInto(node, father, i);
            } else {
                ((DefaultTreeModel)this.macrostree.getModel()).insertNodeInto(node, root, root.getChildCount());
            }
        } else {
            ((DefaultTreeModel)this.macrostree.getModel()).insertNodeInto(node, this.macrostree.JML.getTopNode(), this.macrostree.JML.getTopNode().getChildCount());
        }
        TreePath tp = new TreePath(node.getPath());
        this.macrostree.setEditable(true);
        this.macrostree.startEditingAtPath(tp);
    }

    private void updateMacrosVector(JDefaultMutableTreeNode node) {
        if (node.m == null) {
            return;
        }
        String name = node.m.Name;
        if (node.m.isProtected()) {
            int ZCsSize = JZirkelCanvas.getZCsSize();
            for (int size = 0; size < ZCsSize; ++size) {
                Vector V = JZirkelCanvas.getZC(size).getMacros();
                for (int i = 0; i < V.size(); ++i) {
                    MacroItem mi = (MacroItem)V.get(i);
                    if (!name.equals(mi.M.Name)) continue;
                    V.remove(mi);
                }
            }
            Vector W = MacroTools.getLibraryMacros();
            for (int i = 0; i < W.size(); ++i) {
                MacroItem mi = (MacroItem)W.get(i);
                if (!name.equals(mi.M.Name)) continue;
                W.remove(mi);
            }
        } else {
            Vector V = JZirkelCanvas.getCurrentZC().getMacros();
            for (int i = 0; i < V.size(); ++i) {
                MacroItem mi = (MacroItem)V.get(i);
                if (!name.equals(mi.M.Name)) continue;
                V.remove(mi);
                return;
            }
        }
    }

    private void parse_deletenodes(JDefaultMutableTreeNode node) {
        if (!node.isLeaf()) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.parse_deletenodes((JDefaultMutableTreeNode)node.getChildAt(i));
            }
        } else {
            this.updateMacrosVector(node);
        }
    }

    public void deletenodes() {
        TreePath[] paths = this.macrostree.getSelectionPaths();
        if (paths != null) {
            Object[] options = new Object[]{"Ok", "Cancel"};
            int rep = JOptionPane.showOptionDialog(null, Global.Loc("macros.question.delete"), "Warning", -1, 2, null, options, options[0]);
            if (rep == 0) {
                for (TreePath path : paths) {
                    JDefaultMutableTreeNode node = (JDefaultMutableTreeNode)path.getLastPathComponent();
                    this.parse_deletenodes(node);
                    JDefaultMutableTreeNode father = (JDefaultMutableTreeNode)node.getParent();
                    ((DefaultTreeModel)this.macrostree.getModel()).removeNodeFromParent(node);
                    while (father.getChildCount() == 0) {
                        JDefaultMutableTreeNode grandfather = (JDefaultMutableTreeNode)father.getParent();
                        ((DefaultTreeModel)this.macrostree.getModel()).removeNodeFromParent(father);
                        father = grandfather;
                    }
                }
            }
        }
    }

    public static String uniqueMacroName(String base) {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc == null) {
            return base;
        }
        base = base.replaceAll("[\\s0-9]+$", "");
        Vector V = zc.getMacros();
        int num = 0;
        for (int i = 0; i < V.size(); ++i) {
            MacroItem mi = (MacroItem)V.get(i);
            if (!base.equals(mi.M.Name)) continue;
            base = base.replaceAll("[\\s0-9]+$", "") + " " + ++num;
        }
        return base;
    }

    public void duplicatenodes() {
        try {
            ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
            MacroItem mi = new MacroItem((Macro)this.SelectedNode.m.clone(), null);
            String[] mytab = mi.M.Name.split("/");
            mi.M.setName(NodePopupMenu.uniqueMacroName(mytab[mytab.length - 1]));
            Vector<MacroItem> ZFMacros = new Vector<MacroItem>();
            ZFMacros.add(mi);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            zc.save(out, false, true, true, false, ZFMacros, "");
            zc.load(new ByteArrayInputStream(out.toByteArray()), false, true);
            JZirkelCanvas.ActualiseMacroPanel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void renamenode() {
        TreePath[] paths = this.macrostree.getSelectionPaths();
        if (paths != null) {
            this.macrostree.setEditable(true);
            this.macrostree.startEditingAtPath(paths[0]);
        }
    }

    private void changeMacroType(int newtype) {
        for (TreePath element : this.SelectedPath) {
            this.SelectedNode = (JDefaultMutableTreeNode)element.getLastPathComponent();
            this.parse_changeMacroType(this.SelectedNode, newtype);
        }
        this.macrostree.repaint();
        MacroTools.updateLibraryMacros();
        MacroTools.populateMacrosTypeChanges();
    }

    private void parse_changeMacroType(JDefaultMutableTreeNode node, int newtype) {
        if (node.isLeaf()) {
            node.setType(newtype);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.parse_changeMacroType((JDefaultMutableTreeNode)node.getChildAt(i), newtype);
            }
        }
    }

    private void saveMacros() {
        Vector ZFMacros = new Vector();
        for (TreePath element : this.SelectedPath) {
            this.SelectedNode = (JDefaultMutableTreeNode)element.getLastPathComponent();
            this.parse_saveMacros(this.SelectedNode, ZFMacros);
        }
        String filename = FileTools.getSaveFile();
        if (filename != null) {
            String ext = filename.endsWith(".mcr") ? "" : ".mcr";
            JZirkelCanvas.getCurrentZF().dosave(filename + ext, false, true, true, false, ZFMacros);
        }
    }

    private void parse_saveMacros(JDefaultMutableTreeNode node, Vector ZFMacros) {
        if (node.isLeaf()) {
            MacroItem mi = new MacroItem(node.m, null);
            ZFMacros.add(mi);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.parse_saveMacros((JDefaultMutableTreeNode)node.getChildAt(i), ZFMacros);
            }
        }
    }

    private static final JSeparator createSeparator() {
        JSeparator jsep = new JSeparator(0);
        Dimension d2 = new Dimension(200, 12);
        jsep.setMaximumSize(d2);
        jsep.setMinimumSize(d2);
        jsep.setPreferredSize(d2);
        jsep.setSize(d2);
        jsep.setUI(new MiddleSeparatorUI());
        return jsep;
    }

    private static final class MiddleSeparatorUI
    extends SeparatorUI {
        private MiddleSeparatorUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c2) {
            Dimension s = c2.getSize();
            int middleHeight = (s.height - 1) / 2;
            g.setColor(Color.lightGray);
            g.drawLine(0, middleHeight, s.width, middleHeight);
            g.setColor(Color.white);
            g.drawLine(0, middleHeight + 1, s.width, middleHeight + 1);
        }
    }
}

