/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.macros;

import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.macros.DialogTitleBar;
import carmetal.eric.macros.JDefaultMutableTreeNode;
import carmetal.eric.macros.JMacrosProperties;
import carmetal.eric.macros.TopDialog;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.macro.Macro;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JMacrosInspector
extends JDialog
implements MouseListener,
MouseMotionListener,
TopDialog {
    private static Macro M = null;
    private int PW = 310;
    private int PH = 395;
    private static JDefaultMutableTreeNode node;
    private IContent content;
    private MouseEvent pressed;
    private Point location;
    private static JMacrosInspector me;

    public JMacrosInspector(JDefaultMutableTreeNode mymacro) {
        this.setFocusableWindowState(true);
        this.setFocusable(false);
        this.setSize(this.PW, this.PH);
        this.setUndecorated(true);
        if (!pipe_tools.isApplet()) {
            this.setAlwaysOnTop(true);
        } else {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent e2) {
                    JMacrosInspector.this.toFront();
                }
            });
        }
        this.content = new IContent(this);
        this.setContentPane(this.content);
        DialogTitleBar title = new DialogTitleBar(this, this.PW);
        this.content.add((Component)title, 0);
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            Point p = zc.getLocationOnScreen();
            this.setLocation(p.x + 10, p.y + (zc.getSize().height - this.PH) / 2);
        }
        this.setVisible(true);
    }

    public static boolean isDialogVisible() {
        return me != null;
    }

    public static void openInspector(JDefaultMutableTreeNode mymacro) {
        if (me == null) {
            me = new JMacrosInspector(mymacro);
        }
        JMacrosInspector.changemacro(mymacro);
    }

    public static void changemacro(JDefaultMutableTreeNode mymacro) {
        if (me != null) {
            me.setMacro(mymacro);
        }
    }

    public void setStandardLocation() {
    }

    public void clearPalette() {
        if (M != null) {
            this.content.changemacro();
        }
        node = null;
        M = null;
        this.content.clearfields();
    }

    public void setMacro(JDefaultMutableTreeNode mynode) {
        node = mynode;
        M = JMacrosInspector.node.m;
        this.content.fillfields();
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.pressed = me;
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        this.location = this.getLocation(this.location);
        int x = this.location.x - this.pressed.getX() + me.getX();
        int y = this.location.y - this.pressed.getY() + me.getY();
        this.setLocation(x, y);
        Toolkit.getDefaultToolkit().sync();
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    public static void quit() {
        if (me != null) {
            me.exit();
        }
    }

    @Override
    public void exit() {
        this.content.changemacro();
        node = null;
        me = null;
        this.dispose();
    }

    public void fixObject(int i, boolean b2) {
        this.content.fixObject(i, b2);
    }

    public void askObject(int i, boolean b2) {
        this.content.askObject(i, b2);
    }

    public class IContent
    extends JPanel {
        JMacrosInspector JMI;
        JLabel name;
        JTextArea comment;
        JMacrosProperties props;
        JCheckBox hideDuplicates;

        private JPanel margin(int w) {
            JPanel mypan = new JPanel();
            this.fixsize(mypan, w, 1);
            mypan.setOpaque(false);
            return mypan;
        }

        public IContent(JMacrosInspector jmi) {
            this.JMI = jmi;
            this.setLayout(new BoxLayout(this, 1));
            this.setFocusable(false);
            this.name = new JLabel();
            this.comment = new JTextArea();
            this.props = new JMacrosProperties(this.JMI);
            this.hideDuplicates = new JCheckBox(Global.Loc("mi.hideduplicates"));
            this.newnameline();
            this.add(new mySep(1));
            this.newcommentline();
            this.add(new mySep(1));
            this.newproperties();
            this.add(new mySep(1));
            this.newhideproperties();
            this.add(new mySep(1));
            this.newcontrolline();
            this.fixsize(this, JMacrosInspector.this.PW, JMacrosInspector.this.PH);
        }

        private void fixsize(JComponent cp, int w, int h) {
            Dimension d2 = new Dimension(w, h);
            cp.setMaximumSize(d2);
            cp.setMinimumSize(d2);
            cp.setPreferredSize(d2);
            cp.setSize(d2);
        }

        public void newnameline() {
            myRub rub = new myRub();
            ContentLine myline1 = new ContentLine(25);
            this.fixsize(this.name, JMacrosInspector.this.PW - 10, 18);
            myline1.add(this.margin(5));
            myline1.add(this.name);
            rub.add(myline1);
            this.add(rub);
        }

        public void newcommentline() {
            myRub rub = new myRub();
            JScrollPane jScroll = new JScrollPane();
            ContentLine myline1 = new ContentLine(22);
            JLabel namelabel = new JLabel(Global.Loc("mi.comment"));
            this.fixsize(namelabel, JMacrosInspector.this.PW - 10, 14);
            myline1.add(this.margin(5));
            myline1.add(namelabel);
            ContentLine myline2 = new ContentLine(100);
            this.comment.setLineWrap(true);
            jScroll.setViewportView(this.comment);
            jScroll.setHorizontalScrollBarPolicy(31);
            this.fixsize(jScroll, JMacrosInspector.this.PW - 10, 80);
            myline2.add(this.margin(5));
            myline2.add(jScroll);
            rub.add(myline1);
            rub.add(myline2);
            this.add(rub);
        }

        public void newhideproperties() {
            myRub rub = new myRub();
            rub.setLayout(new BoxLayout(rub, 1));
            ContentLine myline1 = new ContentLine(22);
            JLabel namelabel = new JLabel(Global.Loc("mi.hideproperties"));
            this.fixsize(namelabel, JMacrosInspector.this.PW - 10, 14);
            myline1.add(this.margin(5));
            myline1.add(namelabel);
            ContentLine mylineC3 = new ContentLine(27);
            this.hideDuplicates.setOpaque(false);
            mylineC3.add(this.margin(20));
            mylineC3.add(this.hideDuplicates);
            rub.add(myline1);
            rub.add(mylineC3);
            this.add(rub);
        }

        public void newcontrolline() {
            myRub rub = new myRub();
            ContentLine myline = new ContentLine(25);
            JButton applybtn = new JButton("Apply");
            applybtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e2) {
                    IContent.this.changemacro();
                    IContent.this.fillfields();
                }
            });
            this.fixsize(applybtn, 90, 18);
            applybtn.setFont(new Font("System", 1, 11));
            JPanel sep = new JPanel();
            sep.setOpaque(false);
            myline.add(sep);
            myline.add(applybtn);
            myline.add(this.margin(5));
            rub.add(myline);
            this.add(rub);
        }

        public void newproperties() {
            myRub rub = new myRub();
            ContentLine myline1 = new ContentLine(22);
            JLabel namelabel = new JLabel(Global.Loc("mi.properties"));
            myline1.add(this.margin(5));
            myline1.add(namelabel);
            this.fixsize(namelabel, JMacrosInspector.this.PW - 10, 14);
            ContentLine myline2 = new ContentLine(130);
            this.fixsize(this.props, JMacrosInspector.this.PW - 10, 100);
            myline2.add(this.margin(5));
            myline2.add(this.props);
            rub.add(myline1);
            rub.add(myline2);
            this.add(rub);
        }

        public void changemacro() {
            int i;
            Vector<ConstructionObject> newparams = new Vector<ConstructionObject>();
            Vector<String> newprompts = new Vector<String>();
            Vector<String> newpromptFor = new Vector<String>();
            Vector<String> newpromptName = new Vector<String>();
            this.props.stopCellEditing();
            if (M == null) {
                return;
            }
            if (this.isError()) {
                return;
            }
            M.setComment(this.comment.getText());
            ConstructionObject[] params = M.getParams();
            for (int i2 = 0; i2 < params.length; ++i2) {
                params[i2].setName(this.props.getOName(i2));
                if (this.props.getOAsk(i2)) {
                    newpromptFor.add(this.props.getOName(i2));
                    newpromptName.add(this.props.getOPrompt(i2));
                    params[i2].setHidden(true);
                    params[i2].clearParameter();
                    continue;
                }
                newparams.add(params[i2]);
                if (this.props.getOFix(i2)) {
                    newprompts.add("=" + this.props.getOName(i2));
                    continue;
                }
                newprompts.add(this.props.getOPrompt(i2));
            }
            int rang = 0;
            for (int i3 = params.length; i3 < this.props.getRowCount(); ++i3) {
                ConstructionObject E = null;
                for (int j = 0; j < M.V.size(); ++j) {
                    if (!((ConstructionObject)M.V.get(j)).getName().equals(M.PromptFor[i3 - params.length])) continue;
                    E = (ConstructionObject)M.V.get(j);
                    break;
                }
                E.setName(this.props.getOName(i3));
                if (this.props.getOAsk(i3)) {
                    newpromptFor.add(this.props.getOName(i3));
                    newpromptName.add(this.props.getOPrompt(i3));
                    continue;
                }
                newparams.add(rang, E);
                if (this.props.getOFix(i3)) {
                    newprompts.add(rang, "=" + this.props.getOName(i3));
                } else {
                    newprompts.add(rang, this.props.getOPrompt(i3));
                }
                ++rang;
            }
            int ln = newparams.size();
            M.Params = new ConstructionObject[ln];
            M.Prompts = new String[ln];
            M.LastParams = new String[ln];
            for (i = 0; i < ln; ++i) {
                M.Params[i] = (ConstructionObject)newparams.get(i);
                M.Prompts[i] = (String)newprompts.get(i);
                M.LastParams[i] = null;
                M.Params[i].setHidden(false);
                M.Params[i].setMainParameter(true);
                M.Params[i].setParameter(true);
            }
            ln = newpromptFor.size();
            M.PromptFor = new String[ln];
            M.PromptName = new String[ln];
            for (i = 0; i < ln; ++i) {
                M.PromptFor[i] = (String)newpromptFor.get(i);
                M.PromptName[i] = (String)newpromptName.get(i);
            }
            M.hideDuplicates(this.hideDuplicates.isSelected());
        }

        public void fixObject(int i, boolean fix) {
            String newprompt = fix ? "" : this.props.getOName(i);
            this.props.setOPrompt(newprompt, i);
            if (fix) {
                this.props.setOAsk(false, i);
            }
        }

        public void askObject(int i, boolean ask) {
            if (ask && this.props.getOFix(i)) {
                this.props.setOFix(false, i);
                this.fixObject(i, false);
            }
        }

        public void clearfields() {
            this.name.setText(Global.Loc("mi.name"));
            this.comment.setText("");
            this.props.removeAllRows();
            this.hideDuplicates.setSelected(false);
        }

        public boolean isError() {
            boolean isErr = false;
            int ln = this.props.getRowCount();
            boolean err = true;
            for (int i = 0; i < ln; ++i) {
                err = err && (this.props.getOFix(i) || this.props.getOAsk(i));
            }
            if (err) {
                JOptionPane.showMessageDialog(null, Global.Loc("mi.error.initial"));
                return true;
            }
            return false;
        }

        public void fillfields() {
            String tpe;
            int i;
            if (M == null) {
                return;
            }
            this.name.setText(Global.Loc("mi.name") + " " + (String)node.getUserObject());
            this.comment.setText(M.Comment);
            this.props.removeAllRows();
            ConstructionObject[] params = M.getParams();
            System.out.println("PARAMS=" + params.length);
            String[] prompts = M.getPrompts();
            String pr = "";
            for (i = 0; i < params.length; ++i) {
                boolean withask;
                pr = "=" + params[i].getName();
                tpe = "";
                String[] classtpes = params[i].getClass().getName().split("\\.");
                try {
                    tpe = Global.Loc(params[i].getClass().getName());
                }
                catch (Exception e2) {
                    tpe = classtpes[classtpes.length - 1];
                }
                if (tpe == null) {
                    tpe = classtpes[classtpes.length - 1];
                }
                if (withask = params[i].getClass().getName().endsWith("ExpressionObject")) {
                    this.props.addRow(tpe, params[i].getName(), prompts[i], prompts[i].equals(pr), false);
                    continue;
                }
                this.props.addRow(tpe, params[i].getName(), prompts[i], prompts[i].equals(pr));
            }
            for (i = 0; i < M.PromptFor.length; ++i) {
                tpe = Global.Loc("carmetal.objects.ExpressionObject");
                this.props.addRow(tpe, M.PromptFor[i], M.PromptName[i], false, true);
            }
            this.hideDuplicates.setSelected(M.hideDuplicates());
        }

        class mySep
        extends JPanel {
            public mySep(int height) {
                this.setLayout(new BoxLayout(this, 0));
                this.setAlignmentX(0.0f);
                this.setMaximumSize(new Dimension(JMacrosInspector.this.PW, height));
                this.setMinimumSize(new Dimension(JMacrosInspector.this.PW, height));
                this.setPreferredSize(new Dimension(JMacrosInspector.this.PW, height));
                this.setSize(JMacrosInspector.this.PW, height);
                this.setBackground(new Color(200, 200, 200));
            }
        }

        class ContentLine
        extends JPanel {
            public ContentLine(int height) {
                this.setLayout(new BoxLayout(this, 0));
                this.setAlignmentX(0.0f);
                this.setMaximumSize(new Dimension(JMacrosInspector.this.PW, height));
                this.setMinimumSize(new Dimension(JMacrosInspector.this.PW, height));
                this.setPreferredSize(new Dimension(JMacrosInspector.this.PW, height));
                this.setSize(JMacrosInspector.this.PW, height);
                this.setOpaque(false);
            }
        }

        class myRub
        extends JPanel {
            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Dimension d2 = this.getSize();
                g.drawImage(themes.getImage("palbackground2.gif"), 0, 0, d2.width, d2.height, this);
            }

            public myRub() {
                this.setLayout(new BoxLayout(this, 1));
                this.setAlignmentX(0.0f);
            }
        }
    }
}

