/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.macros;

import carmetal.construction.ConstructionException;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.macros.CreateMacroDialog;
import carmetal.eric.macros.JDefaultMutableTreeNode;
import carmetal.eric.macros.MacrosList;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.ZirkelFrame;
import carmetal.rene.zirkel.macro.Macro;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class CreateMacroPanel
extends JPanel {
    private JButton nextbtn;
    private static int stepnum;
    private boolean visible = false;
    private static stepcomments steps;
    private static MacrosList ML;
    private static CreateMacroDialog CMD;
    private static CreateMacroPanel CMP;

    public CreateMacroPanel(CreateMacroDialog md, MacrosList ml, int w, int h) {
        CMP = this;
        ML = ml;
        CMD = md;
        ZirkelFrame zf = JZirkelCanvas.getCurrentZF();
        if (zf != null) {
            this.setLayout(new BoxLayout(this, 0));
            this.setAlignmentX(0.0f);
            this.setOpaque(false);
            this.setFocusable(false);
            stepnum = 1;
            zf.settool(28);
            this.visible = true;
            PaletteManager.fixsize(this, w, h);
            steps = new stepcomments();
            this.nextbtn = new JButton(themes.getIcon("Mnext.png"));
            this.nextbtn.setOpaque(false);
            this.nextbtn.setContentAreaFilled(false);
            this.nextbtn.setEnabled(true);
            this.nextbtn.setBorder(BorderFactory.createEmptyBorder());
            this.nextbtn.setAlignmentY(0.5f);
            this.nextbtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e2) {
                    CreateMacroPanel.nextStep();
                }
            });
            this.add(CreateMacroPanel.margin(10));
            this.add(steps);
            this.add(CreateMacroPanel.margin(10));
            this.add(this.nextbtn);
            ML.validate();
            ML.repaint();
        }
    }

    public static void nextStep() {
        ZirkelFrame zf = JZirkelCanvas.getCurrentZF();
        if (zf == null) {
            return;
        }
        if (zf.ZC.getConstruction().Parameters.size() > 0) {
            switch (stepnum) {
                case 1: {
                    steps.mycomment.setText("2/3 - " + Global.Loc("macros.finals"));
                    steps.myparams.setText("");
                    zf.settool(29);
                    break;
                }
                case 2: {
                    steps.mycomment.setText("3/3 - " + Global.Loc("macros.name"));
                    steps.myparams.setEditable(true);
                    steps.myparams.setFocusable(true);
                    steps.myparams.setHorizontalAlignment(0);
                    steps.myparams.setText(Global.Loc("macros.untitledmacro"));
                    steps.myparams.selectAll();
                    steps.myparams.requestFocus();
                    pipe_tools.removeMacroPanelKeyInputs();
                    break;
                }
                case 3: {
                    CreateMacroPanel.valid();
                }
            }
            ++stepnum;
        } else {
            zf.settool(28);
            CreateMacroPanel.setParametersComments();
        }
    }

    public static void setParametersComments() {
        ZirkelCanvas zc;
        if (CMD != null && (zc = JZirkelCanvas.getCurrentZC()) != null) {
            String p = "";
            Vector v = zc.getConstruction().getParameters();
            for (int i = 0; i < v.size(); ++i) {
                ConstructionObject o = (ConstructionObject)v.get(i);
                p = p + "," + o.getName();
            }
            if (p.startsWith(",")) {
                p = p.substring(1);
            }
            if (p.equals("")) {
                steps.myparams.setHorizontalAlignment(0);
                p = Global.Loc("macros.pleaseselect");
            } else {
                steps.myparams.setHorizontalAlignment(4);
            }
            steps.myparams.setText(p);
        }
    }

    public static void setTargetsComments() {
        ZirkelCanvas zc;
        if (CMD != null && (zc = JZirkelCanvas.getCurrentZC()) != null) {
            String p = "";
            Vector v = zc.getConstruction().getTargets();
            for (int i = 0; i < v.size(); ++i) {
                ConstructionObject o = (ConstructionObject)v.get(i);
                p = p + "," + o.getName();
            }
            if (p.startsWith(",")) {
                p = p.substring(1);
            }
            steps.myparams.setHorizontalAlignment(4);
            steps.myparams.setText(p);
        }
    }

    static JPanel margin(int w) {
        JPanel mypan = new JPanel();
        PaletteManager.fixsize(mypan, w, 1);
        mypan.setLayout(new BoxLayout(mypan, 0));
        mypan.setAlignmentX(0.0f);
        mypan.setAlignmentY(0.0f);
        mypan.setOpaque(false);
        mypan.setFocusable(false);
        return mypan;
    }

    public JLabel getComment() {
        return steps.getComment();
    }

    public static void valid() {
        TreePath tp = CreateMacroPanel.createmacro();
        pipe_tools.actualiseLeftPanels();
        PaletteManager.selectGeomIcon();
        CreateMacroDialog.quit();
    }

    public static TreePath createmacro() {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc == null) {
            return null;
        }
        Vector V = zc.getConstruction().Parameters;
        String[] s = new String[V.size()];
        for (int i = 0; i < V.size(); ++i) {
            ConstructionObject o = (ConstructionObject)V.elementAt(i);
            s[i] = o.getName();
        }
        String txt = steps.myparams.getText();
        if (txt.equals("")) {
            txt = Global.Loc("macros.untitledmacro");
        }
        Macro m = new Macro(zc, txt, "", s);
        try {
            zc.defineMacro(zc.getConstruction(), m, zc.getConstruction().countTargets() > 0, true, s, false);
        }
        catch (ConstructionException constructionException) {
            // empty catch block
        }
        m.hideDuplicates(false);
        zc.storeMacro(m, false);
        JDefaultMutableTreeNode node = new JDefaultMutableTreeNode(JZirkelCanvas.getCurrentZF(), m);
        TreePath[] paths = ML.getMacrosTree().getSelectionPaths();
        if (paths != null && paths.length > 0) {
            JDefaultMutableTreeNode root = (JDefaultMutableTreeNode)paths[0].getLastPathComponent();
            if (root.isLeaf()) {
                DefaultMutableTreeNode father = (DefaultMutableTreeNode)root.getParent();
                int i = father.getIndex(root) + 1;
                ((DefaultTreeModel)ML.getMacrosTree().getModel()).insertNodeInto(node, father, i);
            } else {
                ((DefaultTreeModel)ML.getMacrosTree().getModel()).insertNodeInto(node, root, root.getChildCount());
            }
        } else {
            ((DefaultTreeModel)ML.getMacrosTree().getModel()).insertNodeInto(node, ML.getTopNode(), ML.getTopNode().getChildCount());
        }
        TreePath tp = new TreePath(node.getPath());
        node.ActualisePath();
        return tp;
    }

    private class stepcomments
    extends JPanel {
        private JLabel mycomment = new JLabel();
        private JTextField myparams = new JTextField();

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension d2 = this.getSize();
            g.drawImage(themes.getImage("Mcomments.png"), 0, 0, d2.width, d2.height, this);
        }

        public JLabel getComment() {
            return this.mycomment;
        }

        private stepcomments() {
            this.setLayout(new BoxLayout(this, 1));
            this.setAlignmentY(0.5f);
            ImageIcon backIcon = themes.getIcon("Mcomments.png");
            PaletteManager.fixsize(this, backIcon.getIconWidth(), backIcon.getIconHeight());
            this.setOpaque(false);
            this.mycomment.setText("1/3 - " + Global.Loc("macros.initials"));
            this.mycomment.setFont(new Font("Verdana", 0, 10));
            PaletteManager.fixsize(this.mycomment, backIcon.getIconWidth(), backIcon.getIconHeight() / 2);
            this.mycomment.setHorizontalAlignment(0);
            this.mycomment.setVerticalAlignment(0);
            this.mycomment.setAlignmentX(0.5f);
            this.mycomment.setAlignmentY(0.5f);
            this.add(this.mycomment);
            this.myparams.setText(Global.Loc("macros.pleaseselect"));
            this.myparams.setFont(new Font("Verdana", 0, 10));
            this.myparams.setForeground(Color.blue);
            this.myparams.setOpaque(false);
            this.myparams.setBorder(null);
            this.myparams.setFocusable(false);
            PaletteManager.fixsize(this.myparams, backIcon.getIconWidth() - 10, backIcon.getIconHeight() / 2);
            this.myparams.setHorizontalAlignment(0);
            this.myparams.setAlignmentX(0.5f);
            this.myparams.setAlignmentY(0.5f);
            this.myparams.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e2) {
                    if (e2.getKeyCode() == 10) {
                        CreateMacroPanel.valid();
                    }
                }
            });
            this.add(this.myparams);
        }
    }
}

