/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.macros;

import carmetal.eric.macros.CTransferableTreePath;
import carmetal.eric.macros.MacrosList;
import carmetal.eric.macros.NodePopupMenu;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class CTree
extends JTree
implements DragSourceListener,
DragGestureListener,
Autoscroll,
TreeSelectionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private TreePath _pathSource;
    private BufferedImage _imgGhost;
    private final Point _ptOffset = new Point();
    private boolean dropped = false;
    public MacrosList JML;
    public NodePopupMenu nodepopup;
    private static final int AUTOSCROLL_MARGIN = 12;

    public CTree(MacrosList jml) {
        this.JML = jml;
        this.putClientProperty("JTree.lineStyle", "none");
        this.addMouseListener(this);
        DragSource dragSource = DragSource.getDefaultDragSource();
        dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        DropTarget dropTarget = new DropTarget(this, new CDropTargetListener());
        dropTarget.setDefaultActions(3);
        this.nodepopup = new NodePopupMenu(this);
    }

    private DefaultMutableTreeNode cloneAll(DefaultMutableTreeNode Ndfrom) {
        DefaultMutableTreeNode Ndto = (DefaultMutableTreeNode)Ndfrom.clone();
        if (!Ndfrom.isLeaf()) {
            for (int i = 0; i < Ndfrom.getChildCount(); ++i) {
                DefaultMutableTreeNode mynode = this.cloneAll((DefaultMutableTreeNode)Ndfrom.getChildAt(i));
                Ndto.add(mynode);
            }
        }
        return Ndto;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e2) {
        Point ptDragOrigin = e2.getDragOrigin();
        TreePath path = this.getPathForLocation(ptDragOrigin.x, ptDragOrigin.y);
        if (path == null) {
            return;
        }
        if (this.isRootPath(path)) {
            return;
        }
        Rectangle raPath = this.getPathBounds(path);
        this._ptOffset.setLocation(ptDragOrigin.x - raPath.x, ptDragOrigin.y - raPath.y);
        JLabel lbl = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, path.getLastPathComponent(), false, this.isExpanded(path), this.getModel().isLeaf(path.getLastPathComponent()), 0, false);
        lbl.setSize((int)raPath.getWidth(), (int)raPath.getHeight());
        this._imgGhost = new BufferedImage((int)raPath.getWidth(), (int)raPath.getHeight(), 3);
        Graphics2D g2 = this._imgGhost.createGraphics();
        g2.setComposite(AlphaComposite.getInstance(2, 0.5f));
        lbl.paint(g2);
        Icon icon = lbl.getIcon();
        int nStartOfText = icon == null ? 0 : icon.getIconWidth() + lbl.getIconTextGap();
        g2.setComposite(AlphaComposite.getInstance(4, 0.5f));
        g2.setPaint(new GradientPaint(nStartOfText, 0.0f, SystemColor.controlShadow, this.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
        g2.fillRect(nStartOfText, 0, this.getWidth(), this._imgGhost.getHeight());
        g2.dispose();
        this.setSelectionPath(path);
        CTransferableTreePath transferable = new CTransferableTreePath(path);
        this._pathSource = path;
        try {
            this.setEditable(false);
            e2.startDrag(null, this._imgGhost, new Point(5, 5), transferable, this);
        }
        catch (InvalidDnDOperationException invalidDnDOperationException) {
            // empty catch block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent e2) {
    }

    @Override
    public void dragOver(DragSourceDragEvent e2) {
    }

    @Override
    public void dragExit(DragSourceEvent e2) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e2) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e2) {
        int nAction;
        if (e2.getDropSuccess() && (nAction = e2.getDropAction()) == 2) {
            if (this.dropped) {
                DefaultTreeModel model = (DefaultTreeModel)this.getModel();
                MutableTreeNode node = (MutableTreeNode)this._pathSource.getLastPathComponent();
                MutableTreeNode parent = (MutableTreeNode)node.getParent();
                model.removeNodeFromParent(node);
                while (parent.isLeaf()) {
                    MutableTreeNode grandparent = (MutableTreeNode)parent.getParent();
                    model.removeNodeFromParent(parent);
                    parent = grandparent;
                }
                this.dropped = false;
            }
            this._pathSource = null;
        }
    }

    @Override
    public void autoscroll(Point pt) {
        int nRow = this.getRowForLocation(pt.x, pt.y);
        if (nRow < 0) {
            return;
        }
        Rectangle raOuter = this.getBounds();
        nRow = pt.y + raOuter.y <= 12 ? (nRow <= 0 ? 0 : nRow - 1) : (nRow < this.getRowCount() - 1 ? nRow + 1 : nRow);
        this.scrollRowToVisible(nRow);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle raOuter = this.getBounds();
        Rectangle raInner = this.getParent().getBounds();
        return new Insets(raInner.y - raOuter.y + 12, raInner.x - raOuter.x + 12, raOuter.height - raInner.height - raInner.y + raOuter.y + 12, raOuter.width - raInner.width - raInner.x + raOuter.x + 12);
    }

    private boolean isRootPath(TreePath path) {
        return this.isRootVisible() && this.getRowForPath(path) == 0;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e2) {
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
        this.nodepopup.handleMouseClick(e2);
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.nodepopup.actualiseproperties();
        this.nodepopup.handlePopup(e2);
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        this.nodepopup.handlePopup(e2);
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    class CDropTargetListener
    implements DropTargetListener {
        private TreePath _pathLast = null;
        private final Rectangle2D _raCueLine = new Rectangle2D.Float();
        private Rectangle2D _raGhost = new Rectangle2D.Float();
        private final Color _colorCueLine;
        private Point _ptLast = new Point();
        private final Timer _timerHover;
        private int _nLeftRight = 0;

        public CDropTargetListener() {
            this._colorCueLine = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 64);
            this._timerHover = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e2) {
                    CDropTargetListener.this._nLeftRight = 0;
                    if (CTree.this.isRootPath(CDropTargetListener.this._pathLast)) {
                        return;
                    }
                    if (CTree.this.isExpanded(CDropTargetListener.this._pathLast)) {
                        CTree.this.collapsePath(CDropTargetListener.this._pathLast);
                    } else {
                        CTree.this.expandPath(CDropTargetListener.this._pathLast);
                    }
                }
            });
            this._timerHover.setRepeats(false);
        }

        @Override
        public void dragEnter(DropTargetDragEvent e2) {
            if (!this.isDragAcceptable(e2)) {
                e2.rejectDrag();
            } else {
                e2.acceptDrag(e2.getDropAction());
            }
        }

        @Override
        public void dragExit(DropTargetEvent e2) {
            if (!DragSource.isDragImageSupported()) {
                CTree.this.repaint(this._raGhost.getBounds());
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent e2) {
            Point pt = e2.getLocation();
            if (pt.equals(this._ptLast)) {
                return;
            }
            int nDeltaLeftRight = pt.x - this._ptLast.x;
            if (this._nLeftRight > 0 && nDeltaLeftRight < 0 || this._nLeftRight < 0 && nDeltaLeftRight > 0) {
                this._nLeftRight = 0;
            }
            this._nLeftRight += nDeltaLeftRight;
            this._ptLast = pt;
            Graphics2D g2 = (Graphics2D)CTree.this.getGraphics();
            if (!DragSource.isDragImageSupported()) {
                CTree.this.paintImmediately(this._raGhost.getBounds());
                this._raGhost.setRect(pt.x - ((CTree)CTree.this)._ptOffset.x, pt.y - ((CTree)CTree.this)._ptOffset.y, CTree.this._imgGhost.getWidth(), CTree.this._imgGhost.getHeight());
                g2.drawImage(CTree.this._imgGhost, AffineTransform.getTranslateInstance(this._raGhost.getX(), this._raGhost.getY()), null);
            } else {
                CTree.this.paintImmediately(this._raCueLine.getBounds());
            }
            TreePath path = CTree.this.getClosestPathForLocation(pt.x, pt.y);
            if (path != this._pathLast) {
                this._nLeftRight = 0;
                this._pathLast = path;
                this._timerHover.restart();
            }
            Rectangle raPath = CTree.this.getPathBounds(path);
            this._raCueLine.setRect(0.0, raPath.y + (int)raPath.getHeight(), CTree.this.getWidth(), 2.0);
            g2.setColor(this._colorCueLine);
            g2.fill(this._raCueLine);
            if (this._nLeftRight > 20 || this._nLeftRight < -20) {
                // empty if block
            }
            this._raGhost = this._raGhost.createUnion(this._raCueLine);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e2) {
            if (!this.isDragAcceptable(e2)) {
                e2.rejectDrag();
            } else {
                e2.acceptDrag(e2.getDropAction());
            }
        }

        @Override
        public void drop(DropTargetDropEvent e2) {
            DataFlavor[] flavors;
            this._timerHover.stop();
            if (!this.isDropAcceptable(e2)) {
                e2.rejectDrop();
                return;
            }
            e2.acceptDrop(e2.getDropAction());
            Transferable transferable = e2.getTransferable();
            for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                if (!flavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    Point pt = e2.getLocation();
                    TreePath pathTarget = CTree.this.getClosestPathForLocation(pt.x, pt.y);
                    TreePath pathSource = (TreePath)transferable.getTransferData(flavor);
                    DefaultTreeModel model = (DefaultTreeModel)CTree.this.getModel();
                    TreePath pathNewChild = null;
                    DefaultMutableTreeNode nodeorg = (DefaultMutableTreeNode)pathSource.getLastPathComponent();
                    DefaultMutableTreeNode nodeto = (DefaultMutableTreeNode)pathTarget.getLastPathComponent();
                    CTree.this.dropped = true;
                    if (!nodeorg.isLeaf()) {
                        for (DefaultMutableTreeNode parent = nodeto; parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
                            if (!parent.equals(nodeorg)) continue;
                            CTree.this.dropped = false;
                            CTree.this.JML.repaint();
                            return;
                        }
                    }
                    if (CTree.this.dropped) {
                        DefaultMutableTreeNode nodeparentto = nodeto.isLeaf() ? (DefaultMutableTreeNode)pathTarget.getParentPath().getLastPathComponent() : nodeto;
                        TreePath tp = new TreePath(nodeparentto.getPath());
                        if (!CTree.this.isExpanded(tp)) {
                            nodeto = nodeparentto;
                            nodeparentto = (DefaultMutableTreeNode)nodeto.getParent();
                        }
                        int h = 0;
                        for (h = 0; h < nodeparentto.getChildCount() && !nodeparentto.getChildAt(h).equals(nodeto); ++h) {
                        }
                        if (h == nodeparentto.getChildCount()) {
                            h = -1;
                        }
                        model.insertNodeInto(CTree.this.cloneAll(nodeorg), nodeparentto, h + 1);
                    }
                    if (pathNewChild == null) break;
                    CTree.this.setSelectionPath(pathNewChild);
                    break;
                }
                catch (UnsupportedFlavorException ufe) {
                    e2.dropComplete(false);
                    return;
                }
                catch (IOException ioe) {
                    e2.dropComplete(false);
                    return;
                }
            }
            e2.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent e2) {
            if ((e2.getDropAction() & 3) == 0) {
                return false;
            }
            return e2.isDataFlavorSupported(CTransferableTreePath.TREEPATH_FLAVOR);
        }

        public boolean isDropAcceptable(DropTargetDropEvent e2) {
            if ((e2.getDropAction() & 3) == 0) {
                return false;
            }
            return e2.isDataFlavorSupported(CTransferableTreePath.TREEPATH_FLAVOR);
        }
    }
}

