/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric;

import carmetal.eric.JBrowserLauncher;
import carmetal.eric.JHelpPanel;
import carmetal.rene.gui.Global;
import java.net.URL;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class MyJTextPane
extends JEditorPane
implements HyperlinkListener {
    private static final long serialVersionUID = 1L;
    String content;
    HTMLEditorKit editorkit;
    HTMLDocument doc;
    JHelpPanel JP;

    public MyJTextPane(JHelpPanel jp) {
        this.JP = jp;
        this.setContentType("text/html;");
        this.editorkit = (HTMLEditorKit)this.getEditorKit();
        this.doc = (HTMLDocument)this.getDocument();
        StyleSheet myStyleSheet = new StyleSheet();
        myStyleSheet.addRule("body {color: #333333;font-family: Verdana, Arial, Helvetica, sans-serif;text-align: justify;font-size: 10px;background-color: #F1F3F9;}");
        myStyleSheet.addRule("ul {text-align: left;list-style-type: disc;padding-left: 15px;list-style-position: outside;}");
        myStyleSheet.addRule(".pfooter {text-align: center;font-size: 10px;padding-bottom: 5px;padding-top: 5px;background-color: #eaedf3;}");
        myStyleSheet.addRule(".pfootertitle {font-weight: bold;text-align: center;font-size: 10px;padding-bottom: 5px;padding-top: 5px;background-color: #DBDDE3;}");
        myStyleSheet.addRule("a {color: #0a9100;text-decoration: none;}");
        myStyleSheet.addRule(".aanchor {color: #CC6633;}");
        myStyleSheet.addRule(".centered {text-align: center;}");
        myStyleSheet.addRule(".comment {text-align: center;font-size: 9px;font-style: oblique;font-weight: normal;}");
        myStyleSheet.addRule(".comment2 {text-align: justify;font-size: 9px;font-style: oblique;font-weight: normal;}");
        myStyleSheet.addRule(".ttle {color: #000000;font-family: Verdana, Arial, Helvetica, sans-serif;text-align: center;font-weight: bold;font-size: 11px;background-color: #DBDDE3;}");
        myStyleSheet.addRule(".tab {border-width: 1px;border-color: #909090;border-style:solid;}");
        myStyleSheet.addRule(".tds {border-width: 1px;border-color: #909090;border-style:solid;background-color: #DBDDE3;}");
        myStyleSheet.addRule(".image {border-width: 1px;border-color: #909090;border-style:solid;background-color: #F1F3F9;}");
        this.editorkit.setStyleSheet(myStyleSheet);
        this.setEditable(false);
        this.addHyperlinkListener(this);
    }

    void fixImagePath() {
        String SP = System.getProperty("file.separator");
        Pattern p = Pattern.compile("(<img [^>]*src=\")(images/)([^\"]+)(\"[^>]*>)", 2);
        Matcher m = p.matcher(this.content);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String myst = "<p class=\"centered\">" + m.group(1) + "file:///";
            myst = myst + Global.getHomeDirectory().replace("\\", "\\\\");
            myst = myst + "docs/images/".replace("/", SP).replace("\\", "\\\\");
            myst = myst + m.group(3).replace("/", SP).replace("\\", "\\\\");
            ImageIcon myimg = new ImageIcon(Global.getHomeDirectory() + "docs/images/" + m.group(3));
            if (myimg != null) {
                myst = myst + "\" width=\"" + myimg.getIconWidth() + "\" height=\"" + myimg.getIconHeight() + "\"";
            }
            myst = myst + m.group(4);
            myst = myst + "</p>";
            m.appendReplacement(sb, myst);
        }
        m.appendTail(sb);
        m.reset();
        this.content = sb.toString();
        p = Pattern.compile("(<img [^>]*src=\")(#)([^\"]+)(\"[^>]*>)", 2);
        m = p.matcher(this.content);
        sb = new StringBuffer();
        while (m.find()) {
            URL myIMG = Global.getPath("carmetal.eric/GUI/icons/" + m.group(3));
            if (myIMG == null) continue;
            String myst = m.group(1);
            myst = myst + myIMG.toString();
            myst = myst + m.group(4);
            m.appendReplacement(sb, myst);
        }
        m.appendTail(sb);
        m.reset();
        this.content = sb.toString();
    }

    void setTitle() {
        if (this.content.equals("")) {
            return;
        }
        this.content = this.content.replace("href=\"#", "class=\"aanchor\" href=\"#");
        URL myIMG = Global.getPath("carmetal.eric/GUI/icons/palette/" + JHelpPanel.Subject + ".png");
        String mytitle = this.content.substring(0, this.content.indexOf("<br>"));
        String tag = "";
        if (myIMG == null) {
            tag = "<table class=\"tab\" width=\"100%\" cellpadding=\"4\" cellspacing=\"0\"><tr border=\"1\">";
            tag = tag + "<td class=\"ttle\">" + mytitle + "</td>";
            tag = tag + "</tr></table>";
        } else {
            tag = "<table class=\"tab\" width=\"100%\" border=\"1\" cellpadding=\"4\" cellspacing=\"0\"><tr>";
            tag = tag + "<td class=\"ttle\">" + mytitle + "</td>";
            tag = tag + "<td class=\"ttle\" width=\"40\"><p class=\"image\"><img src=\"" + myIMG.toString() + "\"></p></td>";
            tag = tag + "</tr></table>";
        }
        this.content = this.content.replaceFirst(mytitle, tag);
    }

    void setFooter() {
        Enumeration e2 = this.JP.Related.elements();
        String tag = "";
        while (e2.hasMoreElements()) {
            String topic = (String)e2.nextElement();
            String topicTitle = "";
            Enumeration ev = this.JP.Other.elements();
            while (ev.hasMoreElements()) {
                String[] s = (String[])ev.nextElement();
                if (!s[0].equals(topic)) continue;
                topicTitle = s[1];
                break;
            }
            tag = tag + "<tr><td class=\"pfooter\"><a class=\"aanchor\" href=\"#" + topic + "\">" + topicTitle + "</a></td></tr>";
        }
        if (!tag.equals("")) {
            this.content = this.content + "<table  class=\"tab\" width=\"100%\" border=\"1\" cellpadding=\"4\" cellspacing=\"0\">";
            this.content = this.content + "<tr><td class=\"pfootertitle\">" + Global.Loc("contexthelp.seealso") + "</tr></td>";
            this.content = this.content + tag;
            this.content = this.content + "</table>";
        }
    }

    void setContent(String s) {
        try {
            this.content = s;
            this.fixImagePath();
            this.setTitle();
            this.setFooter();
            this.editorkit.insertHTML(this.doc, this.doc.getLength(), this.content, 0, 0, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent r) {
        if (r.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String lnk = "";
            if (r.getDescription().startsWith("#")) {
                JHelpPanel.Subject = lnk = r.getDescription().substring(1);
                this.JP.clearSearchTxtField();
                this.JP.fill(true);
                return;
            }
            lnk = r.getDescription();
            if (!lnk.startsWith("http://")) {
                lnk = "http://" + lnk;
            }
            JBrowserLauncher.openURL(lnk);
            return;
        }
    }
}

