/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric;

import carmetal.eric.FileTools;
import carmetal.rene.util.FileName;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class Media {
    private byte[] imagebytes;
    private String imagefilename;
    private static ArrayList<Media> medias = new ArrayList();

    private Media(String name, byte[] datas) {
        this.imagefilename = name;
        this.imagebytes = datas;
    }

    private Media(String name, InputStream in) {
        this(name, FileTools.copyToByteArray(in));
    }

    public String getImageFileName() {
        return this.imagefilename;
    }

    public byte[] getImageBytes() {
        return this.imagebytes;
    }

    public static ArrayList<Media> getMedias() {
        return medias;
    }

    public static void clearMedias() {
        medias = null;
        medias = new ArrayList();
    }

    public static void createMedia(String name, byte[] datas) {
        medias.add(new Media(name, datas));
    }

    public static void createMedia(String filename) {
        String shortname = FileName.filename(filename);
        for (int i = 0; i < medias.size(); ++i) {
            if (!shortname.equals(Media.medias.get((int)i).imagefilename)) continue;
            return;
        }
        try {
            FileInputStream in = new FileInputStream(new File(filename));
            medias.add(new Media(shortname, in));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Image getImage(String name) {
        String shortname = FileName.filename(name);
        for (int i = 0; i < medias.size(); ++i) {
            if (!shortname.equals(Media.medias.get((int)i).imagefilename)) continue;
            try {
                ByteArrayInputStream ba = new ByteArrayInputStream(Media.medias.get((int)i).imagebytes);
                BufferedImage img = ImageIO.read(ba);
                return img;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

